/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Result structure for the get artifact request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetArtifactUrlResponse extends AmplifyResponse implements
        ToCopyableBuilder<GetArtifactUrlResponse.Builder, GetArtifactUrlResponse> {
    private static final SdkField<String> ARTIFACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetArtifactUrlResponse::artifactId)).setter(setter(Builder::artifactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactId").build()).build();

    private static final SdkField<String> ARTIFACT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetArtifactUrlResponse::artifactUrl)).setter(setter(Builder::artifactUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACT_ID_FIELD,
            ARTIFACT_URL_FIELD));

    private final String artifactId;

    private final String artifactUrl;

    private GetArtifactUrlResponse(BuilderImpl builder) {
        super(builder);
        this.artifactId = builder.artifactId;
        this.artifactUrl = builder.artifactUrl;
    }

    /**
     * <p>
     * Unique Id for a artifact.
     * </p>
     * 
     * @return Unique Id for a artifact.
     */
    public String artifactId() {
        return artifactId;
    }

    /**
     * <p>
     * Presigned url for the artifact.
     * </p>
     * 
     * @return Presigned url for the artifact.
     */
    public String artifactUrl() {
        return artifactUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(artifactId());
        hashCode = 31 * hashCode + Objects.hashCode(artifactUrl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetArtifactUrlResponse)) {
            return false;
        }
        GetArtifactUrlResponse other = (GetArtifactUrlResponse) obj;
        return Objects.equals(artifactId(), other.artifactId()) && Objects.equals(artifactUrl(), other.artifactUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetArtifactUrlResponse").add("ArtifactId", artifactId()).add("ArtifactUrl", artifactUrl())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "artifactId":
            return Optional.ofNullable(clazz.cast(artifactId()));
        case "artifactUrl":
            return Optional.ofNullable(clazz.cast(artifactUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetArtifactUrlResponse, T> g) {
        return obj -> g.apply((GetArtifactUrlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetArtifactUrlResponse> {
        /**
         * <p>
         * Unique Id for a artifact.
         * </p>
         * 
         * @param artifactId
         *        Unique Id for a artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactId(String artifactId);

        /**
         * <p>
         * Presigned url for the artifact.
         * </p>
         * 
         * @param artifactUrl
         *        Presigned url for the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactUrl(String artifactUrl);
    }

    static final class BuilderImpl extends AmplifyResponse.BuilderImpl implements Builder {
        private String artifactId;

        private String artifactUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(GetArtifactUrlResponse model) {
            super(model);
            artifactId(model.artifactId);
            artifactUrl(model.artifactUrl);
        }

        public final String getArtifactId() {
            return artifactId;
        }

        @Override
        public final Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public final void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public final String getArtifactUrl() {
            return artifactUrl;
        }

        @Override
        public final Builder artifactUrl(String artifactUrl) {
            this.artifactUrl = artifactUrl;
            return this;
        }

        public final void setArtifactUrl(String artifactUrl) {
            this.artifactUrl = artifactUrl;
        }

        @Override
        public GetArtifactUrlResponse build() {
            return new GetArtifactUrlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
