/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Result structure for create a new deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDeploymentResponse extends AmplifyResponse implements
        ToCopyableBuilder<CreateDeploymentResponse.Builder, CreateDeploymentResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDeploymentResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<Map<String, String>> FILE_UPLOAD_URLS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateDeploymentResponse::fileUploadUrls))
            .setter(setter(Builder::fileUploadUrls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileUploadUrls").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ZIP_UPLOAD_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDeploymentResponse::zipUploadUrl)).setter(setter(Builder::zipUploadUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zipUploadUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            FILE_UPLOAD_URLS_FIELD, ZIP_UPLOAD_URL_FIELD));

    private final String jobId;

    private final Map<String, String> fileUploadUrls;

    private final String zipUploadUrl;

    private CreateDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.fileUploadUrls = builder.fileUploadUrls;
        this.zipUploadUrl = builder.zipUploadUrl;
    }

    /**
     * <p>
     * The jobId for this deployment, will supply to start deployment api.
     * </p>
     * 
     * @return The jobId for this deployment, will supply to start deployment api.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * When the fileMap argument is provided in the request, the fileUploadUrls will contain a map of file names to
     * upload url.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return When the fileMap argument is provided in the request, the fileUploadUrls will contain a map of file names
     *         to upload url.
     */
    public Map<String, String> fileUploadUrls() {
        return fileUploadUrls;
    }

    /**
     * <p>
     * When the fileMap argument is NOT provided. This zipUploadUrl will be returned.
     * </p>
     * 
     * @return When the fileMap argument is NOT provided. This zipUploadUrl will be returned.
     */
    public String zipUploadUrl() {
        return zipUploadUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(fileUploadUrls());
        hashCode = 31 * hashCode + Objects.hashCode(zipUploadUrl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentResponse)) {
            return false;
        }
        CreateDeploymentResponse other = (CreateDeploymentResponse) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(fileUploadUrls(), other.fileUploadUrls())
                && Objects.equals(zipUploadUrl(), other.zipUploadUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDeploymentResponse").add("JobId", jobId()).add("FileUploadUrls", fileUploadUrls())
                .add("ZipUploadUrl", zipUploadUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "fileUploadUrls":
            return Optional.ofNullable(clazz.cast(fileUploadUrls()));
        case "zipUploadUrl":
            return Optional.ofNullable(clazz.cast(zipUploadUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentResponse, T> g) {
        return obj -> g.apply((CreateDeploymentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDeploymentResponse> {
        /**
         * <p>
         * The jobId for this deployment, will supply to start deployment api.
         * </p>
         * 
         * @param jobId
         *        The jobId for this deployment, will supply to start deployment api.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * When the fileMap argument is provided in the request, the fileUploadUrls will contain a map of file names to
         * upload url.
         * </p>
         * 
         * @param fileUploadUrls
         *        When the fileMap argument is provided in the request, the fileUploadUrls will contain a map of file
         *        names to upload url.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileUploadUrls(Map<String, String> fileUploadUrls);

        /**
         * <p>
         * When the fileMap argument is NOT provided. This zipUploadUrl will be returned.
         * </p>
         * 
         * @param zipUploadUrl
         *        When the fileMap argument is NOT provided. This zipUploadUrl will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zipUploadUrl(String zipUploadUrl);
    }

    static final class BuilderImpl extends AmplifyResponse.BuilderImpl implements Builder {
        private String jobId;

        private Map<String, String> fileUploadUrls = DefaultSdkAutoConstructMap.getInstance();

        private String zipUploadUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentResponse model) {
            super(model);
            jobId(model.jobId);
            fileUploadUrls(model.fileUploadUrls);
            zipUploadUrl(model.zipUploadUrl);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final Map<String, String> getFileUploadUrls() {
            return fileUploadUrls;
        }

        @Override
        public final Builder fileUploadUrls(Map<String, String> fileUploadUrls) {
            this.fileUploadUrls = FileUploadUrlsCopier.copy(fileUploadUrls);
            return this;
        }

        public final void setFileUploadUrls(Map<String, String> fileUploadUrls) {
            this.fileUploadUrls = FileUploadUrlsCopier.copy(fileUploadUrls);
        }

        public final String getZipUploadUrl() {
            return zipUploadUrl;
        }

        @Override
        public final Builder zipUploadUrl(String zipUploadUrl) {
            this.zipUploadUrl = zipUploadUrl;
            return this;
        }

        public final void setZipUploadUrl(String zipUploadUrl) {
            this.zipUploadUrl = zipUploadUrl;
        }

        @Override
        public CreateDeploymentResponse build() {
            return new CreateDeploymentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
