/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Custom rewrite / redirect rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomRule implements SdkPojo, Serializable, ToCopyableBuilder<CustomRule.Builder, CustomRule> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CustomRule::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CustomRule::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CustomRule::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CustomRule::condition)).setter(setter(Builder::condition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, TARGET_FIELD,
            STATUS_FIELD, CONDITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String source;

    private final String target;

    private final String status;

    private final String condition;

    private CustomRule(BuilderImpl builder) {
        this.source = builder.source;
        this.target = builder.target;
        this.status = builder.status;
        this.condition = builder.condition;
    }

    /**
     * <p>
     * The source pattern for a URL rewrite or redirect rule.
     * </p>
     * 
     * @return The source pattern for a URL rewrite or redirect rule.
     */
    public String source() {
        return source;
    }

    /**
     * <p>
     * The target pattern for a URL rewrite or redirect rule.
     * </p>
     * 
     * @return The target pattern for a URL rewrite or redirect rule.
     */
    public String target() {
        return target;
    }

    /**
     * <p>
     * The status code for a URL rewrite or redirect rule.
     * </p>
     * 
     * @return The status code for a URL rewrite or redirect rule.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The condition for a URL rewrite or redirect rule, e.g. country code.
     * </p>
     * 
     * @return The condition for a URL rewrite or redirect rule, e.g. country code.
     */
    public String condition() {
        return condition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomRule)) {
            return false;
        }
        CustomRule other = (CustomRule) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(target(), other.target())
                && Objects.equals(status(), other.status()) && Objects.equals(condition(), other.condition());
    }

    @Override
    public String toString() {
        return ToString.builder("CustomRule").add("Source", source()).add("Target", target()).add("Status", status())
                .add("Condition", condition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "condition":
            return Optional.ofNullable(clazz.cast(condition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomRule, T> g) {
        return obj -> g.apply((CustomRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomRule> {
        /**
         * <p>
         * The source pattern for a URL rewrite or redirect rule.
         * </p>
         * 
         * @param source
         *        The source pattern for a URL rewrite or redirect rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The target pattern for a URL rewrite or redirect rule.
         * </p>
         * 
         * @param target
         *        The target pattern for a URL rewrite or redirect rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * The status code for a URL rewrite or redirect rule.
         * </p>
         * 
         * @param status
         *        The status code for a URL rewrite or redirect rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The condition for a URL rewrite or redirect rule, e.g. country code.
         * </p>
         * 
         * @param condition
         *        The condition for a URL rewrite or redirect rule, e.g. country code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(String condition);
    }

    static final class BuilderImpl implements Builder {
        private String source;

        private String target;

        private String status;

        private String condition;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomRule model) {
            source(model.source);
            target(model.target);
            status(model.status);
            condition(model.condition);
        }

        public final String getSource() {
            return source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getTarget() {
            return target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCondition() {
            return condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        public CustomRule build() {
            return new CustomRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
