/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.account.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.account.model.AccountRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AcceptPrimaryEmailUpdateRequest
extends AccountRequest
implements ToCopyableBuilder<Builder, AcceptPrimaryEmailUpdateRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(AcceptPrimaryEmailUpdateRequest.getter(AcceptPrimaryEmailUpdateRequest::accountId)).setter(AcceptPrimaryEmailUpdateRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> OTP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Otp").getter(AcceptPrimaryEmailUpdateRequest.getter(AcceptPrimaryEmailUpdateRequest::otp)).setter(AcceptPrimaryEmailUpdateRequest.setter(Builder::otp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Otp").build()}).build();
    private static final SdkField<String> PRIMARY_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryEmail").getter(AcceptPrimaryEmailUpdateRequest.getter(AcceptPrimaryEmailUpdateRequest::primaryEmail)).setter(AcceptPrimaryEmailUpdateRequest.setter(Builder::primaryEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryEmail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, OTP_FIELD, PRIMARY_EMAIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AcceptPrimaryEmailUpdateRequest.memberNameToFieldInitializer();
    private final String accountId;
    private final String otp;
    private final String primaryEmail;

    private AcceptPrimaryEmailUpdateRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.otp = builder.otp;
        this.primaryEmail = builder.primaryEmail;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String otp() {
        return this.otp;
    }

    public final String primaryEmail() {
        return this.primaryEmail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.otp());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryEmail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptPrimaryEmailUpdateRequest)) {
            return false;
        }
        AcceptPrimaryEmailUpdateRequest other = (AcceptPrimaryEmailUpdateRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.otp(), other.otp()) && Objects.equals(this.primaryEmail(), other.primaryEmail());
    }

    public final String toString() {
        return ToString.builder((String)"AcceptPrimaryEmailUpdateRequest").add("AccountId", (Object)this.accountId()).add("Otp", (Object)(this.otp() == null ? null : "*** Sensitive Data Redacted ***")).add("PrimaryEmail", (Object)(this.primaryEmail() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "Otp": {
                return Optional.ofNullable(clazz.cast(this.otp()));
            }
            case "PrimaryEmail": {
                return Optional.ofNullable(clazz.cast(this.primaryEmail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("Otp", OTP_FIELD);
        map.put("PrimaryEmail", PRIMARY_EMAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AcceptPrimaryEmailUpdateRequest, T> g) {
        return obj -> g.apply((AcceptPrimaryEmailUpdateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccountRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String otp;
        private String primaryEmail;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptPrimaryEmailUpdateRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.otp(model.otp);
            this.primaryEmail(model.primaryEmail);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getOtp() {
            return this.otp;
        }

        public final void setOtp(String otp) {
            this.otp = otp;
        }

        @Override
        public final Builder otp(String otp) {
            this.otp = otp;
            return this;
        }

        public final String getPrimaryEmail() {
            return this.primaryEmail;
        }

        public final void setPrimaryEmail(String primaryEmail) {
            this.primaryEmail = primaryEmail;
        }

        @Override
        public final Builder primaryEmail(String primaryEmail) {
            this.primaryEmail = primaryEmail;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptPrimaryEmailUpdateRequest build() {
            return new AcceptPrimaryEmailUpdateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AccountRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AcceptPrimaryEmailUpdateRequest> {
        public Builder accountId(String var1);

        public Builder otp(String var1);

        public Builder primaryEmail(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

