/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.account.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.account.AccountAsyncClient;
import software.amazon.awssdk.services.account.model.ListRegionsRequest;
import software.amazon.awssdk.services.account.model.ListRegionsResponse;

public class ListRegionsPublisher
implements SdkPublisher<ListRegionsResponse> {
    private final AccountAsyncClient client;
    private final ListRegionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRegionsPublisher(AccountAsyncClient client, ListRegionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRegionsPublisher(AccountAsyncClient client, ListRegionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRegionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRegionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListRegionsResponseFetcher
    implements AsyncPageFetcher<ListRegionsResponse> {
        private ListRegionsResponseFetcher() {
        }

        public boolean hasNextPage(ListRegionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRegionsResponse> nextPage(ListRegionsResponse previousPage) {
            if (previousPage == null) {
                return ListRegionsPublisher.this.client.listRegions(ListRegionsPublisher.this.firstRequest);
            }
            return ListRegionsPublisher.this.client.listRegions((ListRegionsRequest)((Object)ListRegionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

