package software.amazon.awscdk.services.wisdom;

/**
 * A CloudFormation `AWS::Wisdom::KnowledgeBase`.
 * <p>
 * Specifies a knowledge base.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wisdom.*;
 * CfnKnowledgeBase cfnKnowledgeBase = CfnKnowledgeBase.Builder.create(this, "MyCfnKnowledgeBase")
 *         .knowledgeBaseType("knowledgeBaseType")
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .renderingConfiguration(RenderingConfigurationProperty.builder()
 *                 .templateUri("templateUri")
 *                 .build())
 *         .serverSideEncryptionConfiguration(ServerSideEncryptionConfigurationProperty.builder()
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .sourceConfiguration(SourceConfigurationProperty.builder()
 *                 .appIntegrations(AppIntegrationsConfigurationProperty.builder()
 *                         .appIntegrationArn("appIntegrationArn")
 *                         .objectFields(List.of("objectFields"))
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:12.628Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_wisdom.CfnKnowledgeBase")
public class CfnKnowledgeBase extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnKnowledgeBase(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnKnowledgeBase(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Wisdom::KnowledgeBase`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnKnowledgeBase(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.wisdom.CfnKnowledgeBaseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrKnowledgeBaseArn() {
        return software.amazon.jsii.Kernel.get(this, "attrKnowledgeBaseArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrKnowledgeBaseId() {
        return software.amazon.jsii.Kernel.get(this, "attrKnowledgeBaseId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The type of knowledge base.
     * <p>
     * Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL knowledge bases support integrations with third-party systems whose content is synchronized automatically.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKnowledgeBaseType() {
        return software.amazon.jsii.Kernel.get(this, "knowledgeBaseType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of knowledge base.
     * <p>
     * Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL knowledge bases support integrations with third-party systems whose content is synchronized automatically.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKnowledgeBaseType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "knowledgeBaseType", java.util.Objects.requireNonNull(value, "knowledgeBaseType is required"));
    }

    /**
     * The name of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Information about how to render the content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRenderingConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "renderingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about how to render the content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRenderingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.RenderingConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "renderingConfiguration", value);
    }

    /**
     * Information about how to render the content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRenderingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "renderingConfiguration", value);
    }

    /**
     * The KMS key used for encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getServerSideEncryptionConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "serverSideEncryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The KMS key used for encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerSideEncryptionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.ServerSideEncryptionConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "serverSideEncryptionConfiguration", value);
    }

    /**
     * The KMS key used for encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerSideEncryptionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "serverSideEncryptionConfiguration", value);
    }

    /**
     * The source of the knowledge base content.
     * <p>
     * Only set this argument for EXTERNAL knowledge bases.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSourceConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "sourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The source of the knowledge base content.
     * <p>
     * Only set this argument for EXTERNAL knowledge bases.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.SourceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "sourceConfiguration", value);
    }

    /**
     * The source of the knowledge base content.
     * <p>
     * Only set this argument for EXTERNAL knowledge bases.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sourceConfiguration", value);
    }
    /**
     * Configuration information for Amazon AppIntegrations to automatically ingest content.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * AppIntegrationsConfigurationProperty appIntegrationsConfigurationProperty = AppIntegrationsConfigurationProperty.builder()
     *         .appIntegrationArn("appIntegrationArn")
     *         .objectFields(List.of("objectFields"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_wisdom.CfnKnowledgeBase.AppIntegrationsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AppIntegrationsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AppIntegrationsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the AppIntegrations DataIntegration to use for ingesting content.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAppIntegrationArn();

        /**
         * The fields from the source that are made available to your agents in Wisdom.
         * <p>
         * <ul>
         * <li>For <a href="https://docs.aws.amazon.com/https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm">Salesforce</a> , you must include at least <code>Id</code> , <code>ArticleNumber</code> , <code>VersionNumber</code> , <code>Title</code> , <code>PublishStatus</code> , and <code>IsDeleted</code> .</li>
         * <li>For <a href="https://docs.aws.amazon.com/https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api">ServiceNow</a> , you must include at least <code>number</code> , <code>short_description</code> , <code>sys_mod_count</code> , <code>workflow_state</code> , and <code>active</code> .</li>
         * </ul>
         * <p>
         * Make sure to include additional fields. These fields are indexed and used to source recommendations.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getObjectFields();

        /**
         * @return a {@link Builder} of {@link AppIntegrationsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AppIntegrationsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AppIntegrationsConfigurationProperty> {
            java.lang.String appIntegrationArn;
            java.util.List<java.lang.String> objectFields;

            /**
             * Sets the value of {@link AppIntegrationsConfigurationProperty#getAppIntegrationArn}
             * @param appIntegrationArn The Amazon Resource Name (ARN) of the AppIntegrations DataIntegration to use for ingesting content. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appIntegrationArn(java.lang.String appIntegrationArn) {
                this.appIntegrationArn = appIntegrationArn;
                return this;
            }

            /**
             * Sets the value of {@link AppIntegrationsConfigurationProperty#getObjectFields}
             * @param objectFields The fields from the source that are made available to your agents in Wisdom. This parameter is required.
             *                     <ul>
             *                     <li>For <a href="https://docs.aws.amazon.com/https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm">Salesforce</a> , you must include at least <code>Id</code> , <code>ArticleNumber</code> , <code>VersionNumber</code> , <code>Title</code> , <code>PublishStatus</code> , and <code>IsDeleted</code> .</li>
             *                     <li>For <a href="https://docs.aws.amazon.com/https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api">ServiceNow</a> , you must include at least <code>number</code> , <code>short_description</code> , <code>sys_mod_count</code> , <code>workflow_state</code> , and <code>active</code> .</li>
             *                     </ul>
             *                     <p>
             *                     Make sure to include additional fields. These fields are indexed and used to source recommendations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectFields(java.util.List<java.lang.String> objectFields) {
                this.objectFields = objectFields;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AppIntegrationsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AppIntegrationsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AppIntegrationsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppIntegrationsConfigurationProperty {
            private final java.lang.String appIntegrationArn;
            private final java.util.List<java.lang.String> objectFields;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appIntegrationArn = software.amazon.jsii.Kernel.get(this, "appIntegrationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.objectFields = software.amazon.jsii.Kernel.get(this, "objectFields", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appIntegrationArn = java.util.Objects.requireNonNull(builder.appIntegrationArn, "appIntegrationArn is required");
                this.objectFields = java.util.Objects.requireNonNull(builder.objectFields, "objectFields is required");
            }

            @Override
            public final java.lang.String getAppIntegrationArn() {
                return this.appIntegrationArn;
            }

            @Override
            public final java.util.List<java.lang.String> getObjectFields() {
                return this.objectFields;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("appIntegrationArn", om.valueToTree(this.getAppIntegrationArn()));
                data.set("objectFields", om.valueToTree(this.getObjectFields()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_wisdom.CfnKnowledgeBase.AppIntegrationsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AppIntegrationsConfigurationProperty.Jsii$Proxy that = (AppIntegrationsConfigurationProperty.Jsii$Proxy) o;

                if (!appIntegrationArn.equals(that.appIntegrationArn)) return false;
                return this.objectFields.equals(that.objectFields);
            }

            @Override
            public final int hashCode() {
                int result = this.appIntegrationArn.hashCode();
                result = 31 * result + (this.objectFields.hashCode());
                return result;
            }
        }
    }
    /**
     * Information about how to render the content.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * RenderingConfigurationProperty renderingConfigurationProperty = RenderingConfigurationProperty.builder()
     *         .templateUri("templateUri")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_wisdom.CfnKnowledgeBase.RenderingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RenderingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RenderingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A URI template containing exactly one variable in `${variableName}` format.
         * <p>
         * This can only be set for <code>EXTERNAL</code> knowledge bases. For Salesforce and ServiceNow, the variable must be one of the following:
         * <p>
         * <ul>
         * <li>Salesforce: <code>Id</code> , <code>ArticleNumber</code> , <code>VersionNumber</code> , <code>Title</code> , <code>PublishStatus</code> , or <code>IsDeleted</code></li>
         * <li>ServiceNow: <code>number</code> , <code>short_description</code> , <code>sys_mod_count</code> , <code>workflow_state</code> , or <code>active</code></li>
         * </ul>
         * <p>
         * The variable is replaced with the actual value for a piece of content when calling <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetContent.html">GetContent</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTemplateUri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RenderingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RenderingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RenderingConfigurationProperty> {
            java.lang.String templateUri;

            /**
             * Sets the value of {@link RenderingConfigurationProperty#getTemplateUri}
             * @param templateUri A URI template containing exactly one variable in `${variableName}` format.
             *                    This can only be set for <code>EXTERNAL</code> knowledge bases. For Salesforce and ServiceNow, the variable must be one of the following:
             *                    <p>
             *                    <ul>
             *                    <li>Salesforce: <code>Id</code> , <code>ArticleNumber</code> , <code>VersionNumber</code> , <code>Title</code> , <code>PublishStatus</code> , or <code>IsDeleted</code></li>
             *                    <li>ServiceNow: <code>number</code> , <code>short_description</code> , <code>sys_mod_count</code> , <code>workflow_state</code> , or <code>active</code></li>
             *                    </ul>
             *                    <p>
             *                    The variable is replaced with the actual value for a piece of content when calling <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetContent.html">GetContent</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateUri(java.lang.String templateUri) {
                this.templateUri = templateUri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RenderingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RenderingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RenderingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RenderingConfigurationProperty {
            private final java.lang.String templateUri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.templateUri = software.amazon.jsii.Kernel.get(this, "templateUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.templateUri = builder.templateUri;
            }

            @Override
            public final java.lang.String getTemplateUri() {
                return this.templateUri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTemplateUri() != null) {
                    data.set("templateUri", om.valueToTree(this.getTemplateUri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_wisdom.CfnKnowledgeBase.RenderingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RenderingConfigurationProperty.Jsii$Proxy that = (RenderingConfigurationProperty.Jsii$Proxy) o;

                return this.templateUri != null ? this.templateUri.equals(that.templateUri) : that.templateUri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.templateUri != null ? this.templateUri.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The KMS key used for encryption.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * ServerSideEncryptionConfigurationProperty serverSideEncryptionConfigurationProperty = ServerSideEncryptionConfigurationProperty.builder()
     *         .kmsKeyId("kmsKeyId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_wisdom.CfnKnowledgeBase.ServerSideEncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ServerSideEncryptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerSideEncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The KMS key .
         * <p>
         * For information about valid ID values, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServerSideEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServerSideEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServerSideEncryptionConfigurationProperty> {
            java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link ServerSideEncryptionConfigurationProperty#getKmsKeyId}
             * @param kmsKeyId The KMS key .
             *                 For information about valid ID values, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerSideEncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServerSideEncryptionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServerSideEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerSideEncryptionConfigurationProperty {
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsKeyId = builder.kmsKeyId;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_wisdom.CfnKnowledgeBase.ServerSideEncryptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerSideEncryptionConfigurationProperty.Jsii$Proxy that = (ServerSideEncryptionConfigurationProperty.Jsii$Proxy) o;

                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Configuration information about the external data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * SourceConfigurationProperty sourceConfigurationProperty = SourceConfigurationProperty.builder()
     *         .appIntegrations(AppIntegrationsConfigurationProperty.builder()
     *                 .appIntegrationArn("appIntegrationArn")
     *                 .objectFields(List.of("objectFields"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_wisdom.CfnKnowledgeBase.SourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration information for Amazon AppIntegrations to automatically ingest content.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAppIntegrations();

        /**
         * @return a {@link Builder} of {@link SourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceConfigurationProperty> {
            java.lang.Object appIntegrations;

            /**
             * Sets the value of {@link SourceConfigurationProperty#getAppIntegrations}
             * @param appIntegrations Configuration information for Amazon AppIntegrations to automatically ingest content. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appIntegrations(software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.AppIntegrationsConfigurationProperty appIntegrations) {
                this.appIntegrations = appIntegrations;
                return this;
            }

            /**
             * Sets the value of {@link SourceConfigurationProperty#getAppIntegrations}
             * @param appIntegrations Configuration information for Amazon AppIntegrations to automatically ingest content. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appIntegrations(software.amazon.awscdk.core.IResolvable appIntegrations) {
                this.appIntegrations = appIntegrations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceConfigurationProperty {
            private final java.lang.Object appIntegrations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appIntegrations = software.amazon.jsii.Kernel.get(this, "appIntegrations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appIntegrations = java.util.Objects.requireNonNull(builder.appIntegrations, "appIntegrations is required");
            }

            @Override
            public final java.lang.Object getAppIntegrations() {
                return this.appIntegrations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("appIntegrations", om.valueToTree(this.getAppIntegrations()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_wisdom.CfnKnowledgeBase.SourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceConfigurationProperty.Jsii$Proxy that = (SourceConfigurationProperty.Jsii$Proxy) o;

                return this.appIntegrations.equals(that.appIntegrations);
            }

            @Override
            public final int hashCode() {
                int result = this.appIntegrations.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.wisdom.CfnKnowledgeBase}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.wisdom.CfnKnowledgeBase> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.wisdom.CfnKnowledgeBaseProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.wisdom.CfnKnowledgeBaseProps.Builder();
        }

        /**
         * The type of knowledge base.
         * <p>
         * Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL knowledge bases support integrations with third-party systems whose content is synchronized automatically.
         * <p>
         * @return {@code this}
         * @param knowledgeBaseType The type of knowledge base. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder knowledgeBaseType(final java.lang.String knowledgeBaseType) {
            this.props.knowledgeBaseType(knowledgeBaseType);
            return this;
        }

        /**
         * The name of the knowledge base.
         * <p>
         * @return {@code this}
         * @param name The name of the knowledge base. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The description.
         * <p>
         * @return {@code this}
         * @param description The description. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Information about how to render the content.
         * <p>
         * @return {@code this}
         * @param renderingConfiguration Information about how to render the content. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder renderingConfiguration(final software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.RenderingConfigurationProperty renderingConfiguration) {
            this.props.renderingConfiguration(renderingConfiguration);
            return this;
        }
        /**
         * Information about how to render the content.
         * <p>
         * @return {@code this}
         * @param renderingConfiguration Information about how to render the content. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder renderingConfiguration(final software.amazon.awscdk.core.IResolvable renderingConfiguration) {
            this.props.renderingConfiguration(renderingConfiguration);
            return this;
        }

        /**
         * The KMS key used for encryption.
         * <p>
         * @return {@code this}
         * @param serverSideEncryptionConfiguration The KMS key used for encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryptionConfiguration(final software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.ServerSideEncryptionConfigurationProperty serverSideEncryptionConfiguration) {
            this.props.serverSideEncryptionConfiguration(serverSideEncryptionConfiguration);
            return this;
        }
        /**
         * The KMS key used for encryption.
         * <p>
         * @return {@code this}
         * @param serverSideEncryptionConfiguration The KMS key used for encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryptionConfiguration(final software.amazon.awscdk.core.IResolvable serverSideEncryptionConfiguration) {
            this.props.serverSideEncryptionConfiguration(serverSideEncryptionConfiguration);
            return this;
        }

        /**
         * The source of the knowledge base content.
         * <p>
         * Only set this argument for EXTERNAL knowledge bases.
         * <p>
         * @return {@code this}
         * @param sourceConfiguration The source of the knowledge base content. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceConfiguration(final software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.SourceConfigurationProperty sourceConfiguration) {
            this.props.sourceConfiguration(sourceConfiguration);
            return this;
        }
        /**
         * The source of the knowledge base content.
         * <p>
         * Only set this argument for EXTERNAL knowledge bases.
         * <p>
         * @return {@code this}
         * @param sourceConfiguration The source of the knowledge base content. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceConfiguration(final software.amazon.awscdk.core.IResolvable sourceConfiguration) {
            this.props.sourceConfiguration(sourceConfiguration);
            return this;
        }

        /**
         * The tags used to organize, track, or control access for this resource.
         * <p>
         * @return {@code this}
         * @param tags The tags used to organize, track, or control access for this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.wisdom.CfnKnowledgeBase}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.wisdom.CfnKnowledgeBase build() {
            return new software.amazon.awscdk.services.wisdom.CfnKnowledgeBase(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
