package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * (experimental) Properties for publishing a message to an SNS topic.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EvaluateExpression convertToSeconds = EvaluateExpression.Builder.create(this, "Convert to seconds")
 *         .expression("$.waitMilliseconds / 1000")
 *         .resultPath("$.waitSeconds")
 *         .build();
 * EvaluateExpression createMessage = EvaluateExpression.Builder.create(this, "Create message")
 *         // Note: this is a string inside a string.
 *         .expression("`Now waiting ${$.waitSeconds} seconds...`")
 *         .runtime(Runtime.NODEJS_14_X)
 *         .resultPath("$.message")
 *         .build();
 * SnsPublish publishMessage = SnsPublish.Builder.create(this, "Publish message")
 *         .topic(new Topic(this, "cool-topic"))
 *         .message(TaskInput.fromJsonPathAt("$.message"))
 *         .resultPath("$.sns")
 *         .build();
 * Wait wait = Wait.Builder.create(this, "Wait")
 *         .time(WaitTime.secondsPath("$.waitSeconds"))
 *         .build();
 * StateMachine.Builder.create(this, "StateMachine")
 *         .definition(convertToSeconds.next(createMessage).next(publishMessage).next(wait))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:11.738Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.SnsPublishProps")
@software.amazon.jsii.Jsii.Proxy(SnsPublishProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface SnsPublishProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.TaskStateBaseProps {

    /**
     * (experimental) The message you want to send.
     * <p>
     * With the exception of SMS, messages must be UTF-8 encoded strings and
     * at most 256 KB in size.
     * For SMS, each message can contain up to 140 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.TaskInput getMessage();

    /**
     * (experimental) The SNS topic that the task will publish to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic getTopic();

    /**
     * (experimental) Add message attributes when publishing.
     * <p>
     * These attributes carry additional metadata about the message and may be used
     * for subscription filters.
     * <p>
     * Default: {}
     * <p>
     * @see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html">https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.MessageAttribute> getMessageAttributes() {
        return null;
    }

    /**
     * (experimental) Send different messages for each transport protocol.
     * <p>
     * For example, you might want to send a shorter message to SMS subscribers
     * and a more verbose message to email and SQS subscribers.
     * <p>
     * Your message must be a JSON object with a top-level JSON key of
     * "default" with a value that is a string
     * You can define other top-level keys that define the message you want to
     * send to a specific transport protocol (i.e. "sqs", "email", "http", etc)
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/sns/latest/api/API_Publish.html#API_Publish_RequestParameters">https://docs.aws.amazon.com/sns/latest/api/API_Publish.html#API_Publish_RequestParameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMessagePerSubscriptionType() {
        return null;
    }

    /**
     * (experimental) Used as the "Subject" line when the message is delivered to email endpoints.
     * <p>
     * This field will also be included, if present, in the standard JSON messages
     * delivered to other endpoints.
     * <p>
     * Default: - No subject
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubject() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SnsPublishProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SnsPublishProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<SnsPublishProps> {
        software.amazon.awscdk.services.stepfunctions.TaskInput message;
        software.amazon.awscdk.services.sns.ITopic topic;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.MessageAttribute> messageAttributes;
        java.lang.Boolean messagePerSubscriptionType;
        java.lang.String subject;
        java.lang.String comment;
        software.amazon.awscdk.core.Duration heartbeat;
        java.lang.String inputPath;
        software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        java.lang.String outputPath;
        java.lang.String resultPath;
        java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        software.amazon.awscdk.core.Duration timeout;

        /**
         * Sets the value of {@link SnsPublishProps#getMessage}
         * @param message The message you want to send. This parameter is required.
         *                With the exception of SMS, messages must be UTF-8 encoded strings and
         *                at most 256 KB in size.
         *                For SMS, each message can contain up to 140 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder message(software.amazon.awscdk.services.stepfunctions.TaskInput message) {
            this.message = message;
            return this;
        }

        /**
         * Sets the value of {@link SnsPublishProps#getTopic}
         * @param topic The SNS topic that the task will publish to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder topic(software.amazon.awscdk.services.sns.ITopic topic) {
            this.topic = topic;
            return this;
        }

        /**
         * Sets the value of {@link SnsPublishProps#getMessageAttributes}
         * @param messageAttributes Add message attributes when publishing.
         *                          These attributes carry additional metadata about the message and may be used
         *                          for subscription filters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder messageAttributes(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.stepfunctions.tasks.MessageAttribute> messageAttributes) {
            this.messageAttributes = (java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.MessageAttribute>)messageAttributes;
            return this;
        }

        /**
         * Sets the value of {@link SnsPublishProps#getMessagePerSubscriptionType}
         * @param messagePerSubscriptionType Send different messages for each transport protocol.
         *                                   For example, you might want to send a shorter message to SMS subscribers
         *                                   and a more verbose message to email and SQS subscribers.
         *                                   <p>
         *                                   Your message must be a JSON object with a top-level JSON key of
         *                                   "default" with a value that is a string
         *                                   You can define other top-level keys that define the message you want to
         *                                   send to a specific transport protocol (i.e. "sqs", "email", "http", etc)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder messagePerSubscriptionType(java.lang.Boolean messagePerSubscriptionType) {
            this.messagePerSubscriptionType = messagePerSubscriptionType;
            return this;
        }

        /**
         * Sets the value of {@link SnsPublishProps#getSubject}
         * @param subject Used as the "Subject" line when the message is delivered to email endpoints.
         *                This field will also be included, if present, in the standard JSON messages
         *                delivered to other endpoints.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subject(java.lang.String subject) {
            this.subject = subject;
            return this;
        }

        /**
         * Sets the value of {@link SnsPublishProps#getComment}
         * @param comment An optional description for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link SnsPublishProps#getHeartbeat}
         * @param heartbeat Timeout for the heartbeat.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder heartbeat(software.amazon.awscdk.core.Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        /**
         * Sets the value of {@link SnsPublishProps#getInputPath}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state.
         *                  May also be the special value JsonPath.DISCARD, which will cause the effective
         *                  input to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder inputPath(java.lang.String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        /**
         * Sets the value of {@link SnsPublishProps#getIntegrationPattern}
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language.
         *                           You can control these AWS services using service integration patterns
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link SnsPublishProps#getOutputPath}
         * @param outputPath JSONPath expression to select select a portion of the state output to pass to the next state.
         *                   May also be the special value JsonPath.DISCARD, which will cause the effective
         *                   output to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Sets the value of {@link SnsPublishProps#getResultPath}
         * @param resultPath JSONPath expression to indicate where to inject the state's output.
         *                   May also be the special value JsonPath.DISCARD, which will cause the state's
         *                   input to become its output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder resultPath(java.lang.String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        /**
         * Sets the value of {@link SnsPublishProps#getResultSelector}
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         *                       You can use ResultSelector to create a payload with values that are static
         *                       or selected from the state's raw result.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder resultSelector(java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)resultSelector;
            return this;
        }

        /**
         * Sets the value of {@link SnsPublishProps#getTimeout}
         * @param timeout Timeout for the state machine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder timeout(software.amazon.awscdk.core.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SnsPublishProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public SnsPublishProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SnsPublishProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnsPublishProps {
        private final software.amazon.awscdk.services.stepfunctions.TaskInput message;
        private final software.amazon.awscdk.services.sns.ITopic topic;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.MessageAttribute> messageAttributes;
        private final java.lang.Boolean messagePerSubscriptionType;
        private final java.lang.String subject;
        private final java.lang.String comment;
        private final software.amazon.awscdk.core.Duration heartbeat;
        private final java.lang.String inputPath;
        private final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private final java.lang.String outputPath;
        private final java.lang.String resultPath;
        private final java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        private final software.amazon.awscdk.core.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.message = software.amazon.jsii.Kernel.get(this, "message", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class));
            this.topic = software.amazon.jsii.Kernel.get(this, "topic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class));
            this.messageAttributes = software.amazon.jsii.Kernel.get(this, "messageAttributes", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.MessageAttribute.class)));
            this.messagePerSubscriptionType = software.amazon.jsii.Kernel.get(this, "messagePerSubscriptionType", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.subject = software.amazon.jsii.Kernel.get(this, "subject", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.heartbeat = software.amazon.jsii.Kernel.get(this, "heartbeat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.integrationPattern = software.amazon.jsii.Kernel.get(this, "integrationPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IntegrationPattern.class));
            this.outputPath = software.amazon.jsii.Kernel.get(this, "outputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultPath = software.amazon.jsii.Kernel.get(this, "resultPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultSelector = software.amazon.jsii.Kernel.get(this, "resultSelector", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.message = java.util.Objects.requireNonNull(builder.message, "message is required");
            this.topic = java.util.Objects.requireNonNull(builder.topic, "topic is required");
            this.messageAttributes = (java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.MessageAttribute>)builder.messageAttributes;
            this.messagePerSubscriptionType = builder.messagePerSubscriptionType;
            this.subject = builder.subject;
            this.comment = builder.comment;
            this.heartbeat = builder.heartbeat;
            this.inputPath = builder.inputPath;
            this.integrationPattern = builder.integrationPattern;
            this.outputPath = builder.outputPath;
            this.resultPath = builder.resultPath;
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)builder.resultSelector;
            this.timeout = builder.timeout;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.TaskInput getMessage() {
            return this.message;
        }

        @Override
        public final software.amazon.awscdk.services.sns.ITopic getTopic() {
            return this.topic;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.MessageAttribute> getMessageAttributes() {
            return this.messageAttributes;
        }

        @Override
        public final java.lang.Boolean getMessagePerSubscriptionType() {
            return this.messagePerSubscriptionType;
        }

        @Override
        public final java.lang.String getSubject() {
            return this.subject;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getHeartbeat() {
            return this.heartbeat;
        }

        @Override
        public final java.lang.String getInputPath() {
            return this.inputPath;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.IntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public final java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        public final java.lang.String getResultPath() {
            return this.resultPath;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getResultSelector() {
            return this.resultSelector;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("message", om.valueToTree(this.getMessage()));
            data.set("topic", om.valueToTree(this.getTopic()));
            if (this.getMessageAttributes() != null) {
                data.set("messageAttributes", om.valueToTree(this.getMessageAttributes()));
            }
            if (this.getMessagePerSubscriptionType() != null) {
                data.set("messagePerSubscriptionType", om.valueToTree(this.getMessagePerSubscriptionType()));
            }
            if (this.getSubject() != null) {
                data.set("subject", om.valueToTree(this.getSubject()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getHeartbeat() != null) {
                data.set("heartbeat", om.valueToTree(this.getHeartbeat()));
            }
            if (this.getInputPath() != null) {
                data.set("inputPath", om.valueToTree(this.getInputPath()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }
            if (this.getResultPath() != null) {
                data.set("resultPath", om.valueToTree(this.getResultPath()));
            }
            if (this.getResultSelector() != null) {
                data.set("resultSelector", om.valueToTree(this.getResultSelector()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.SnsPublishProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SnsPublishProps.Jsii$Proxy that = (SnsPublishProps.Jsii$Proxy) o;

            if (!message.equals(that.message)) return false;
            if (!topic.equals(that.topic)) return false;
            if (this.messageAttributes != null ? !this.messageAttributes.equals(that.messageAttributes) : that.messageAttributes != null) return false;
            if (this.messagePerSubscriptionType != null ? !this.messagePerSubscriptionType.equals(that.messagePerSubscriptionType) : that.messagePerSubscriptionType != null) return false;
            if (this.subject != null ? !this.subject.equals(that.subject) : that.subject != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.heartbeat != null ? !this.heartbeat.equals(that.heartbeat) : that.heartbeat != null) return false;
            if (this.inputPath != null ? !this.inputPath.equals(that.inputPath) : that.inputPath != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.outputPath != null ? !this.outputPath.equals(that.outputPath) : that.outputPath != null) return false;
            if (this.resultPath != null ? !this.resultPath.equals(that.resultPath) : that.resultPath != null) return false;
            if (this.resultSelector != null ? !this.resultSelector.equals(that.resultSelector) : that.resultSelector != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.message.hashCode();
            result = 31 * result + (this.topic.hashCode());
            result = 31 * result + (this.messageAttributes != null ? this.messageAttributes.hashCode() : 0);
            result = 31 * result + (this.messagePerSubscriptionType != null ? this.messagePerSubscriptionType.hashCode() : 0);
            result = 31 * result + (this.subject != null ? this.subject.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.heartbeat != null ? this.heartbeat.hashCode() : 0);
            result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            result = 31 * result + (this.resultPath != null ? this.resultPath.hashCode() : 0);
            result = 31 * result + (this.resultSelector != null ? this.resultSelector.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
