package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * (experimental) Encryption Options of the S3 bucket.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * AthenaStartQueryExecution startQueryExecutionJob = AthenaStartQueryExecution.Builder.create(this, "Athena Start Query")
 *         .queryString(JsonPath.format("select contacts where year={};", JsonPath.stringAt("$.year")))
 *         .queryExecutionContext(QueryExecutionContext.builder()
 *                 .databaseName("interactions")
 *                 .build())
 *         .resultConfiguration(ResultConfiguration.builder()
 *                 .encryptionConfiguration(EncryptionConfiguration.builder()
 *                         .encryptionOption(EncryptionOption.S3_MANAGED)
 *                         .build())
 *                 .outputLocation(Location.builder()
 *                         .bucketName("mybucket")
 *                         .objectKey("myprefix")
 *                         .build())
 *                 .build())
 *         .integrationPattern(IntegrationPattern.RUN_JOB)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/athena/latest/APIReference/API_EncryptionConfiguration.html#athena-Type-EncryptionConfiguration-EncryptionOption">https://docs.aws.amazon.com/athena/latest/APIReference/API_EncryptionConfiguration.html#athena-Type-EncryptionConfiguration-EncryptionOption</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:11.608Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EncryptionOption")
public enum EncryptionOption {
    /**
     * (experimental) Server side encryption (SSE) with an Amazon S3-managed key.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    S3_MANAGED,
    /**
     * (experimental) Server-side encryption (SSE) with an AWS KMS key managed by the account owner.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    KMS,
    /**
     * (experimental) Client-side encryption (CSE) with an AWS KMS key managed by the account owner.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    CLIENT_SIDE_KMS,
}
