package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * (experimental) The action to take when the cluster step fails.
 * <p>
 * Default: CONTINUE
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EmrAddStep.Builder.create(this, "Task")
 *         .clusterId("ClusterId")
 *         .name("StepName")
 *         .jar("Jar")
 *         .actionOnFailure(ActionOnFailure.CONTINUE)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_StepConfig.html
 * Here, they are named as TERMINATE_JOB_FLOW, TERMINATE_CLUSTER, CANCEL_AND_WAIT, and CONTINUE respectively.">https://docs.aws.amazon.com/emr/latest/APIReference/API_StepConfig.html
 * Here, they are named as TERMINATE_JOB_FLOW, TERMINATE_CLUSTER, CANCEL_AND_WAIT, and CONTINUE respectively.</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:11.383Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.ActionOnFailure")
public enum ActionOnFailure {
    /**
     * (experimental) Terminate the Cluster on Step Failure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TERMINATE_CLUSTER,
    /**
     * (experimental) Cancel Step execution and enter WAITING state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    CANCEL_AND_WAIT,
    /**
     * (experimental) Continue to the next Step.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    CONTINUE,
}
