package software.amazon.awscdk.services.stepfunctions;

/**
 * (experimental) Two types of state machines are available in AWS Step Functions: EXPRESS AND STANDARD.
 * <p>
 * Default: STANDARD
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Pass stateMachineDefinition = new Pass(this, "PassState");
 * IStateMachine stateMachine = StateMachine.Builder.create(this, "StateMachine")
 *         .definition(stateMachineDefinition)
 *         .stateMachineType(StateMachineType.EXPRESS)
 *         .build();
 * StepFunctionsRestApi.Builder.create(this, "StepFunctionsRestApi")
 *         .deploy(true)
 *         .stateMachine(stateMachine)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-standard-vs-express.html">https://docs.aws.amazon.com/step-functions/latest/dg/concepts-standard-vs-express.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:11.267Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions.StateMachineType")
public enum StateMachineType {
    /**
     * (experimental) Express Workflows are ideal for high-volume, event processing workloads.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    EXPRESS,
    /**
     * (experimental) Standard Workflows are ideal for long-running, durable, and auditable workflows.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    STANDARD,
}
