package software.amazon.awscdk.services.stepfunctions;

/**
 * (experimental) Base class for reusable state machine fragments.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.Stack;
 * import software.constructs.Construct;
 * import software.amazon.awscdk.core.*;
 * public class MyJobProps {
 *     private String jobFlavor;
 *     public String getJobFlavor() {
 *         return this.jobFlavor;
 *     }
 *     public MyJobProps jobFlavor(String jobFlavor) {
 *         this.jobFlavor = jobFlavor;
 *         return this;
 *     }
 * }
 * public class MyJob extends StateMachineFragment {
 *     public final State startState;
 *     public final INextable[] endStates;
 *     public MyJob(Construct parent, String id, MyJobProps props) {
 *         super(parent, id);
 *         Choice choice = new Choice(this, "Choice").when(Condition.stringEquals("$.branch", "left"), new Pass(this, "Left Branch")).when(Condition.stringEquals("$.branch", "right"), new Pass(this, "Right Branch"));
 *         // ...
 *         this.startState = choice;
 *         this.endStates = choice.afterwards().getEndStates();
 *     }
 * }
 * public class MyStack extends Stack {
 *     public MyStack(Construct scope, String id) {
 *         super(scope, id);
 *         // Do 3 different variants of MyJob in parallel
 *         Parallel parallel = new Parallel(this, "All jobs").branch(new MyJob(this, "Quick", new MyJobProps().jobFlavor("quick")).prefixStates()).branch(new MyJob(this, "Medium", new MyJobProps().jobFlavor("medium")).prefixStates()).branch(new MyJob(this, "Slow", new MyJobProps().jobFlavor("slow")).prefixStates());
 *         StateMachine.Builder.create(this, "MyStateMachine")
 *                 .definition(parallel)
 *                 .build();
 *     }
 * }
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:11.264Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions.StateMachineFragment")
public abstract class StateMachineFragment extends software.amazon.awscdk.core.Construct implements software.amazon.awscdk.services.stepfunctions.IChainable {

    protected StateMachineFragment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StateMachineFragment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected StateMachineFragment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Continue normal execution with the given state.
     * <p>
     * @param next This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Chain next(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable next) {
        return software.amazon.jsii.Kernel.call(this, "next", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Chain.class), new Object[] { java.util.Objects.requireNonNull(next, "next is required") });
    }

    /**
     * (experimental) Prefix the IDs of all states in this state machine fragment.
     * <p>
     * Use this to avoid multiple copies of the state machine all having the
     * same state IDs.
     * <p>
     * @param prefix The prefix to add.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateMachineFragment prefixStates(final @org.jetbrains.annotations.Nullable java.lang.String prefix) {
        return software.amazon.jsii.Kernel.call(this, "prefixStates", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.StateMachineFragment.class), new Object[] { prefix });
    }

    /**
     * (experimental) Prefix the IDs of all states in this state machine fragment.
     * <p>
     * Use this to avoid multiple copies of the state machine all having the
     * same state IDs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateMachineFragment prefixStates() {
        return software.amazon.jsii.Kernel.call(this, "prefixStates", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.StateMachineFragment.class));
    }

    /**
     * (experimental) Wrap all states in this state machine fragment up into a single state.
     * <p>
     * This can be used to add retry or error handling onto this state
     * machine fragment.
     * <p>
     * Be aware that this changes the result of the inner state machine
     * to be an array with the result of the state machine in it. Adjust
     * your paths accordingly. For example, change 'outputPath' to
     * '$[0]'.
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Parallel toSingleState(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.SingleStateOptions options) {
        return software.amazon.jsii.Kernel.call(this, "toSingleState", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Parallel.class), new Object[] { options });
    }

    /**
     * (experimental) Wrap all states in this state machine fragment up into a single state.
     * <p>
     * This can be used to add retry or error handling onto this state
     * machine fragment.
     * <p>
     * Be aware that this changes the result of the inner state machine
     * to be an array with the result of the state machine in it. Adjust
     * your paths accordingly. For example, change 'outputPath' to
     * '$[0]'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Parallel toSingleState() {
        return software.amazon.jsii.Kernel.call(this, "toSingleState", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Parallel.class));
    }

    /**
     * (experimental) The states to chain onto if this fragment is used.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public abstract @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates();

    /**
     * (experimental) Descriptive identifier for this chainable.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getId() {
        return software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The start state of this state machine fragment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State getStartState();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.stepfunctions.StateMachineFragment implements software.amazon.awscdk.services.stepfunctions.IChainable.Jsii$Default, software.amazon.awscdk.core.IConstruct.Jsii$Default, software.constructs.IConstruct.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) The states to chain onto if this fragment is used.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "endStates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.INextable.class))));
        }

        /**
         * (experimental) The start state of this state machine fragment.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State getStartState() {
            return software.amazon.jsii.Kernel.get(this, "startState", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.State.class));
        }
    }
}
