/**
 * <h1>Amazon Simple Queue Service Construct Library</h1>
 * <p>
 * Amazon Simple Queue Service (SQS) is a fully managed message queuing service that
 * enables you to decouple and scale microservices, distributed systems, and serverless
 * applications. SQS eliminates the complexity and overhead associated with managing and
 * operating message oriented middleware, and empowers developers to focus on differentiating work.
 * Using SQS, you can send, store, and receive messages between software components at any volume,
 * without losing messages or requiring other services to be available.
 * <p>
 * <h2>Installation</h2>
 * <p>
 * Import to your project:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * </pre></blockquote>
 * <p>
 * <h2>Basic usage</h2>
 * <p>
 * Here's how to add a basic queue to your application:
 * <p>
 * <blockquote><pre>
 * new Queue(this, "Queue");
 * </pre></blockquote>
 * <p>
 * <h2>Encryption</h2>
 * <p>
 * If you want to encrypt the queue contents, set the <code>encryption</code> property. You can have
 * the messages encrypted with a key that SQS manages for you, or a key that you
 * can manage yourself.
 * <p>
 * <blockquote><pre>
 * // Use managed key
 * // Use managed key
 * Queue.Builder.create(this, "Queue")
 *         .encryption(QueueEncryption.KMS_MANAGED)
 *         .build();
 * 
 * // Use custom key
 * Key myKey = new Key(this, "Key");
 * 
 * Queue.Builder.create(this, "Queue")
 *         .encryption(QueueEncryption.KMS)
 *         .encryptionMasterKey(myKey)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>First-In-First-Out (FIFO) queues</h2>
 * <p>
 * FIFO queues give guarantees on the order in which messages are dequeued, and have additional
 * features in order to help guarantee exactly-once processing. For more information, see
 * the SQS manual. Note that FIFO queues are not available in all AWS regions.
 * <p>
 * A queue can be made a FIFO queue by either setting <code>fifo: true</code>, giving it a name which ends
 * in <code>".fifo"</code>, or by enabling a FIFO specific feature such as: content-based deduplication,
 * deduplication scope or fifo throughput limit.
 */
package software.amazon.awscdk.services.sqs;
