package software.amazon.awscdk.services.sqs;

/**
 * (experimental) Represents an SQS queue.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:10.932Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_sqs.IQueue")
@software.amazon.jsii.Jsii.Proxy(IQueue.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface IQueue extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.IResource {

    /**
     * (experimental) Whether this queue is an Amazon SQS FIFO queue.
     * <p>
     * If false, this is a standard queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getFifo();

    /**
     * (experimental) The ARN of this queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getQueueArn();

    /**
     * (experimental) The name of this queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getQueueName();

    /**
     * (experimental) The URL of this queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getQueueUrl();

    /**
     * (experimental) If this queue is server-side encrypted, this is the KMS encryption key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionMasterKey() {
        return null;
    }

    /**
     * (experimental) Adds a statement to the IAM resource policy associated with this queue.
     * <p>
     * If this queue was created in this stack (<code>new Queue</code>), a queue policy
     * will be automatically created upon the first call to <code>addToPolicy</code>. If
     * the queue is imported (<code>Queue.import</code>), then this is a no-op.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement);

    /**
     * (experimental) Grant the actions defined in queueActions to the identity Principal given on this SQS queue resource.
     * <p>
     * @param grantee Principal to grant right to. This parameter is required.
     * @param queueActions The actions to grant. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... queueActions);

    /**
     * (experimental) Grant permissions to consume messages from a queue.
     * <p>
     * This will grant the following permissions:
     * <p>
     * <ul>
     * <li>sqs:ChangeMessageVisibility</li>
     * <li>sqs:DeleteMessage</li>
     * <li>sqs:ReceiveMessage</li>
     * <li>sqs:GetQueueAttributes</li>
     * <li>sqs:GetQueueUrl</li>
     * </ul>
     * <p>
     * @param grantee Principal to grant consume rights to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantConsumeMessages(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * (experimental) Grant an IAM principal permissions to purge all messages from the queue.
     * <p>
     * This will grant the following permissions:
     * <p>
     * <ul>
     * <li>sqs:PurgeQueue</li>
     * <li>sqs:GetQueueAttributes</li>
     * <li>sqs:GetQueueUrl</li>
     * </ul>
     * <p>
     * @param grantee Principal to grant send rights to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPurge(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * (experimental) Grant access to send messages to a queue to the given identity.
     * <p>
     * This will grant the following permissions:
     * <p>
     * <ul>
     * <li>sqs:SendMessage</li>
     * <li>sqs:GetQueueAttributes</li>
     * <li>sqs:GetQueueUrl</li>
     * </ul>
     * <p>
     * @param grantee Principal to grant send rights to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantSendMessages(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * (experimental) Return the given named metric for this Queue.
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Return the given named metric for this Queue.
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName);

    /**
     * (experimental) The approximate age of the oldest non-deleted message in the queue.
     * <p>
     * Maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateAgeOfOldestMessage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The approximate age of the oldest non-deleted message in the queue.
     * <p>
     * Maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateAgeOfOldestMessage();

    /**
     * (experimental) The number of messages in the queue that are delayed and not available for reading immediately.
     * <p>
     * Maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesDelayed(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The number of messages in the queue that are delayed and not available for reading immediately.
     * <p>
     * Maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesDelayed();

    /**
     * (experimental) The number of messages that are in flight.
     * <p>
     * Maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesNotVisible(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The number of messages that are in flight.
     * <p>
     * Maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesNotVisible();

    /**
     * (experimental) The number of messages available for retrieval from the queue.
     * <p>
     * Maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesVisible(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The number of messages available for retrieval from the queue.
     * <p>
     * Maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesVisible();

    /**
     * (experimental) The number of ReceiveMessage API calls that did not return a message.
     * <p>
     * Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfEmptyReceives(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The number of ReceiveMessage API calls that did not return a message.
     * <p>
     * Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfEmptyReceives();

    /**
     * (experimental) The number of messages deleted from the queue.
     * <p>
     * Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesDeleted(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The number of messages deleted from the queue.
     * <p>
     * Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesDeleted();

    /**
     * (experimental) The number of messages returned by calls to the ReceiveMessage action.
     * <p>
     * Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesReceived(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The number of messages returned by calls to the ReceiveMessage action.
     * <p>
     * Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesReceived();

    /**
     * (experimental) The number of messages added to a queue.
     * <p>
     * Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesSent(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The number of messages added to a queue.
     * <p>
     * Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesSent();

    /**
     * (experimental) The size of messages added to a queue.
     * <p>
     * Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSentMessageSize(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The size of messages added to a queue.
     * <p>
     * Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSentMessageSize();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sqs.IQueue.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
        }

        /**
         * (experimental) The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ResourceEnvironment.class));
        }

        /**
         * (experimental) The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class));
        }

        /**
         * (experimental) Whether this queue is an Amazon SQS FIFO queue.
         * <p>
         * If false, this is a standard queue.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.lang.Boolean getFifo() {
            return software.amazon.jsii.Kernel.get(this, "fifo", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * (experimental) The ARN of this queue.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.lang.String getQueueArn() {
            return software.amazon.jsii.Kernel.get(this, "queueArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The name of this queue.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.lang.String getQueueName() {
            return software.amazon.jsii.Kernel.get(this, "queueName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The URL of this queue.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.lang.String getQueueUrl() {
            return software.amazon.jsii.Kernel.get(this, "queueUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) If this queue is server-side encrypted, this is the KMS encryption key.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionMasterKey() {
            return software.amazon.jsii.Kernel.get(this, "encryptionMasterKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
        }

        /**
         * (experimental) Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * (experimental) Adds a statement to the IAM resource policy associated with this queue.
         * <p>
         * If this queue was created in this stack (<code>new Queue</code>), a queue policy
         * will be automatically created upon the first call to <code>addToPolicy</code>. If
         * the queue is imported (<code>Queue.import</code>), then this is a no-op.
         * <p>
         * @param statement This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
            return software.amazon.jsii.Kernel.call(this, "addToResourcePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToResourcePolicyResult.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
        }

        /**
         * (experimental) Grant the actions defined in queueActions to the identity Principal given on this SQS queue resource.
         * <p>
         * @param grantee Principal to grant right to. This parameter is required.
         * @param queueActions The actions to grant. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... queueActions) {
            return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(queueActions)).toArray(Object[]::new));
        }

        /**
         * (experimental) Grant permissions to consume messages from a queue.
         * <p>
         * This will grant the following permissions:
         * <p>
         * <ul>
         * <li>sqs:ChangeMessageVisibility</li>
         * <li>sqs:DeleteMessage</li>
         * <li>sqs:ReceiveMessage</li>
         * <li>sqs:GetQueueAttributes</li>
         * <li>sqs:GetQueueUrl</li>
         * </ul>
         * <p>
         * @param grantee Principal to grant consume rights to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantConsumeMessages(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantConsumeMessages", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * (experimental) Grant an IAM principal permissions to purge all messages from the queue.
         * <p>
         * This will grant the following permissions:
         * <p>
         * <ul>
         * <li>sqs:PurgeQueue</li>
         * <li>sqs:GetQueueAttributes</li>
         * <li>sqs:GetQueueUrl</li>
         * </ul>
         * <p>
         * @param grantee Principal to grant send rights to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPurge(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantPurge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * (experimental) Grant access to send messages to a queue to the given identity.
         * <p>
         * This will grant the following permissions:
         * <p>
         * <ul>
         * <li>sqs:SendMessage</li>
         * <li>sqs:GetQueueAttributes</li>
         * <li>sqs:GetQueueUrl</li>
         * </ul>
         * <p>
         * @param grantee Principal to grant send rights to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantSendMessages(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantSendMessages", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * (experimental) Return the given named metric for this Queue.
         * <p>
         * @param metricName This parameter is required.
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
        }

        /**
         * (experimental) Return the given named metric for this Queue.
         * <p>
         * @param metricName This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
            return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
        }

        /**
         * (experimental) The approximate age of the oldest non-deleted message in the queue.
         * <p>
         * Maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateAgeOfOldestMessage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricApproximateAgeOfOldestMessage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The approximate age of the oldest non-deleted message in the queue.
         * <p>
         * Maximum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateAgeOfOldestMessage() {
            return software.amazon.jsii.Kernel.call(this, "metricApproximateAgeOfOldestMessage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The number of messages in the queue that are delayed and not available for reading immediately.
         * <p>
         * Maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesDelayed(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricApproximateNumberOfMessagesDelayed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The number of messages in the queue that are delayed and not available for reading immediately.
         * <p>
         * Maximum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesDelayed() {
            return software.amazon.jsii.Kernel.call(this, "metricApproximateNumberOfMessagesDelayed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The number of messages that are in flight.
         * <p>
         * Maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesNotVisible(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricApproximateNumberOfMessagesNotVisible", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The number of messages that are in flight.
         * <p>
         * Maximum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesNotVisible() {
            return software.amazon.jsii.Kernel.call(this, "metricApproximateNumberOfMessagesNotVisible", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The number of messages available for retrieval from the queue.
         * <p>
         * Maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesVisible(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricApproximateNumberOfMessagesVisible", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The number of messages available for retrieval from the queue.
         * <p>
         * Maximum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesVisible() {
            return software.amazon.jsii.Kernel.call(this, "metricApproximateNumberOfMessagesVisible", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The number of ReceiveMessage API calls that did not return a message.
         * <p>
         * Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfEmptyReceives(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNumberOfEmptyReceives", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The number of ReceiveMessage API calls that did not return a message.
         * <p>
         * Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfEmptyReceives() {
            return software.amazon.jsii.Kernel.call(this, "metricNumberOfEmptyReceives", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The number of messages deleted from the queue.
         * <p>
         * Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesDeleted(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNumberOfMessagesDeleted", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The number of messages deleted from the queue.
         * <p>
         * Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesDeleted() {
            return software.amazon.jsii.Kernel.call(this, "metricNumberOfMessagesDeleted", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The number of messages returned by calls to the ReceiveMessage action.
         * <p>
         * Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesReceived(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNumberOfMessagesReceived", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The number of messages returned by calls to the ReceiveMessage action.
         * <p>
         * Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesReceived() {
            return software.amazon.jsii.Kernel.call(this, "metricNumberOfMessagesReceived", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The number of messages added to a queue.
         * <p>
         * Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesSent(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNumberOfMessagesSent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The number of messages added to a queue.
         * <p>
         * Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesSent() {
            return software.amazon.jsii.Kernel.call(this, "metricNumberOfMessagesSent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The size of messages added to a queue.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSentMessageSize(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricSentMessageSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The size of messages added to a queue.
         * <p>
         * Average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSentMessageSize() {
            return software.amazon.jsii.Kernel.call(this, "metricSentMessageSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }
    }

    /**
     * Internal default implementation for {@link IQueue}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IQueue, software.amazon.awscdk.core.IResource.Jsii$Default {

        /**
         * (experimental) The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
        }

        /**
         * (experimental) The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ResourceEnvironment.class));
        }

        /**
         * (experimental) The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class));
        }

        /**
         * (experimental) Whether this queue is an Amazon SQS FIFO queue.
         * <p>
         * If false, this is a standard queue.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull java.lang.Boolean getFifo() {
            return software.amazon.jsii.Kernel.get(this, "fifo", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * (experimental) The ARN of this queue.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull java.lang.String getQueueArn() {
            return software.amazon.jsii.Kernel.get(this, "queueArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The name of this queue.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull java.lang.String getQueueName() {
            return software.amazon.jsii.Kernel.get(this, "queueName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The URL of this queue.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull java.lang.String getQueueUrl() {
            return software.amazon.jsii.Kernel.get(this, "queueUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) If this queue is server-side encrypted, this is the KMS encryption key.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionMasterKey() {
            return software.amazon.jsii.Kernel.get(this, "encryptionMasterKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
        }

        /**
         * (experimental) Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * (experimental) Adds a statement to the IAM resource policy associated with this queue.
         * <p>
         * If this queue was created in this stack (<code>new Queue</code>), a queue policy
         * will be automatically created upon the first call to <code>addToPolicy</code>. If
         * the queue is imported (<code>Queue.import</code>), then this is a no-op.
         * <p>
         * @param statement This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
            return software.amazon.jsii.Kernel.call(this, "addToResourcePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToResourcePolicyResult.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
        }

        /**
         * (experimental) Grant the actions defined in queueActions to the identity Principal given on this SQS queue resource.
         * <p>
         * @param grantee Principal to grant right to. This parameter is required.
         * @param queueActions The actions to grant. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... queueActions) {
            return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(queueActions)).toArray(Object[]::new));
        }

        /**
         * (experimental) Grant permissions to consume messages from a queue.
         * <p>
         * This will grant the following permissions:
         * <p>
         * <ul>
         * <li>sqs:ChangeMessageVisibility</li>
         * <li>sqs:DeleteMessage</li>
         * <li>sqs:ReceiveMessage</li>
         * <li>sqs:GetQueueAttributes</li>
         * <li>sqs:GetQueueUrl</li>
         * </ul>
         * <p>
         * @param grantee Principal to grant consume rights to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantConsumeMessages(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantConsumeMessages", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * (experimental) Grant an IAM principal permissions to purge all messages from the queue.
         * <p>
         * This will grant the following permissions:
         * <p>
         * <ul>
         * <li>sqs:PurgeQueue</li>
         * <li>sqs:GetQueueAttributes</li>
         * <li>sqs:GetQueueUrl</li>
         * </ul>
         * <p>
         * @param grantee Principal to grant send rights to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPurge(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantPurge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * (experimental) Grant access to send messages to a queue to the given identity.
         * <p>
         * This will grant the following permissions:
         * <p>
         * <ul>
         * <li>sqs:SendMessage</li>
         * <li>sqs:GetQueueAttributes</li>
         * <li>sqs:GetQueueUrl</li>
         * </ul>
         * <p>
         * @param grantee Principal to grant send rights to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantSendMessages(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantSendMessages", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * (experimental) Return the given named metric for this Queue.
         * <p>
         * @param metricName This parameter is required.
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
        }

        /**
         * (experimental) The approximate age of the oldest non-deleted message in the queue.
         * <p>
         * Maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateAgeOfOldestMessage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricApproximateAgeOfOldestMessage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The number of messages in the queue that are delayed and not available for reading immediately.
         * <p>
         * Maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesDelayed(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricApproximateNumberOfMessagesDelayed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The number of messages that are in flight.
         * <p>
         * Maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesNotVisible(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricApproximateNumberOfMessagesNotVisible", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The number of messages available for retrieval from the queue.
         * <p>
         * Maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricApproximateNumberOfMessagesVisible(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricApproximateNumberOfMessagesVisible", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The number of ReceiveMessage API calls that did not return a message.
         * <p>
         * Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfEmptyReceives(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNumberOfEmptyReceives", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The number of messages deleted from the queue.
         * <p>
         * Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesDeleted(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNumberOfMessagesDeleted", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The number of messages returned by calls to the ReceiveMessage action.
         * <p>
         * Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesReceived(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNumberOfMessagesReceived", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The number of messages added to a queue.
         * <p>
         * Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfMessagesSent(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNumberOfMessagesSent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The size of messages added to a queue.
         * <p>
         * Average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSentMessageSize(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricSentMessageSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }
    }
}
