package software.amazon.awscdk.services.signer;

/**
 * (experimental) Platforms that are allowed with signing config.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * SigningProfile signingProfile = SigningProfile.Builder.create(this, "SigningProfile")
 *         .platform(Platform.AWS_LAMBDA_SHA384_ECDSA)
 *         .build();
 * CodeSigningConfig codeSigningConfig = CodeSigningConfig.Builder.create(this, "CodeSigningConfig")
 *         .signingProfiles(List.of(signingProfile))
 *         .build();
 * Function.Builder.create(this, "Function")
 *         .codeSigningConfig(codeSigningConfig)
 *         .runtime(Runtime.NODEJS_16_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/signer/latest/developerguide/gs-platform.html">https://docs.aws.amazon.com/signer/latest/developerguide/gs-platform.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:10.807Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_signer.Platform")
public class Platform extends software.amazon.jsii.JsiiObject {

    protected Platform(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Platform(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        AMAZON_FREE_RTOS_DEFAULT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.signer.Platform.class, "AMAZON_FREE_RTOS_DEFAULT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.signer.Platform.class));
        AMAZON_FREE_RTOS_TI_CC3220_SF = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.signer.Platform.class, "AMAZON_FREE_RTOS_TI_CC3220SF", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.signer.Platform.class));
        AWS_IOT_DEVICE_MANAGEMENT_SHA256_ECDSA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.signer.Platform.class, "AWS_IOT_DEVICE_MANAGEMENT_SHA256_ECDSA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.signer.Platform.class));
        AWS_LAMBDA_SHA384_ECDSA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.signer.Platform.class, "AWS_LAMBDA_SHA384_ECDSA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.signer.Platform.class));
    }

    /**
     * (experimental) Specification of signature format and signing algorithms with SHA256 hash and ECDSA encryption for Amazon FreeRTOS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.signer.Platform AMAZON_FREE_RTOS_DEFAULT;

    /**
     * (experimental) Specification of signature format and signing algorithms with SHA1 hash and RSA encryption for Amazon FreeRTOS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.signer.Platform AMAZON_FREE_RTOS_TI_CC3220_SF;

    /**
     * (experimental) Specification of signature format and signing algorithms for AWS IoT Device.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.signer.Platform AWS_IOT_DEVICE_MANAGEMENT_SHA256_ECDSA;

    /**
     * (experimental) Specification of signature format and signing algorithms for AWS Lambda.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.signer.Platform AWS_LAMBDA_SHA384_ECDSA;

    /**
     * (experimental) The id of signing platform.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-signer-signingprofile.html#cfn-signer-signingprofile-platformid">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-signer-signingprofile.html#cfn-signer-signingprofile-platformid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getPlatformId() {
        return software.amazon.jsii.Kernel.get(this, "platformId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
