package software.amazon.awscdk.services.ses.actions;

/**
 * (experimental) Construction properties for a Lambda action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.services.ses.actions.*;
 * import software.amazon.awscdk.services.sns.*;
 * Function function_;
 * Topic topic;
 * LambdaProps lambdaProps = LambdaProps.builder()
 *         .function(function_)
 *         // the properties below are optional
 *         .invocationType(LambdaInvocationType.EVENT)
 *         .topic(topic)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:10.789Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ses_actions.LambdaProps")
@software.amazon.jsii.Jsii.Proxy(LambdaProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface LambdaProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The Lambda function to invoke.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction getFunction();

    /**
     * (experimental) The invocation type of the Lambda function.
     * <p>
     * Default: Event
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.actions.LambdaInvocationType getInvocationType() {
        return null;
    }

    /**
     * (experimental) The SNS topic to notify when the Lambda action is taken.
     * <p>
     * Default: no notification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.ITopic getTopic() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LambdaProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LambdaProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<LambdaProps> {
        software.amazon.awscdk.services.lambda.IFunction function;
        software.amazon.awscdk.services.ses.actions.LambdaInvocationType invocationType;
        software.amazon.awscdk.services.sns.ITopic topic;

        /**
         * Sets the value of {@link LambdaProps#getFunction}
         * @param function The Lambda function to invoke. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder function(software.amazon.awscdk.services.lambda.IFunction function) {
            this.function = function;
            return this;
        }

        /**
         * Sets the value of {@link LambdaProps#getInvocationType}
         * @param invocationType The invocation type of the Lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder invocationType(software.amazon.awscdk.services.ses.actions.LambdaInvocationType invocationType) {
            this.invocationType = invocationType;
            return this;
        }

        /**
         * Sets the value of {@link LambdaProps#getTopic}
         * @param topic The SNS topic to notify when the Lambda action is taken.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder topic(software.amazon.awscdk.services.sns.ITopic topic) {
            this.topic = topic;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public LambdaProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LambdaProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaProps {
        private final software.amazon.awscdk.services.lambda.IFunction function;
        private final software.amazon.awscdk.services.ses.actions.LambdaInvocationType invocationType;
        private final software.amazon.awscdk.services.sns.ITopic topic;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.function = software.amazon.jsii.Kernel.get(this, "function", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.invocationType = software.amazon.jsii.Kernel.get(this, "invocationType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.actions.LambdaInvocationType.class));
            this.topic = software.amazon.jsii.Kernel.get(this, "topic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.function = java.util.Objects.requireNonNull(builder.function, "function is required");
            this.invocationType = builder.invocationType;
            this.topic = builder.topic;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getFunction() {
            return this.function;
        }

        @Override
        public final software.amazon.awscdk.services.ses.actions.LambdaInvocationType getInvocationType() {
            return this.invocationType;
        }

        @Override
        public final software.amazon.awscdk.services.sns.ITopic getTopic() {
            return this.topic;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("function", om.valueToTree(this.getFunction()));
            if (this.getInvocationType() != null) {
                data.set("invocationType", om.valueToTree(this.getInvocationType()));
            }
            if (this.getTopic() != null) {
                data.set("topic", om.valueToTree(this.getTopic()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_ses_actions.LambdaProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LambdaProps.Jsii$Proxy that = (LambdaProps.Jsii$Proxy) o;

            if (!function.equals(that.function)) return false;
            if (this.invocationType != null ? !this.invocationType.equals(that.invocationType) : that.invocationType != null) return false;
            return this.topic != null ? this.topic.equals(that.topic) : that.topic == null;
        }

        @Override
        public final int hashCode() {
            int result = this.function.hashCode();
            result = 31 * result + (this.invocationType != null ? this.invocationType.hashCode() : 0);
            result = 31 * result + (this.topic != null ? this.topic.hashCode() : 0);
            return result;
        }
    }
}
