package software.amazon.awscdk.services.s3objectlambda;

/**
 * (experimental) The S3 object lambda access point configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * Stack stack = new Stack();
 * Bucket bucket = new Bucket(stack, "MyBucket");
 * Function handler = Function.Builder.create(stack, "MyFunction")
 *         .runtime(Runtime.NODEJS_14_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset("lambda.zip"))
 *         .build();
 * AccessPoint.Builder.create(stack, "MyObjectLambda")
 *         .bucket(bucket)
 *         .handler(handler)
 *         .accessPointName("my-access-point")
 *         .payload(Map.of(
 *                 "prop", "value"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:09.471Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_s3objectlambda.AccessPointProps")
@software.amazon.jsii.Jsii.Proxy(AccessPointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AccessPointProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The bucket to which this access point belongs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getBucket();

    /**
     * (experimental) The Lambda function used to transform objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction getHandler();

    /**
     * (experimental) The name of the S3 object lambda access point.
     * <p>
     * Default: a unique name will be generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccessPointName() {
        return null;
    }

    /**
     * (experimental) Whether CloudWatch metrics are enabled for the access point.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCloudWatchMetricsEnabled() {
        return null;
    }

    /**
     * (experimental) Additional JSON that provides supplemental data passed to the Lambda function on every request.
     * <p>
     * Default: - No data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getPayload() {
        return null;
    }

    /**
     * (experimental) Whether the Lambda function can process `GetObject-PartNumber` requests.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSupportsGetObjectPartNumber() {
        return null;
    }

    /**
     * (experimental) Whether the Lambda function can process `GetObject-Range` requests.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSupportsGetObjectRange() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AccessPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AccessPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AccessPointProps> {
        software.amazon.awscdk.services.s3.IBucket bucket;
        software.amazon.awscdk.services.lambda.IFunction handler;
        java.lang.String accessPointName;
        java.lang.Boolean cloudWatchMetricsEnabled;
        java.util.Map<java.lang.String, java.lang.Object> payload;
        java.lang.Boolean supportsGetObjectPartNumber;
        java.lang.Boolean supportsGetObjectRange;

        /**
         * Sets the value of {@link AccessPointProps#getBucket}
         * @param bucket The bucket to which this access point belongs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bucket(software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link AccessPointProps#getHandler}
         * @param handler The Lambda function used to transform objects. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder handler(software.amazon.awscdk.services.lambda.IFunction handler) {
            this.handler = handler;
            return this;
        }

        /**
         * Sets the value of {@link AccessPointProps#getAccessPointName}
         * @param accessPointName The name of the S3 object lambda access point.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder accessPointName(java.lang.String accessPointName) {
            this.accessPointName = accessPointName;
            return this;
        }

        /**
         * Sets the value of {@link AccessPointProps#getCloudWatchMetricsEnabled}
         * @param cloudWatchMetricsEnabled Whether CloudWatch metrics are enabled for the access point.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloudWatchMetricsEnabled(java.lang.Boolean cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link AccessPointProps#getPayload}
         * @param payload Additional JSON that provides supplemental data passed to the Lambda function on every request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder payload(java.util.Map<java.lang.String, ? extends java.lang.Object> payload) {
            this.payload = (java.util.Map<java.lang.String, java.lang.Object>)payload;
            return this;
        }

        /**
         * Sets the value of {@link AccessPointProps#getSupportsGetObjectPartNumber}
         * @param supportsGetObjectPartNumber Whether the Lambda function can process `GetObject-PartNumber` requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder supportsGetObjectPartNumber(java.lang.Boolean supportsGetObjectPartNumber) {
            this.supportsGetObjectPartNumber = supportsGetObjectPartNumber;
            return this;
        }

        /**
         * Sets the value of {@link AccessPointProps#getSupportsGetObjectRange}
         * @param supportsGetObjectRange Whether the Lambda function can process `GetObject-Range` requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder supportsGetObjectRange(java.lang.Boolean supportsGetObjectRange) {
            this.supportsGetObjectRange = supportsGetObjectRange;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AccessPointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AccessPointProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AccessPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessPointProps {
        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private final software.amazon.awscdk.services.lambda.IFunction handler;
        private final java.lang.String accessPointName;
        private final java.lang.Boolean cloudWatchMetricsEnabled;
        private final java.util.Map<java.lang.String, java.lang.Object> payload;
        private final java.lang.Boolean supportsGetObjectPartNumber;
        private final java.lang.Boolean supportsGetObjectRange;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.handler = software.amazon.jsii.Kernel.get(this, "handler", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.accessPointName = software.amazon.jsii.Kernel.get(this, "accessPointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cloudWatchMetricsEnabled = software.amazon.jsii.Kernel.get(this, "cloudWatchMetricsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.supportsGetObjectPartNumber = software.amazon.jsii.Kernel.get(this, "supportsGetObjectPartNumber", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.supportsGetObjectRange = software.amazon.jsii.Kernel.get(this, "supportsGetObjectRange", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
            this.handler = java.util.Objects.requireNonNull(builder.handler, "handler is required");
            this.accessPointName = builder.accessPointName;
            this.cloudWatchMetricsEnabled = builder.cloudWatchMetricsEnabled;
            this.payload = (java.util.Map<java.lang.String, java.lang.Object>)builder.payload;
            this.supportsGetObjectPartNumber = builder.supportsGetObjectPartNumber;
            this.supportsGetObjectRange = builder.supportsGetObjectRange;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.bucket;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getHandler() {
            return this.handler;
        }

        @Override
        public final java.lang.String getAccessPointName() {
            return this.accessPointName;
        }

        @Override
        public final java.lang.Boolean getCloudWatchMetricsEnabled() {
            return this.cloudWatchMetricsEnabled;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getPayload() {
            return this.payload;
        }

        @Override
        public final java.lang.Boolean getSupportsGetObjectPartNumber() {
            return this.supportsGetObjectPartNumber;
        }

        @Override
        public final java.lang.Boolean getSupportsGetObjectRange() {
            return this.supportsGetObjectRange;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucket", om.valueToTree(this.getBucket()));
            data.set("handler", om.valueToTree(this.getHandler()));
            if (this.getAccessPointName() != null) {
                data.set("accessPointName", om.valueToTree(this.getAccessPointName()));
            }
            if (this.getCloudWatchMetricsEnabled() != null) {
                data.set("cloudWatchMetricsEnabled", om.valueToTree(this.getCloudWatchMetricsEnabled()));
            }
            if (this.getPayload() != null) {
                data.set("payload", om.valueToTree(this.getPayload()));
            }
            if (this.getSupportsGetObjectPartNumber() != null) {
                data.set("supportsGetObjectPartNumber", om.valueToTree(this.getSupportsGetObjectPartNumber()));
            }
            if (this.getSupportsGetObjectRange() != null) {
                data.set("supportsGetObjectRange", om.valueToTree(this.getSupportsGetObjectRange()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_s3objectlambda.AccessPointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AccessPointProps.Jsii$Proxy that = (AccessPointProps.Jsii$Proxy) o;

            if (!bucket.equals(that.bucket)) return false;
            if (!handler.equals(that.handler)) return false;
            if (this.accessPointName != null ? !this.accessPointName.equals(that.accessPointName) : that.accessPointName != null) return false;
            if (this.cloudWatchMetricsEnabled != null ? !this.cloudWatchMetricsEnabled.equals(that.cloudWatchMetricsEnabled) : that.cloudWatchMetricsEnabled != null) return false;
            if (this.payload != null ? !this.payload.equals(that.payload) : that.payload != null) return false;
            if (this.supportsGetObjectPartNumber != null ? !this.supportsGetObjectPartNumber.equals(that.supportsGetObjectPartNumber) : that.supportsGetObjectPartNumber != null) return false;
            return this.supportsGetObjectRange != null ? this.supportsGetObjectRange.equals(that.supportsGetObjectRange) : that.supportsGetObjectRange == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucket.hashCode();
            result = 31 * result + (this.handler.hashCode());
            result = 31 * result + (this.accessPointName != null ? this.accessPointName.hashCode() : 0);
            result = 31 * result + (this.cloudWatchMetricsEnabled != null ? this.cloudWatchMetricsEnabled.hashCode() : 0);
            result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
            result = 31 * result + (this.supportsGetObjectPartNumber != null ? this.supportsGetObjectPartNumber.hashCode() : 0);
            result = 31 * result + (this.supportsGetObjectRange != null ? this.supportsGetObjectRange.hashCode() : 0);
            return result;
        }
    }
}
