package software.amazon.awscdk.services.route53recoveryreadiness;

/**
 * Properties for defining a `CfnCell`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53recoveryreadiness.*;
 * CfnCellProps cfnCellProps = CfnCellProps.builder()
 *         .cellName("cellName")
 *         .cells(List.of("cells"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:09.005Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_route53recoveryreadiness.CfnCellProps")
@software.amazon.jsii.Jsii.Proxy(CfnCellProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCellProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the cell to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCellName() {
        return null;
    }

    /**
     * A list of cell Amazon Resource Names (ARNs) contained within this cell, for use in nested cells.
     * <p>
     * For example, Availability Zones within specific AWS Regions .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCells() {
        return null;
    }

    /**
     * A collection of tags associated with a resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCellProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCellProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCellProps> {
        java.lang.String cellName;
        java.util.List<java.lang.String> cells;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnCellProps#getCellName}
         * @param cellName The name of the cell to create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cellName(java.lang.String cellName) {
            this.cellName = cellName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCellProps#getCells}
         * @param cells A list of cell Amazon Resource Names (ARNs) contained within this cell, for use in nested cells.
         *              For example, Availability Zones within specific AWS Regions .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cells(java.util.List<java.lang.String> cells) {
            this.cells = cells;
            return this;
        }

        /**
         * Sets the value of {@link CfnCellProps#getTags}
         * @param tags A collection of tags associated with a resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCellProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCellProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCellProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCellProps {
        private final java.lang.String cellName;
        private final java.util.List<java.lang.String> cells;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cellName = software.amazon.jsii.Kernel.get(this, "cellName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cells = software.amazon.jsii.Kernel.get(this, "cells", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cellName = builder.cellName;
            this.cells = builder.cells;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getCellName() {
            return this.cellName;
        }

        @Override
        public final java.util.List<java.lang.String> getCells() {
            return this.cells;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCellName() != null) {
                data.set("cellName", om.valueToTree(this.getCellName()));
            }
            if (this.getCells() != null) {
                data.set("cells", om.valueToTree(this.getCells()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_route53recoveryreadiness.CfnCellProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCellProps.Jsii$Proxy that = (CfnCellProps.Jsii$Proxy) o;

            if (this.cellName != null ? !this.cellName.equals(that.cellName) : that.cellName != null) return false;
            if (this.cells != null ? !this.cells.equals(that.cells) : that.cells != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cellName != null ? this.cellName.hashCode() : 0;
            result = 31 * result + (this.cells != null ? this.cells.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
