package software.amazon.awscdk.services.route53.targets;

/**
 * (experimental) Use a CloudFront Distribution as an alias record target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * HostedZone myZone;
 * CloudFrontWebDistribution distribution;
 * AaaaRecord.Builder.create(this, "Alias")
 *         .zone(myZone)
 *         .target(RecordTarget.fromAlias(new CloudFrontTarget(distribution)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:08.954Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_route53_targets.CloudFrontTarget")
public class CloudFrontTarget extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.route53.IAliasRecordTarget {

    protected CloudFrontTarget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudFrontTarget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CLOUDFRONT_ZONE_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.route53.targets.CloudFrontTarget.class, "CLOUDFRONT_ZONE_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param distribution This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public CloudFrontTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IDistribution distribution) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(distribution, "distribution is required") });
    }

    /**
     * (experimental) Get the hosted zone id for the current scope.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull java.lang.String getHostedZoneId(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IConstruct scope) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.targets.CloudFrontTarget.class, "getHostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * (experimental) Return hosted zone ID and DNS name, usable for Route53 alias targets.
     * <p>
     * @param _record This parameter is required.
     * @param _zone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.AliasRecordTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IRecordSet _record, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.IHostedZone _zone) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.AliasRecordTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_record, "_record is required"), _zone });
    }

    /**
     * (experimental) Return hosted zone ID and DNS name, usable for Route53 alias targets.
     * <p>
     * @param _record This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.AliasRecordTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IRecordSet _record) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.AliasRecordTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_record, "_record is required") });
    }

    /**
     * (experimental) The hosted zone Id if using an alias record in Route53.
     * <p>
     * This value never changes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String CLOUDFRONT_ZONE_ID;
}
