package software.amazon.awscdk.services.route53;

/**
 * (experimental) A DNS CNAME record.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * // hosted zone and route53 features
 * String hostedZoneId;
 * String zoneName = "example.com";
 * String myDomainName = "api.example.com";
 * Certificate certificate = Certificate.Builder.create(this, "cert").domainName(myDomainName).build();
 * GraphqlApi api = GraphqlApi.Builder.create(this, "api")
 *         .name("myApi")
 *         .domainName(DomainOptions.builder()
 *                 .certificate(certificate)
 *                 .domainName(myDomainName)
 *                 .build())
 *         .build();
 * // hosted zone for adding appsync domain
 * IHostedZone zone = HostedZone.fromHostedZoneAttributes(this, "HostedZone", HostedZoneAttributes.builder()
 *         .hostedZoneId(hostedZoneId)
 *         .zoneName(zoneName)
 *         .build());
 * // create a cname to the appsync domain. will map to something like xxxx.cloudfront.net
 * // create a cname to the appsync domain. will map to something like xxxx.cloudfront.net
 * CnameRecord.Builder.create(this, "CnameApiRecord")
 *         .recordName("api")
 *         .zone(zone)
 *         .domainName(myDomainName)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:08.876Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_route53.CnameRecord")
public class CnameRecord extends software.amazon.awscdk.services.route53.RecordSet {

    protected CnameRecord(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CnameRecord(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public CnameRecord(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.CnameRecordProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.route53.CnameRecord}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.route53.CnameRecord> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.route53.CnameRecordProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.route53.CnameRecordProps.Builder();
        }

        /**
         * (experimental) The hosted zone in which to define the new record.
         * <p>
         * @return {@code this}
         * @param zone The hosted zone in which to define the new record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder zone(final software.amazon.awscdk.services.route53.IHostedZone zone) {
            this.props.zone(zone);
            return this;
        }

        /**
         * (experimental) A comment to add on the record.
         * <p>
         * Default: no comment
         * <p>
         * @return {@code this}
         * @param comment A comment to add on the record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * (experimental) The domain name for this record.
         * <p>
         * Default: zone root
         * <p>
         * @return {@code this}
         * @param recordName The domain name for this record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder recordName(final java.lang.String recordName) {
            this.props.recordName(recordName);
            return this;
        }

        /**
         * (experimental) The resource record cache time to live (TTL).
         * <p>
         * Default: Duration.minutes(30)
         * <p>
         * @return {@code this}
         * @param ttl The resource record cache time to live (TTL). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ttl(final software.amazon.awscdk.core.Duration ttl) {
            this.props.ttl(ttl);
            return this;
        }

        /**
         * (experimental) The domain name.
         * <p>
         * @return {@code this}
         * @param domainName The domain name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.route53.CnameRecord}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.route53.CnameRecord build() {
            return new software.amazon.awscdk.services.route53.CnameRecord(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
