package software.amazon.awscdk.services.rolesanywhere;

/**
 * Properties for defining a `CfnProfile`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rolesanywhere.*;
 * CfnProfileProps cfnProfileProps = CfnProfileProps.builder()
 *         .durationSeconds(123)
 *         .enabled(false)
 *         .managedPolicyArns(List.of("managedPolicyArns"))
 *         .name("name")
 *         .requireInstanceProperties(false)
 *         .roleArns(List.of("roleArns"))
 *         .sessionPolicy("sessionPolicy")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:08.723Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_rolesanywhere.CfnProfileProps")
@software.amazon.jsii.Jsii.Proxy(CfnProfileProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnProfileProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The number of seconds vended session credentials will be valid for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDurationSeconds() {
        return null;
    }

    /**
     * The enabled status of the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
        return null;
    }

    /**
     * A list of managed policy ARNs.
     * <p>
     * Managed policies identified by this list will be applied to the vended session credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getManagedPolicyArns() {
        return null;
    }

    /**
     * The customer specified name of the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Specifies whether instance properties are required in CreateSession requests with this profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRequireInstanceProperties() {
        return null;
    }

    /**
     * A list of IAM role ARNs that can be assumed when this profile is specified in a CreateSession request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRoleArns() {
        return null;
    }

    /**
     * A session policy that will applied to the trust boundary of the vended session credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSessionPolicy() {
        return null;
    }

    /**
     * A list of Tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnProfileProps> {
        java.lang.Number durationSeconds;
        java.lang.Object enabled;
        java.util.List<java.lang.String> managedPolicyArns;
        java.lang.String name;
        java.lang.Object requireInstanceProperties;
        java.util.List<java.lang.String> roleArns;
        java.lang.String sessionPolicy;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnProfileProps#getDurationSeconds}
         * @param durationSeconds The number of seconds vended session credentials will be valid for.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder durationSeconds(java.lang.Number durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnProfileProps#getEnabled}
         * @param enabled The enabled status of the resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnProfileProps#getEnabled}
         * @param enabled The enabled status of the resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnProfileProps#getManagedPolicyArns}
         * @param managedPolicyArns A list of managed policy ARNs.
         *                          Managed policies identified by this list will be applied to the vended session credentials.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedPolicyArns(java.util.List<java.lang.String> managedPolicyArns) {
            this.managedPolicyArns = managedPolicyArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnProfileProps#getName}
         * @param name The customer specified name of the resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnProfileProps#getRequireInstanceProperties}
         * @param requireInstanceProperties Specifies whether instance properties are required in CreateSession requests with this profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requireInstanceProperties(java.lang.Boolean requireInstanceProperties) {
            this.requireInstanceProperties = requireInstanceProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnProfileProps#getRequireInstanceProperties}
         * @param requireInstanceProperties Specifies whether instance properties are required in CreateSession requests with this profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requireInstanceProperties(software.amazon.awscdk.core.IResolvable requireInstanceProperties) {
            this.requireInstanceProperties = requireInstanceProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnProfileProps#getRoleArns}
         * @param roleArns A list of IAM role ARNs that can be assumed when this profile is specified in a CreateSession request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArns(java.util.List<java.lang.String> roleArns) {
            this.roleArns = roleArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnProfileProps#getSessionPolicy}
         * @param sessionPolicy A session policy that will applied to the trust boundary of the vended session credentials.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sessionPolicy(java.lang.String sessionPolicy) {
            this.sessionPolicy = sessionPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnProfileProps#getTags}
         * @param tags A list of Tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnProfileProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnProfileProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnProfileProps {
        private final java.lang.Number durationSeconds;
        private final java.lang.Object enabled;
        private final java.util.List<java.lang.String> managedPolicyArns;
        private final java.lang.String name;
        private final java.lang.Object requireInstanceProperties;
        private final java.util.List<java.lang.String> roleArns;
        private final java.lang.String sessionPolicy;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.durationSeconds = software.amazon.jsii.Kernel.get(this, "durationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.managedPolicyArns = software.amazon.jsii.Kernel.get(this, "managedPolicyArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.requireInstanceProperties = software.amazon.jsii.Kernel.get(this, "requireInstanceProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roleArns = software.amazon.jsii.Kernel.get(this, "roleArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.sessionPolicy = software.amazon.jsii.Kernel.get(this, "sessionPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.durationSeconds = builder.durationSeconds;
            this.enabled = builder.enabled;
            this.managedPolicyArns = builder.managedPolicyArns;
            this.name = builder.name;
            this.requireInstanceProperties = builder.requireInstanceProperties;
            this.roleArns = builder.roleArns;
            this.sessionPolicy = builder.sessionPolicy;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Number getDurationSeconds() {
            return this.durationSeconds;
        }

        @Override
        public final java.lang.Object getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.util.List<java.lang.String> getManagedPolicyArns() {
            return this.managedPolicyArns;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getRequireInstanceProperties() {
            return this.requireInstanceProperties;
        }

        @Override
        public final java.util.List<java.lang.String> getRoleArns() {
            return this.roleArns;
        }

        @Override
        public final java.lang.String getSessionPolicy() {
            return this.sessionPolicy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDurationSeconds() != null) {
                data.set("durationSeconds", om.valueToTree(this.getDurationSeconds()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getManagedPolicyArns() != null) {
                data.set("managedPolicyArns", om.valueToTree(this.getManagedPolicyArns()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getRequireInstanceProperties() != null) {
                data.set("requireInstanceProperties", om.valueToTree(this.getRequireInstanceProperties()));
            }
            if (this.getRoleArns() != null) {
                data.set("roleArns", om.valueToTree(this.getRoleArns()));
            }
            if (this.getSessionPolicy() != null) {
                data.set("sessionPolicy", om.valueToTree(this.getSessionPolicy()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_rolesanywhere.CfnProfileProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnProfileProps.Jsii$Proxy that = (CfnProfileProps.Jsii$Proxy) o;

            if (this.durationSeconds != null ? !this.durationSeconds.equals(that.durationSeconds) : that.durationSeconds != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.managedPolicyArns != null ? !this.managedPolicyArns.equals(that.managedPolicyArns) : that.managedPolicyArns != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.requireInstanceProperties != null ? !this.requireInstanceProperties.equals(that.requireInstanceProperties) : that.requireInstanceProperties != null) return false;
            if (this.roleArns != null ? !this.roleArns.equals(that.roleArns) : that.roleArns != null) return false;
            if (this.sessionPolicy != null ? !this.sessionPolicy.equals(that.sessionPolicy) : that.sessionPolicy != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.durationSeconds != null ? this.durationSeconds.hashCode() : 0;
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.managedPolicyArns != null ? this.managedPolicyArns.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.requireInstanceProperties != null ? this.requireInstanceProperties.hashCode() : 0);
            result = 31 * result + (this.roleArns != null ? this.roleArns.hashCode() : 0);
            result = 31 * result + (this.sessionPolicy != null ? this.sessionPolicy.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
