package software.amazon.awscdk.services.rds;

/**
 * (experimental) The versions for the SQL Server instance engines (those returned by {@link DatabaseInstanceEngine.sqlServerSe}, {@link DatabaseInstanceEngine.sqlServerEx}, {@link DatabaseInstanceEngine.sqlServerWeb} and {@link DatabaseInstanceEngine.sqlServerEe}).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * ParameterGroup parameterGroup = ParameterGroup.Builder.create(this, "ParameterGroup")
 *         .engine(DatabaseInstanceEngine.sqlServerEe(SqlServerEeInstanceEngineProps.builder()
 *                 .version(SqlServerEngineVersion.VER_11)
 *                 .build()))
 *         .parameters(Map.of(
 *                 "locks", "100"))
 *         .build();
 * DatabaseInstance.Builder.create(this, "Database")
 *         .engine(DatabaseInstanceEngine.SQL_SERVER_EE)
 *         .vpc(vpc)
 *         .parameterGroup(parameterGroup)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:08.404Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_rds.SqlServerEngineVersion")
public class SqlServerEngineVersion extends software.amazon.jsii.JsiiObject {

    protected SqlServerEngineVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SqlServerEngineVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        VER_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_11_00_5058_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_11_00_5058_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_11_00_6020_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_11_00_6020_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_11_00_6594_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_11_00_6594_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_11_00_7462_6_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_11_00_7462_6_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_11_00_7493_4_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_11_00_7493_4_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_12_00_5000_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_12_00_5000_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_12_00_5546_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_12_00_5546_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_12_00_5571_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_12_00_5571_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_12_00_6293_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_12_00_6293_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_12_00_6329_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_12_00_6329_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_2164_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_2164_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_4422_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_4422_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_4451_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_4451_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_4466_4_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_4466_4_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_4522_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_4522_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_5216_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_5216_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_5292_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_5292_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_5366_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_5366_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_5426_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_5426_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_5598_27_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_5598_27_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_5820_21_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_5820_21_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_5850_14_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_5850_14_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_5882_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_5882_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_1000_169_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_1000_169_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3015_40_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3015_40_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3035_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3035_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3049_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3049_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3192_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3192_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3223_3_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3223_3_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3281_6_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3281_6_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3294_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3294_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3356_20_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3356_20_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3381_3_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3381_3_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4043_16_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4043_16_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4043_23_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4043_23_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4073_23_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4073_23_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
    }

    /**
     * (experimental) Create a new SqlServerEngineVersion with an arbitrary version.
     * <p>
     * @param sqlServerFullVersion the full version string, for example "15.00.3049.1.v1". This parameter is required.
     * @param sqlServerMajorVersion the major version of the engine, for example "15.00". This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.SqlServerEngineVersion of(final @org.jetbrains.annotations.NotNull java.lang.String sqlServerFullVersion, final @org.jetbrains.annotations.NotNull java.lang.String sqlServerMajorVersion) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class), new Object[] { java.util.Objects.requireNonNull(sqlServerFullVersion, "sqlServerFullVersion is required"), java.util.Objects.requireNonNull(sqlServerMajorVersion, "sqlServerMajorVersion is required") });
    }

    /**
     * (experimental) Version "11.00" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_11;

    /**
     * (experimental) Version "11.00.5058.0.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_11_00_5058_0_V1;

    /**
     * (experimental) Version "11.00.6020.0.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_11_00_6020_0_V1;

    /**
     * (experimental) Version "11.00.6594.0.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_11_00_6594_0_V1;

    /**
     * (experimental) Version "11.00.7462.6.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_11_00_7462_6_V1;

    /**
     * (experimental) Version "11.00.7493.4.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_11_00_7493_4_V1;

    /**
     * (experimental) Version "12.00" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_12;

    /**
     * (experimental) Version "12.00.5000.0.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_12_00_5000_0_V1;

    /**
     * (experimental) Version "12.00.5546.0.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_12_00_5546_0_V1;

    /**
     * (experimental) Version "12.00.5571.0.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_12_00_5571_0_V1;

    /**
     * (experimental) Version "12.00.6293.0.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_12_00_6293_0_V1;

    /**
     * (experimental) Version "12.00.6329.1.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_12_00_6329_1_V1;

    /**
     * (experimental) Version "13.00" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13;

    /**
     * (experimental) Version "13.00.2164.0.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_2164_0_V1;

    /**
     * (experimental) Version "13.00.4422.0.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_4422_0_V1;

    /**
     * (experimental) Version "13.00.4451.0.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_4451_0_V1;

    /**
     * (experimental) Version "13.00.4466.4.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_4466_4_V1;

    /**
     * (experimental) Version "13.00.4522.0.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_4522_0_V1;

    /**
     * (experimental) Version "13.00.5216.0.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_5216_0_V1;

    /**
     * (experimental) Version "13.00.5292.0.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_5292_0_V1;

    /**
     * (experimental) Version "13.00.5366.0.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_5366_0_V1;

    /**
     * (experimental) Version "13.00.5426.0.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_5426_0_V1;

    /**
     * (experimental) Version "13.00.5598.27.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_5598_27_V1;

    /**
     * (experimental) Version "13.00.5820.21.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_5820_21_V1;

    /**
     * (experimental) Version "13.00.5850.14.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_5850_14_V1;

    /**
     * (experimental) Version "13.00.5882.1.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_5882_1_V1;

    /**
     * (experimental) Version "14.00" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14;

    /**
     * (experimental) Version "14.00.1000.169.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_1000_169_V1;

    /**
     * (experimental) Version "14.00.3015.40.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3015_40_V1;

    /**
     * (experimental) Version "14.00.3035.2.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3035_2_V1;

    /**
     * (experimental) Version "14.00.3049.1.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3049_1_V1;

    /**
     * (deprecated) Version "14.00.3192.2.v1".
     * <p>
     * @deprecated SQL Server version 14.00.3192.2.v1 reached end of life
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3192_2_V1;

    /**
     * (experimental) Version "14.00.3223.3.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3223_3_V1;

    /**
     * (experimental) Version "14.00.3281.6.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3281_6_V1;

    /**
     * (experimental) Version "14.00.3294.2.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3294_2_V1;

    /**
     * (experimental) Version "14.00.3356.20.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3356_20_V1;

    /**
     * (experimental) Version "14.00.3381.3.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3381_3_V1;

    /**
     * (experimental) Version "15.00" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15;

    /**
     * (experimental) Version "15.00.4043.16.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4043_16_V1;

    /**
     * (deprecated) Version "15.00.4043.23.v1".
     * <p>
     * @deprecated This version is erroneous. You might be looking for {@link SqlServerEngineVersion.VER_15_00_4073_23_V1}, instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4043_23_V1;

    /**
     * (experimental) Version "15.00.4073.23.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4073_23_V1;

    /**
     * (experimental) The full version string, for example, "15.00.3049.1.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getSqlServerFullVersion() {
        return software.amazon.jsii.Kernel.get(this, "sqlServerFullVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The major version of the engine, for example, "15.00".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getSqlServerMajorVersion() {
        return software.amazon.jsii.Kernel.get(this, "sqlServerMajorVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
