package software.amazon.awscdk.services.quicksight;

/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 * <p>
 * Creates a theme.
 * <p>
 * A <em>theme</em> is set of configuration options for color and layout. Themes apply to analyses and dashboards. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html">Using Themes in Amazon QuickSight</a> in the <em>Amazon QuickSight User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.quicksight.*;
 * CfnTheme cfnTheme = CfnTheme.Builder.create(this, "MyCfnTheme")
 *         .awsAccountId("awsAccountId")
 *         .themeId("themeId")
 *         // the properties below are optional
 *         .baseThemeId("baseThemeId")
 *         .configuration(ThemeConfigurationProperty.builder()
 *                 .dataColorPalette(DataColorPaletteProperty.builder()
 *                         .colors(List.of("colors"))
 *                         .emptyFillColor("emptyFillColor")
 *                         .minMaxGradient(List.of("minMaxGradient"))
 *                         .build())
 *                 .sheet(SheetStyleProperty.builder()
 *                         .tile(TileStyleProperty.builder()
 *                                 .border(BorderStyleProperty.builder()
 *                                         .show(false)
 *                                         .build())
 *                                 .build())
 *                         .tileLayout(TileLayoutStyleProperty.builder()
 *                                 .gutter(GutterStyleProperty.builder()
 *                                         .show(false)
 *                                         .build())
 *                                 .margin(MarginStyleProperty.builder()
 *                                         .show(false)
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .typography(TypographyProperty.builder()
 *                         .fontFamilies(List.of(FontProperty.builder()
 *                                 .fontFamily("fontFamily")
 *                                 .build()))
 *                         .build())
 *                 .uiColorPalette(UIColorPaletteProperty.builder()
 *                         .accent("accent")
 *                         .accentForeground("accentForeground")
 *                         .danger("danger")
 *                         .dangerForeground("dangerForeground")
 *                         .dimension("dimension")
 *                         .dimensionForeground("dimensionForeground")
 *                         .measure("measure")
 *                         .measureForeground("measureForeground")
 *                         .primaryBackground("primaryBackground")
 *                         .primaryForeground("primaryForeground")
 *                         .secondaryBackground("secondaryBackground")
 *                         .secondaryForeground("secondaryForeground")
 *                         .success("success")
 *                         .successForeground("successForeground")
 *                         .warning("warning")
 *                         .warningForeground("warningForeground")
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .permissions(List.of(ResourcePermissionProperty.builder()
 *                 .actions(List.of("actions"))
 *                 .principal("principal")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .versionDescription("versionDescription")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:07.958Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTheme")
public class CfnTheme extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnTheme(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTheme(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.quicksight.CfnTheme.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::QuickSight::Theme`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTheme(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.quicksight.CfnThemeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the theme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time the theme was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time the theme was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastUpdatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastUpdatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Theme type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrType() {
        return software.amazon.jsii.Kernel.get(this, "attrType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVersionArn() {
        return software.amazon.jsii.Kernel.get(this, "attrVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVersionBaseThemeId() {
        return software.amazon.jsii.Kernel.get(this, "attrVersionBaseThemeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVersionCreatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrVersionCreatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVersionDescription() {
        return software.amazon.jsii.Kernel.get(this, "attrVersionDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable getAttrVersionErrors() {
        return software.amazon.jsii.Kernel.get(this, "attrVersionErrors", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVersionStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrVersionStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable getAttrVersionVersionNumber() {
        return software.amazon.jsii.Kernel.get(this, "attrVersionVersionNumber", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IResolvable.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A map of the key-value pairs for the resource tag or tags that you want to add to the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The ID of the AWS account where you want to store the new theme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAwsAccountId() {
        return software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the AWS account where you want to store the new theme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAwsAccountId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "awsAccountId", java.util.Objects.requireNonNull(value, "awsAccountId is required"));
    }

    /**
     * An ID for the theme that you want to create.
     * <p>
     * The theme ID is unique per AWS Region in each AWS account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getThemeId() {
        return software.amazon.jsii.Kernel.get(this, "themeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An ID for the theme that you want to create.
     * <p>
     * The theme ID is unique per AWS Region in each AWS account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setThemeId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "themeId", java.util.Objects.requireNonNull(value, "themeId is required"));
    }

    /**
     * The ID of the theme that a custom theme will inherit from.
     * <p>
     * All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use <code>ListThemes</code> or choose <em>Themes</em> from within an analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBaseThemeId() {
        return software.amazon.jsii.Kernel.get(this, "baseThemeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the theme that a custom theme will inherit from.
     * <p>
     * All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use <code>ListThemes</code> or choose <em>Themes</em> from within an analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBaseThemeId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "baseThemeId", value);
    }

    /**
     * The theme configuration, which contains the theme display properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The theme configuration, which contains the theme display properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnTheme.ThemeConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "configuration", value);
    }

    /**
     * The theme configuration, which contains the theme display properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configuration", value);
    }

    /**
     * A display name for the theme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A display name for the theme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * A valid grouping of resource permissions to apply to the new theme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPermissions() {
        return software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A valid grouping of resource permissions to apply to the new theme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "permissions", value);
    }

    /**
     * A valid grouping of resource permissions to apply to the new theme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnTheme.ResourcePermissionProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.quicksight.CfnTheme.ResourcePermissionProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "permissions", value);
    }

    /**
     * A description of the first version of the theme that you're creating.
     * <p>
     * Every time <code>UpdateTheme</code> is called, a new version is created. Each version of the theme has a description of the version in the <code>VersionDescription</code> field.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVersionDescription() {
        return software.amazon.jsii.Kernel.get(this, "versionDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the first version of the theme that you're creating.
     * <p>
     * Every time <code>UpdateTheme</code> is called, a new version is created. Each version of the theme has a description of the version in the <code>VersionDescription</code> field.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVersionDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "versionDescription", value);
    }
    /**
     * The display options for tile borders for visuals.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * BorderStyleProperty borderStyleProperty = BorderStyleProperty.builder()
     *         .show(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTheme.BorderStyleProperty")
    @software.amazon.jsii.Jsii.Proxy(BorderStyleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BorderStyleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The option to enable display of borders for visuals.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getShow() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BorderStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BorderStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BorderStyleProperty> {
            java.lang.Object show;

            /**
             * Sets the value of {@link BorderStyleProperty#getShow}
             * @param show The option to enable display of borders for visuals.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder show(java.lang.Boolean show) {
                this.show = show;
                return this;
            }

            /**
             * Sets the value of {@link BorderStyleProperty#getShow}
             * @param show The option to enable display of borders for visuals.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder show(software.amazon.awscdk.core.IResolvable show) {
                this.show = show;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BorderStyleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BorderStyleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BorderStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BorderStyleProperty {
            private final java.lang.Object show;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.show = software.amazon.jsii.Kernel.get(this, "show", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.show = builder.show;
            }

            @Override
            public final java.lang.Object getShow() {
                return this.show;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getShow() != null) {
                    data.set("show", om.valueToTree(this.getShow()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTheme.BorderStyleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BorderStyleProperty.Jsii$Proxy that = (BorderStyleProperty.Jsii$Proxy) o;

                return this.show != null ? this.show.equals(that.show) : that.show == null;
            }

            @Override
            public final int hashCode() {
                int result = this.show != null ? this.show.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The theme colors that are used for data colors in charts.
     * <p>
     * The colors description is a hexadecimal color code that consists of six alphanumerical characters, prefixed with <code>#</code> , for example #37BFF5.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataColorPaletteProperty dataColorPaletteProperty = DataColorPaletteProperty.builder()
     *         .colors(List.of("colors"))
     *         .emptyFillColor("emptyFillColor")
     *         .minMaxGradient(List.of("minMaxGradient"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTheme.DataColorPaletteProperty")
    @software.amazon.jsii.Jsii.Proxy(DataColorPaletteProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataColorPaletteProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The hexadecimal codes for the colors.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getColors() {
            return null;
        }

        /**
         * The hexadecimal code of a color that applies to charts where a lack of data is highlighted.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEmptyFillColor() {
            return null;
        }

        /**
         * The minimum and maximum hexadecimal codes that describe a color gradient.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMinMaxGradient() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataColorPaletteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataColorPaletteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataColorPaletteProperty> {
            java.util.List<java.lang.String> colors;
            java.lang.String emptyFillColor;
            java.util.List<java.lang.String> minMaxGradient;

            /**
             * Sets the value of {@link DataColorPaletteProperty#getColors}
             * @param colors The hexadecimal codes for the colors.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colors(java.util.List<java.lang.String> colors) {
                this.colors = colors;
                return this;
            }

            /**
             * Sets the value of {@link DataColorPaletteProperty#getEmptyFillColor}
             * @param emptyFillColor The hexadecimal code of a color that applies to charts where a lack of data is highlighted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emptyFillColor(java.lang.String emptyFillColor) {
                this.emptyFillColor = emptyFillColor;
                return this;
            }

            /**
             * Sets the value of {@link DataColorPaletteProperty#getMinMaxGradient}
             * @param minMaxGradient The minimum and maximum hexadecimal codes that describe a color gradient.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minMaxGradient(java.util.List<java.lang.String> minMaxGradient) {
                this.minMaxGradient = minMaxGradient;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataColorPaletteProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataColorPaletteProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataColorPaletteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataColorPaletteProperty {
            private final java.util.List<java.lang.String> colors;
            private final java.lang.String emptyFillColor;
            private final java.util.List<java.lang.String> minMaxGradient;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.colors = software.amazon.jsii.Kernel.get(this, "colors", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.emptyFillColor = software.amazon.jsii.Kernel.get(this, "emptyFillColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.minMaxGradient = software.amazon.jsii.Kernel.get(this, "minMaxGradient", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.colors = builder.colors;
                this.emptyFillColor = builder.emptyFillColor;
                this.minMaxGradient = builder.minMaxGradient;
            }

            @Override
            public final java.util.List<java.lang.String> getColors() {
                return this.colors;
            }

            @Override
            public final java.lang.String getEmptyFillColor() {
                return this.emptyFillColor;
            }

            @Override
            public final java.util.List<java.lang.String> getMinMaxGradient() {
                return this.minMaxGradient;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColors() != null) {
                    data.set("colors", om.valueToTree(this.getColors()));
                }
                if (this.getEmptyFillColor() != null) {
                    data.set("emptyFillColor", om.valueToTree(this.getEmptyFillColor()));
                }
                if (this.getMinMaxGradient() != null) {
                    data.set("minMaxGradient", om.valueToTree(this.getMinMaxGradient()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTheme.DataColorPaletteProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataColorPaletteProperty.Jsii$Proxy that = (DataColorPaletteProperty.Jsii$Proxy) o;

                if (this.colors != null ? !this.colors.equals(that.colors) : that.colors != null) return false;
                if (this.emptyFillColor != null ? !this.emptyFillColor.equals(that.emptyFillColor) : that.emptyFillColor != null) return false;
                return this.minMaxGradient != null ? this.minMaxGradient.equals(that.minMaxGradient) : that.minMaxGradient == null;
            }

            @Override
            public final int hashCode() {
                int result = this.colors != null ? this.colors.hashCode() : 0;
                result = 31 * result + (this.emptyFillColor != null ? this.emptyFillColor.hashCode() : 0);
                result = 31 * result + (this.minMaxGradient != null ? this.minMaxGradient.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * FontProperty fontProperty = FontProperty.builder()
     *         .fontFamily("fontFamily")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTheme.FontProperty")
    @software.amazon.jsii.Jsii.Proxy(FontProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FontProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnTheme.FontProperty.FontFamily`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFontFamily() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FontProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FontProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FontProperty> {
            java.lang.String fontFamily;

            /**
             * Sets the value of {@link FontProperty#getFontFamily}
             * @param fontFamily `CfnTheme.FontProperty.FontFamily`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontFamily(java.lang.String fontFamily) {
                this.fontFamily = fontFamily;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FontProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FontProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FontProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FontProperty {
            private final java.lang.String fontFamily;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fontFamily = software.amazon.jsii.Kernel.get(this, "fontFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fontFamily = builder.fontFamily;
            }

            @Override
            public final java.lang.String getFontFamily() {
                return this.fontFamily;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFontFamily() != null) {
                    data.set("fontFamily", om.valueToTree(this.getFontFamily()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTheme.FontProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FontProperty.Jsii$Proxy that = (FontProperty.Jsii$Proxy) o;

                return this.fontFamily != null ? this.fontFamily.equals(that.fontFamily) : that.fontFamily == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fontFamily != null ? this.fontFamily.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The display options for gutter spacing between tiles on a sheet.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * GutterStyleProperty gutterStyleProperty = GutterStyleProperty.builder()
     *         .show(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTheme.GutterStyleProperty")
    @software.amazon.jsii.Jsii.Proxy(GutterStyleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GutterStyleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This Boolean value controls whether to display a gutter space between sheet tiles.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getShow() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GutterStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GutterStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GutterStyleProperty> {
            java.lang.Object show;

            /**
             * Sets the value of {@link GutterStyleProperty#getShow}
             * @param show This Boolean value controls whether to display a gutter space between sheet tiles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder show(java.lang.Boolean show) {
                this.show = show;
                return this;
            }

            /**
             * Sets the value of {@link GutterStyleProperty#getShow}
             * @param show This Boolean value controls whether to display a gutter space between sheet tiles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder show(software.amazon.awscdk.core.IResolvable show) {
                this.show = show;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GutterStyleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GutterStyleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GutterStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GutterStyleProperty {
            private final java.lang.Object show;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.show = software.amazon.jsii.Kernel.get(this, "show", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.show = builder.show;
            }

            @Override
            public final java.lang.Object getShow() {
                return this.show;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getShow() != null) {
                    data.set("show", om.valueToTree(this.getShow()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTheme.GutterStyleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GutterStyleProperty.Jsii$Proxy that = (GutterStyleProperty.Jsii$Proxy) o;

                return this.show != null ? this.show.equals(that.show) : that.show == null;
            }

            @Override
            public final int hashCode() {
                int result = this.show != null ? this.show.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The display options for margins around the outside edge of sheets.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * MarginStyleProperty marginStyleProperty = MarginStyleProperty.builder()
     *         .show(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTheme.MarginStyleProperty")
    @software.amazon.jsii.Jsii.Proxy(MarginStyleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MarginStyleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This Boolean value controls whether to display sheet margins.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getShow() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MarginStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MarginStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MarginStyleProperty> {
            java.lang.Object show;

            /**
             * Sets the value of {@link MarginStyleProperty#getShow}
             * @param show This Boolean value controls whether to display sheet margins.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder show(java.lang.Boolean show) {
                this.show = show;
                return this;
            }

            /**
             * Sets the value of {@link MarginStyleProperty#getShow}
             * @param show This Boolean value controls whether to display sheet margins.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder show(software.amazon.awscdk.core.IResolvable show) {
                this.show = show;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MarginStyleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MarginStyleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MarginStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MarginStyleProperty {
            private final java.lang.Object show;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.show = software.amazon.jsii.Kernel.get(this, "show", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.show = builder.show;
            }

            @Override
            public final java.lang.Object getShow() {
                return this.show;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getShow() != null) {
                    data.set("show", om.valueToTree(this.getShow()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTheme.MarginStyleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MarginStyleProperty.Jsii$Proxy that = (MarginStyleProperty.Jsii$Proxy) o;

                return this.show != null ? this.show.equals(that.show) : that.show == null;
            }

            @Override
            public final int hashCode() {
                int result = this.show != null ? this.show.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Permission for the resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ResourcePermissionProperty resourcePermissionProperty = ResourcePermissionProperty.builder()
     *         .actions(List.of("actions"))
     *         .principal("principal")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTheme.ResourcePermissionProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourcePermissionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourcePermissionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IAM action to grant or revoke permissions on.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getActions();

        /**
         * The Amazon Resource Name (ARN) of the principal. This can be one of the following:.
         * <p>
         * <ul>
         * <li>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</li>
         * <li>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</li>
         * <li>The ARN of an AWS account root: This is an IAM ARN rather than a Amazon QuickSight ARN. Use this option only to share resources (templates) across AWS accounts . (This is less common.)</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrincipal();

        /**
         * @return a {@link Builder} of {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourcePermissionProperty> {
            java.util.List<java.lang.String> actions;
            java.lang.String principal;

            /**
             * Sets the value of {@link ResourcePermissionProperty#getActions}
             * @param actions The IAM action to grant or revoke permissions on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(java.util.List<java.lang.String> actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link ResourcePermissionProperty#getPrincipal}
             * @param principal The Amazon Resource Name (ARN) of the principal. This can be one of the following:. This parameter is required.
             *                  <ul>
             *                  <li>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</li>
             *                  <li>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</li>
             *                  <li>The ARN of an AWS account root: This is an IAM ARN rather than a Amazon QuickSight ARN. Use this option only to share resources (templates) across AWS accounts . (This is less common.)</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder principal(java.lang.String principal) {
                this.principal = principal;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourcePermissionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourcePermissionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourcePermissionProperty {
            private final java.util.List<java.lang.String> actions;
            private final java.lang.String principal;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.principal = software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
                this.principal = java.util.Objects.requireNonNull(builder.principal, "principal is required");
            }

            @Override
            public final java.util.List<java.lang.String> getActions() {
                return this.actions;
            }

            @Override
            public final java.lang.String getPrincipal() {
                return this.principal;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actions", om.valueToTree(this.getActions()));
                data.set("principal", om.valueToTree(this.getPrincipal()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTheme.ResourcePermissionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourcePermissionProperty.Jsii$Proxy that = (ResourcePermissionProperty.Jsii$Proxy) o;

                if (!actions.equals(that.actions)) return false;
                return this.principal.equals(that.principal);
            }

            @Override
            public final int hashCode() {
                int result = this.actions.hashCode();
                result = 31 * result + (this.principal.hashCode());
                return result;
            }
        }
    }
    /**
     * The theme display options for sheets.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * SheetStyleProperty sheetStyleProperty = SheetStyleProperty.builder()
     *         .tile(TileStyleProperty.builder()
     *                 .border(BorderStyleProperty.builder()
     *                         .show(false)
     *                         .build())
     *                 .build())
     *         .tileLayout(TileLayoutStyleProperty.builder()
     *                 .gutter(GutterStyleProperty.builder()
     *                         .show(false)
     *                         .build())
     *                 .margin(MarginStyleProperty.builder()
     *                         .show(false)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTheme.SheetStyleProperty")
    @software.amazon.jsii.Jsii.Proxy(SheetStyleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SheetStyleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The display options for tiles.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTile() {
            return null;
        }

        /**
         * The layout options for tiles.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTileLayout() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SheetStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SheetStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SheetStyleProperty> {
            java.lang.Object tile;
            java.lang.Object tileLayout;

            /**
             * Sets the value of {@link SheetStyleProperty#getTile}
             * @param tile The display options for tiles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tile(software.amazon.awscdk.services.quicksight.CfnTheme.TileStyleProperty tile) {
                this.tile = tile;
                return this;
            }

            /**
             * Sets the value of {@link SheetStyleProperty#getTile}
             * @param tile The display options for tiles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tile(software.amazon.awscdk.core.IResolvable tile) {
                this.tile = tile;
                return this;
            }

            /**
             * Sets the value of {@link SheetStyleProperty#getTileLayout}
             * @param tileLayout The layout options for tiles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tileLayout(software.amazon.awscdk.services.quicksight.CfnTheme.TileLayoutStyleProperty tileLayout) {
                this.tileLayout = tileLayout;
                return this;
            }

            /**
             * Sets the value of {@link SheetStyleProperty#getTileLayout}
             * @param tileLayout The layout options for tiles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tileLayout(software.amazon.awscdk.core.IResolvable tileLayout) {
                this.tileLayout = tileLayout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SheetStyleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SheetStyleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SheetStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SheetStyleProperty {
            private final java.lang.Object tile;
            private final java.lang.Object tileLayout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.tile = software.amazon.jsii.Kernel.get(this, "tile", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tileLayout = software.amazon.jsii.Kernel.get(this, "tileLayout", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.tile = builder.tile;
                this.tileLayout = builder.tileLayout;
            }

            @Override
            public final java.lang.Object getTile() {
                return this.tile;
            }

            @Override
            public final java.lang.Object getTileLayout() {
                return this.tileLayout;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTile() != null) {
                    data.set("tile", om.valueToTree(this.getTile()));
                }
                if (this.getTileLayout() != null) {
                    data.set("tileLayout", om.valueToTree(this.getTileLayout()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTheme.SheetStyleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SheetStyleProperty.Jsii$Proxy that = (SheetStyleProperty.Jsii$Proxy) o;

                if (this.tile != null ? !this.tile.equals(that.tile) : that.tile != null) return false;
                return this.tileLayout != null ? this.tileLayout.equals(that.tileLayout) : that.tileLayout == null;
            }

            @Override
            public final int hashCode() {
                int result = this.tile != null ? this.tile.hashCode() : 0;
                result = 31 * result + (this.tileLayout != null ? this.tileLayout.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The theme configuration.
     * <p>
     * This configuration contains all of the display properties for a theme.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ThemeConfigurationProperty themeConfigurationProperty = ThemeConfigurationProperty.builder()
     *         .dataColorPalette(DataColorPaletteProperty.builder()
     *                 .colors(List.of("colors"))
     *                 .emptyFillColor("emptyFillColor")
     *                 .minMaxGradient(List.of("minMaxGradient"))
     *                 .build())
     *         .sheet(SheetStyleProperty.builder()
     *                 .tile(TileStyleProperty.builder()
     *                         .border(BorderStyleProperty.builder()
     *                                 .show(false)
     *                                 .build())
     *                         .build())
     *                 .tileLayout(TileLayoutStyleProperty.builder()
     *                         .gutter(GutterStyleProperty.builder()
     *                                 .show(false)
     *                                 .build())
     *                         .margin(MarginStyleProperty.builder()
     *                                 .show(false)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .typography(TypographyProperty.builder()
     *                 .fontFamilies(List.of(FontProperty.builder()
     *                         .fontFamily("fontFamily")
     *                         .build()))
     *                 .build())
     *         .uiColorPalette(UIColorPaletteProperty.builder()
     *                 .accent("accent")
     *                 .accentForeground("accentForeground")
     *                 .danger("danger")
     *                 .dangerForeground("dangerForeground")
     *                 .dimension("dimension")
     *                 .dimensionForeground("dimensionForeground")
     *                 .measure("measure")
     *                 .measureForeground("measureForeground")
     *                 .primaryBackground("primaryBackground")
     *                 .primaryForeground("primaryForeground")
     *                 .secondaryBackground("secondaryBackground")
     *                 .secondaryForeground("secondaryForeground")
     *                 .success("success")
     *                 .successForeground("successForeground")
     *                 .warning("warning")
     *                 .warningForeground("warningForeground")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTheme.ThemeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ThemeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ThemeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Color properties that apply to chart data colors.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataColorPalette() {
            return null;
        }

        /**
         * Display options related to sheets.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSheet() {
            return null;
        }

        /**
         * `CfnTheme.ThemeConfigurationProperty.Typography`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTypography() {
            return null;
        }

        /**
         * Color properties that apply to the UI and to charts, excluding the colors that apply to data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUiColorPalette() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ThemeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ThemeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ThemeConfigurationProperty> {
            java.lang.Object dataColorPalette;
            java.lang.Object sheet;
            java.lang.Object typography;
            java.lang.Object uiColorPalette;

            /**
             * Sets the value of {@link ThemeConfigurationProperty#getDataColorPalette}
             * @param dataColorPalette Color properties that apply to chart data colors.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataColorPalette(software.amazon.awscdk.services.quicksight.CfnTheme.DataColorPaletteProperty dataColorPalette) {
                this.dataColorPalette = dataColorPalette;
                return this;
            }

            /**
             * Sets the value of {@link ThemeConfigurationProperty#getDataColorPalette}
             * @param dataColorPalette Color properties that apply to chart data colors.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataColorPalette(software.amazon.awscdk.core.IResolvable dataColorPalette) {
                this.dataColorPalette = dataColorPalette;
                return this;
            }

            /**
             * Sets the value of {@link ThemeConfigurationProperty#getSheet}
             * @param sheet Display options related to sheets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sheet(software.amazon.awscdk.services.quicksight.CfnTheme.SheetStyleProperty sheet) {
                this.sheet = sheet;
                return this;
            }

            /**
             * Sets the value of {@link ThemeConfigurationProperty#getSheet}
             * @param sheet Display options related to sheets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sheet(software.amazon.awscdk.core.IResolvable sheet) {
                this.sheet = sheet;
                return this;
            }

            /**
             * Sets the value of {@link ThemeConfigurationProperty#getTypography}
             * @param typography `CfnTheme.ThemeConfigurationProperty.Typography`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder typography(software.amazon.awscdk.services.quicksight.CfnTheme.TypographyProperty typography) {
                this.typography = typography;
                return this;
            }

            /**
             * Sets the value of {@link ThemeConfigurationProperty#getTypography}
             * @param typography `CfnTheme.ThemeConfigurationProperty.Typography`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder typography(software.amazon.awscdk.core.IResolvable typography) {
                this.typography = typography;
                return this;
            }

            /**
             * Sets the value of {@link ThemeConfigurationProperty#getUiColorPalette}
             * @param uiColorPalette Color properties that apply to the UI and to charts, excluding the colors that apply to data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uiColorPalette(software.amazon.awscdk.services.quicksight.CfnTheme.UIColorPaletteProperty uiColorPalette) {
                this.uiColorPalette = uiColorPalette;
                return this;
            }

            /**
             * Sets the value of {@link ThemeConfigurationProperty#getUiColorPalette}
             * @param uiColorPalette Color properties that apply to the UI and to charts, excluding the colors that apply to data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uiColorPalette(software.amazon.awscdk.core.IResolvable uiColorPalette) {
                this.uiColorPalette = uiColorPalette;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ThemeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ThemeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ThemeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ThemeConfigurationProperty {
            private final java.lang.Object dataColorPalette;
            private final java.lang.Object sheet;
            private final java.lang.Object typography;
            private final java.lang.Object uiColorPalette;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataColorPalette = software.amazon.jsii.Kernel.get(this, "dataColorPalette", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sheet = software.amazon.jsii.Kernel.get(this, "sheet", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.typography = software.amazon.jsii.Kernel.get(this, "typography", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.uiColorPalette = software.amazon.jsii.Kernel.get(this, "uiColorPalette", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataColorPalette = builder.dataColorPalette;
                this.sheet = builder.sheet;
                this.typography = builder.typography;
                this.uiColorPalette = builder.uiColorPalette;
            }

            @Override
            public final java.lang.Object getDataColorPalette() {
                return this.dataColorPalette;
            }

            @Override
            public final java.lang.Object getSheet() {
                return this.sheet;
            }

            @Override
            public final java.lang.Object getTypography() {
                return this.typography;
            }

            @Override
            public final java.lang.Object getUiColorPalette() {
                return this.uiColorPalette;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDataColorPalette() != null) {
                    data.set("dataColorPalette", om.valueToTree(this.getDataColorPalette()));
                }
                if (this.getSheet() != null) {
                    data.set("sheet", om.valueToTree(this.getSheet()));
                }
                if (this.getTypography() != null) {
                    data.set("typography", om.valueToTree(this.getTypography()));
                }
                if (this.getUiColorPalette() != null) {
                    data.set("uiColorPalette", om.valueToTree(this.getUiColorPalette()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTheme.ThemeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ThemeConfigurationProperty.Jsii$Proxy that = (ThemeConfigurationProperty.Jsii$Proxy) o;

                if (this.dataColorPalette != null ? !this.dataColorPalette.equals(that.dataColorPalette) : that.dataColorPalette != null) return false;
                if (this.sheet != null ? !this.sheet.equals(that.sheet) : that.sheet != null) return false;
                if (this.typography != null ? !this.typography.equals(that.typography) : that.typography != null) return false;
                return this.uiColorPalette != null ? this.uiColorPalette.equals(that.uiColorPalette) : that.uiColorPalette == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataColorPalette != null ? this.dataColorPalette.hashCode() : 0;
                result = 31 * result + (this.sheet != null ? this.sheet.hashCode() : 0);
                result = 31 * result + (this.typography != null ? this.typography.hashCode() : 0);
                result = 31 * result + (this.uiColorPalette != null ? this.uiColorPalette.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Theme error.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ThemeErrorProperty themeErrorProperty = ThemeErrorProperty.builder()
     *         .message("message")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTheme.ThemeErrorProperty")
    @software.amazon.jsii.Jsii.Proxy(ThemeErrorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ThemeErrorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The error message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessage() {
            return null;
        }

        /**
         * The type of error.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ThemeErrorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ThemeErrorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ThemeErrorProperty> {
            java.lang.String message;
            java.lang.String type;

            /**
             * Sets the value of {@link ThemeErrorProperty#getMessage}
             * @param message The error message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder message(java.lang.String message) {
                this.message = message;
                return this;
            }

            /**
             * Sets the value of {@link ThemeErrorProperty#getType}
             * @param type The type of error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ThemeErrorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ThemeErrorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ThemeErrorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ThemeErrorProperty {
            private final java.lang.String message;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.message = software.amazon.jsii.Kernel.get(this, "message", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.message = builder.message;
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getMessage() {
                return this.message;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMessage() != null) {
                    data.set("message", om.valueToTree(this.getMessage()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTheme.ThemeErrorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ThemeErrorProperty.Jsii$Proxy that = (ThemeErrorProperty.Jsii$Proxy) o;

                if (this.message != null ? !this.message.equals(that.message) : that.message != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.message != null ? this.message.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A version of a theme.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ThemeVersionProperty themeVersionProperty = ThemeVersionProperty.builder()
     *         .arn("arn")
     *         .baseThemeId("baseThemeId")
     *         .configuration(ThemeConfigurationProperty.builder()
     *                 .dataColorPalette(DataColorPaletteProperty.builder()
     *                         .colors(List.of("colors"))
     *                         .emptyFillColor("emptyFillColor")
     *                         .minMaxGradient(List.of("minMaxGradient"))
     *                         .build())
     *                 .sheet(SheetStyleProperty.builder()
     *                         .tile(TileStyleProperty.builder()
     *                                 .border(BorderStyleProperty.builder()
     *                                         .show(false)
     *                                         .build())
     *                                 .build())
     *                         .tileLayout(TileLayoutStyleProperty.builder()
     *                                 .gutter(GutterStyleProperty.builder()
     *                                         .show(false)
     *                                         .build())
     *                                 .margin(MarginStyleProperty.builder()
     *                                         .show(false)
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .typography(TypographyProperty.builder()
     *                         .fontFamilies(List.of(FontProperty.builder()
     *                                 .fontFamily("fontFamily")
     *                                 .build()))
     *                         .build())
     *                 .uiColorPalette(UIColorPaletteProperty.builder()
     *                         .accent("accent")
     *                         .accentForeground("accentForeground")
     *                         .danger("danger")
     *                         .dangerForeground("dangerForeground")
     *                         .dimension("dimension")
     *                         .dimensionForeground("dimensionForeground")
     *                         .measure("measure")
     *                         .measureForeground("measureForeground")
     *                         .primaryBackground("primaryBackground")
     *                         .primaryForeground("primaryForeground")
     *                         .secondaryBackground("secondaryBackground")
     *                         .secondaryForeground("secondaryForeground")
     *                         .success("success")
     *                         .successForeground("successForeground")
     *                         .warning("warning")
     *                         .warningForeground("warningForeground")
     *                         .build())
     *                 .build())
     *         .createdTime("createdTime")
     *         .description("description")
     *         .errors(List.of(ThemeErrorProperty.builder()
     *                 .message("message")
     *                 .type("type")
     *                 .build()))
     *         .status("status")
     *         .versionNumber(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTheme.ThemeVersionProperty")
    @software.amazon.jsii.Jsii.Proxy(ThemeVersionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ThemeVersionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArn() {
            return null;
        }

        /**
         * The Amazon QuickSight-defined ID of the theme that a custom theme inherits from.
         * <p>
         * All themes initially inherit from a default Amazon QuickSight theme.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBaseThemeId() {
            return null;
        }

        /**
         * The theme configuration, which contains all the theme display properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
            return null;
        }

        /**
         * The date and time that this theme version was created.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCreatedTime() {
            return null;
        }

        /**
         * The description of the theme.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Errors associated with the theme.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getErrors() {
            return null;
        }

        /**
         * The status of the theme version.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * The version number of the theme.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVersionNumber() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ThemeVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ThemeVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ThemeVersionProperty> {
            java.lang.String arn;
            java.lang.String baseThemeId;
            java.lang.Object configuration;
            java.lang.String createdTime;
            java.lang.String description;
            java.lang.Object errors;
            java.lang.String status;
            java.lang.Number versionNumber;

            /**
             * Sets the value of {@link ThemeVersionProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link ThemeVersionProperty#getBaseThemeId}
             * @param baseThemeId The Amazon QuickSight-defined ID of the theme that a custom theme inherits from.
             *                    All themes initially inherit from a default Amazon QuickSight theme.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baseThemeId(java.lang.String baseThemeId) {
                this.baseThemeId = baseThemeId;
                return this;
            }

            /**
             * Sets the value of {@link ThemeVersionProperty#getConfiguration}
             * @param configuration The theme configuration, which contains all the theme display properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configuration(software.amazon.awscdk.services.quicksight.CfnTheme.ThemeConfigurationProperty configuration) {
                this.configuration = configuration;
                return this;
            }

            /**
             * Sets the value of {@link ThemeVersionProperty#getConfiguration}
             * @param configuration The theme configuration, which contains all the theme display properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configuration(software.amazon.awscdk.core.IResolvable configuration) {
                this.configuration = configuration;
                return this;
            }

            /**
             * Sets the value of {@link ThemeVersionProperty#getCreatedTime}
             * @param createdTime The date and time that this theme version was created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createdTime(java.lang.String createdTime) {
                this.createdTime = createdTime;
                return this;
            }

            /**
             * Sets the value of {@link ThemeVersionProperty#getDescription}
             * @param description The description of the theme.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link ThemeVersionProperty#getErrors}
             * @param errors Errors associated with the theme.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errors(software.amazon.awscdk.core.IResolvable errors) {
                this.errors = errors;
                return this;
            }

            /**
             * Sets the value of {@link ThemeVersionProperty#getErrors}
             * @param errors Errors associated with the theme.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errors(java.util.List<? extends java.lang.Object> errors) {
                this.errors = errors;
                return this;
            }

            /**
             * Sets the value of {@link ThemeVersionProperty#getStatus}
             * @param status The status of the theme version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link ThemeVersionProperty#getVersionNumber}
             * @param versionNumber The version number of the theme.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder versionNumber(java.lang.Number versionNumber) {
                this.versionNumber = versionNumber;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ThemeVersionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ThemeVersionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ThemeVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ThemeVersionProperty {
            private final java.lang.String arn;
            private final java.lang.String baseThemeId;
            private final java.lang.Object configuration;
            private final java.lang.String createdTime;
            private final java.lang.String description;
            private final java.lang.Object errors;
            private final java.lang.String status;
            private final java.lang.Number versionNumber;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.baseThemeId = software.amazon.jsii.Kernel.get(this, "baseThemeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.createdTime = software.amazon.jsii.Kernel.get(this, "createdTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.errors = software.amazon.jsii.Kernel.get(this, "errors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.versionNumber = software.amazon.jsii.Kernel.get(this, "versionNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = builder.arn;
                this.baseThemeId = builder.baseThemeId;
                this.configuration = builder.configuration;
                this.createdTime = builder.createdTime;
                this.description = builder.description;
                this.errors = builder.errors;
                this.status = builder.status;
                this.versionNumber = builder.versionNumber;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.String getBaseThemeId() {
                return this.baseThemeId;
            }

            @Override
            public final java.lang.Object getConfiguration() {
                return this.configuration;
            }

            @Override
            public final java.lang.String getCreatedTime() {
                return this.createdTime;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getErrors() {
                return this.errors;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.Number getVersionNumber() {
                return this.versionNumber;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArn() != null) {
                    data.set("arn", om.valueToTree(this.getArn()));
                }
                if (this.getBaseThemeId() != null) {
                    data.set("baseThemeId", om.valueToTree(this.getBaseThemeId()));
                }
                if (this.getConfiguration() != null) {
                    data.set("configuration", om.valueToTree(this.getConfiguration()));
                }
                if (this.getCreatedTime() != null) {
                    data.set("createdTime", om.valueToTree(this.getCreatedTime()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getErrors() != null) {
                    data.set("errors", om.valueToTree(this.getErrors()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }
                if (this.getVersionNumber() != null) {
                    data.set("versionNumber", om.valueToTree(this.getVersionNumber()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTheme.ThemeVersionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ThemeVersionProperty.Jsii$Proxy that = (ThemeVersionProperty.Jsii$Proxy) o;

                if (this.arn != null ? !this.arn.equals(that.arn) : that.arn != null) return false;
                if (this.baseThemeId != null ? !this.baseThemeId.equals(that.baseThemeId) : that.baseThemeId != null) return false;
                if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) return false;
                if (this.createdTime != null ? !this.createdTime.equals(that.createdTime) : that.createdTime != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.errors != null ? !this.errors.equals(that.errors) : that.errors != null) return false;
                if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
                return this.versionNumber != null ? this.versionNumber.equals(that.versionNumber) : that.versionNumber == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn != null ? this.arn.hashCode() : 0;
                result = 31 * result + (this.baseThemeId != null ? this.baseThemeId.hashCode() : 0);
                result = 31 * result + (this.configuration != null ? this.configuration.hashCode() : 0);
                result = 31 * result + (this.createdTime != null ? this.createdTime.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.errors != null ? this.errors.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                result = 31 * result + (this.versionNumber != null ? this.versionNumber.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The display options for the layout of tiles on a sheet.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TileLayoutStyleProperty tileLayoutStyleProperty = TileLayoutStyleProperty.builder()
     *         .gutter(GutterStyleProperty.builder()
     *                 .show(false)
     *                 .build())
     *         .margin(MarginStyleProperty.builder()
     *                 .show(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTheme.TileLayoutStyleProperty")
    @software.amazon.jsii.Jsii.Proxy(TileLayoutStyleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TileLayoutStyleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The gutter settings that apply between tiles.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGutter() {
            return null;
        }

        /**
         * The margin settings that apply around the outside edge of sheets.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMargin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TileLayoutStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TileLayoutStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TileLayoutStyleProperty> {
            java.lang.Object gutter;
            java.lang.Object margin;

            /**
             * Sets the value of {@link TileLayoutStyleProperty#getGutter}
             * @param gutter The gutter settings that apply between tiles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gutter(software.amazon.awscdk.services.quicksight.CfnTheme.GutterStyleProperty gutter) {
                this.gutter = gutter;
                return this;
            }

            /**
             * Sets the value of {@link TileLayoutStyleProperty#getGutter}
             * @param gutter The gutter settings that apply between tiles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gutter(software.amazon.awscdk.core.IResolvable gutter) {
                this.gutter = gutter;
                return this;
            }

            /**
             * Sets the value of {@link TileLayoutStyleProperty#getMargin}
             * @param margin The margin settings that apply around the outside edge of sheets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder margin(software.amazon.awscdk.services.quicksight.CfnTheme.MarginStyleProperty margin) {
                this.margin = margin;
                return this;
            }

            /**
             * Sets the value of {@link TileLayoutStyleProperty#getMargin}
             * @param margin The margin settings that apply around the outside edge of sheets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder margin(software.amazon.awscdk.core.IResolvable margin) {
                this.margin = margin;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TileLayoutStyleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TileLayoutStyleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TileLayoutStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TileLayoutStyleProperty {
            private final java.lang.Object gutter;
            private final java.lang.Object margin;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.gutter = software.amazon.jsii.Kernel.get(this, "gutter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.margin = software.amazon.jsii.Kernel.get(this, "margin", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.gutter = builder.gutter;
                this.margin = builder.margin;
            }

            @Override
            public final java.lang.Object getGutter() {
                return this.gutter;
            }

            @Override
            public final java.lang.Object getMargin() {
                return this.margin;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGutter() != null) {
                    data.set("gutter", om.valueToTree(this.getGutter()));
                }
                if (this.getMargin() != null) {
                    data.set("margin", om.valueToTree(this.getMargin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTheme.TileLayoutStyleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TileLayoutStyleProperty.Jsii$Proxy that = (TileLayoutStyleProperty.Jsii$Proxy) o;

                if (this.gutter != null ? !this.gutter.equals(that.gutter) : that.gutter != null) return false;
                return this.margin != null ? this.margin.equals(that.margin) : that.margin == null;
            }

            @Override
            public final int hashCode() {
                int result = this.gutter != null ? this.gutter.hashCode() : 0;
                result = 31 * result + (this.margin != null ? this.margin.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Display options related to tiles on a sheet.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TileStyleProperty tileStyleProperty = TileStyleProperty.builder()
     *         .border(BorderStyleProperty.builder()
     *                 .show(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTheme.TileStyleProperty")
    @software.amazon.jsii.Jsii.Proxy(TileStyleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TileStyleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The border around a tile.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBorder() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TileStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TileStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TileStyleProperty> {
            java.lang.Object border;

            /**
             * Sets the value of {@link TileStyleProperty#getBorder}
             * @param border The border around a tile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder border(software.amazon.awscdk.services.quicksight.CfnTheme.BorderStyleProperty border) {
                this.border = border;
                return this;
            }

            /**
             * Sets the value of {@link TileStyleProperty#getBorder}
             * @param border The border around a tile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder border(software.amazon.awscdk.core.IResolvable border) {
                this.border = border;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TileStyleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TileStyleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TileStyleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TileStyleProperty {
            private final java.lang.Object border;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.border = software.amazon.jsii.Kernel.get(this, "border", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.border = builder.border;
            }

            @Override
            public final java.lang.Object getBorder() {
                return this.border;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBorder() != null) {
                    data.set("border", om.valueToTree(this.getBorder()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTheme.TileStyleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TileStyleProperty.Jsii$Proxy that = (TileStyleProperty.Jsii$Proxy) o;

                return this.border != null ? this.border.equals(that.border) : that.border == null;
            }

            @Override
            public final int hashCode() {
                int result = this.border != null ? this.border.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TypographyProperty typographyProperty = TypographyProperty.builder()
     *         .fontFamilies(List.of(FontProperty.builder()
     *                 .fontFamily("fontFamily")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTheme.TypographyProperty")
    @software.amazon.jsii.Jsii.Proxy(TypographyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TypographyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnTheme.TypographyProperty.FontFamilies`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFontFamilies() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TypographyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TypographyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TypographyProperty> {
            java.lang.Object fontFamilies;

            /**
             * Sets the value of {@link TypographyProperty#getFontFamilies}
             * @param fontFamilies `CfnTheme.TypographyProperty.FontFamilies`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontFamilies(software.amazon.awscdk.core.IResolvable fontFamilies) {
                this.fontFamilies = fontFamilies;
                return this;
            }

            /**
             * Sets the value of {@link TypographyProperty#getFontFamilies}
             * @param fontFamilies `CfnTheme.TypographyProperty.FontFamilies`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontFamilies(java.util.List<? extends java.lang.Object> fontFamilies) {
                this.fontFamilies = fontFamilies;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TypographyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TypographyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TypographyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TypographyProperty {
            private final java.lang.Object fontFamilies;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fontFamilies = software.amazon.jsii.Kernel.get(this, "fontFamilies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fontFamilies = builder.fontFamilies;
            }

            @Override
            public final java.lang.Object getFontFamilies() {
                return this.fontFamilies;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFontFamilies() != null) {
                    data.set("fontFamilies", om.valueToTree(this.getFontFamilies()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTheme.TypographyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TypographyProperty.Jsii$Proxy that = (TypographyProperty.Jsii$Proxy) o;

                return this.fontFamilies != null ? this.fontFamilies.equals(that.fontFamilies) : that.fontFamilies == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fontFamilies != null ? this.fontFamilies.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The theme colors that apply to UI and to charts, excluding data colors.
     * <p>
     * The colors description is a hexadecimal color code that consists of six alphanumerical characters, prefixed with <code>#</code> , for example #37BFF5. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html">Using Themes in Amazon QuickSight</a> in the <em>Amazon QuickSight User Guide.</em>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * UIColorPaletteProperty uIColorPaletteProperty = UIColorPaletteProperty.builder()
     *         .accent("accent")
     *         .accentForeground("accentForeground")
     *         .danger("danger")
     *         .dangerForeground("dangerForeground")
     *         .dimension("dimension")
     *         .dimensionForeground("dimensionForeground")
     *         .measure("measure")
     *         .measureForeground("measureForeground")
     *         .primaryBackground("primaryBackground")
     *         .primaryForeground("primaryForeground")
     *         .secondaryBackground("secondaryBackground")
     *         .secondaryForeground("secondaryForeground")
     *         .success("success")
     *         .successForeground("successForeground")
     *         .warning("warning")
     *         .warningForeground("warningForeground")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_quicksight.CfnTheme.UIColorPaletteProperty")
    @software.amazon.jsii.Jsii.Proxy(UIColorPaletteProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UIColorPaletteProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This color is that applies to selected states and buttons.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccent() {
            return null;
        }

        /**
         * The foreground color that applies to any text or other elements that appear over the accent color.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccentForeground() {
            return null;
        }

        /**
         * The color that applies to error messages.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDanger() {
            return null;
        }

        /**
         * The foreground color that applies to any text or other elements that appear over the error color.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDangerForeground() {
            return null;
        }

        /**
         * The color that applies to the names of fields that are identified as dimensions.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDimension() {
            return null;
        }

        /**
         * The foreground color that applies to any text or other elements that appear over the dimension color.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDimensionForeground() {
            return null;
        }

        /**
         * The color that applies to the names of fields that are identified as measures.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMeasure() {
            return null;
        }

        /**
         * The foreground color that applies to any text or other elements that appear over the measure color.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMeasureForeground() {
            return null;
        }

        /**
         * The background color that applies to visuals and other high emphasis UI.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrimaryBackground() {
            return null;
        }

        /**
         * The color of text and other foreground elements that appear over the primary background regions, such as grid lines, borders, table banding, icons, and so on.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrimaryForeground() {
            return null;
        }

        /**
         * The background color that applies to the sheet background and sheet controls.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecondaryBackground() {
            return null;
        }

        /**
         * The foreground color that applies to any sheet title, sheet control text, or UI that appears over the secondary background.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecondaryForeground() {
            return null;
        }

        /**
         * The color that applies to success messages, for example the check mark for a successful download.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSuccess() {
            return null;
        }

        /**
         * The foreground color that applies to any text or other elements that appear over the success color.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSuccessForeground() {
            return null;
        }

        /**
         * This color that applies to warning and informational messages.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWarning() {
            return null;
        }

        /**
         * The foreground color that applies to any text or other elements that appear over the warning color.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWarningForeground() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UIColorPaletteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UIColorPaletteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UIColorPaletteProperty> {
            java.lang.String accent;
            java.lang.String accentForeground;
            java.lang.String danger;
            java.lang.String dangerForeground;
            java.lang.String dimension;
            java.lang.String dimensionForeground;
            java.lang.String measure;
            java.lang.String measureForeground;
            java.lang.String primaryBackground;
            java.lang.String primaryForeground;
            java.lang.String secondaryBackground;
            java.lang.String secondaryForeground;
            java.lang.String success;
            java.lang.String successForeground;
            java.lang.String warning;
            java.lang.String warningForeground;

            /**
             * Sets the value of {@link UIColorPaletteProperty#getAccent}
             * @param accent This color is that applies to selected states and buttons.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accent(java.lang.String accent) {
                this.accent = accent;
                return this;
            }

            /**
             * Sets the value of {@link UIColorPaletteProperty#getAccentForeground}
             * @param accentForeground The foreground color that applies to any text or other elements that appear over the accent color.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accentForeground(java.lang.String accentForeground) {
                this.accentForeground = accentForeground;
                return this;
            }

            /**
             * Sets the value of {@link UIColorPaletteProperty#getDanger}
             * @param danger The color that applies to error messages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder danger(java.lang.String danger) {
                this.danger = danger;
                return this;
            }

            /**
             * Sets the value of {@link UIColorPaletteProperty#getDangerForeground}
             * @param dangerForeground The foreground color that applies to any text or other elements that appear over the error color.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dangerForeground(java.lang.String dangerForeground) {
                this.dangerForeground = dangerForeground;
                return this;
            }

            /**
             * Sets the value of {@link UIColorPaletteProperty#getDimension}
             * @param dimension The color that applies to the names of fields that are identified as dimensions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimension(java.lang.String dimension) {
                this.dimension = dimension;
                return this;
            }

            /**
             * Sets the value of {@link UIColorPaletteProperty#getDimensionForeground}
             * @param dimensionForeground The foreground color that applies to any text or other elements that appear over the dimension color.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionForeground(java.lang.String dimensionForeground) {
                this.dimensionForeground = dimensionForeground;
                return this;
            }

            /**
             * Sets the value of {@link UIColorPaletteProperty#getMeasure}
             * @param measure The color that applies to the names of fields that are identified as measures.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder measure(java.lang.String measure) {
                this.measure = measure;
                return this;
            }

            /**
             * Sets the value of {@link UIColorPaletteProperty#getMeasureForeground}
             * @param measureForeground The foreground color that applies to any text or other elements that appear over the measure color.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder measureForeground(java.lang.String measureForeground) {
                this.measureForeground = measureForeground;
                return this;
            }

            /**
             * Sets the value of {@link UIColorPaletteProperty#getPrimaryBackground}
             * @param primaryBackground The background color that applies to visuals and other high emphasis UI.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryBackground(java.lang.String primaryBackground) {
                this.primaryBackground = primaryBackground;
                return this;
            }

            /**
             * Sets the value of {@link UIColorPaletteProperty#getPrimaryForeground}
             * @param primaryForeground The color of text and other foreground elements that appear over the primary background regions, such as grid lines, borders, table banding, icons, and so on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryForeground(java.lang.String primaryForeground) {
                this.primaryForeground = primaryForeground;
                return this;
            }

            /**
             * Sets the value of {@link UIColorPaletteProperty#getSecondaryBackground}
             * @param secondaryBackground The background color that applies to the sheet background and sheet controls.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondaryBackground(java.lang.String secondaryBackground) {
                this.secondaryBackground = secondaryBackground;
                return this;
            }

            /**
             * Sets the value of {@link UIColorPaletteProperty#getSecondaryForeground}
             * @param secondaryForeground The foreground color that applies to any sheet title, sheet control text, or UI that appears over the secondary background.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondaryForeground(java.lang.String secondaryForeground) {
                this.secondaryForeground = secondaryForeground;
                return this;
            }

            /**
             * Sets the value of {@link UIColorPaletteProperty#getSuccess}
             * @param success The color that applies to success messages, for example the check mark for a successful download.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder success(java.lang.String success) {
                this.success = success;
                return this;
            }

            /**
             * Sets the value of {@link UIColorPaletteProperty#getSuccessForeground}
             * @param successForeground The foreground color that applies to any text or other elements that appear over the success color.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successForeground(java.lang.String successForeground) {
                this.successForeground = successForeground;
                return this;
            }

            /**
             * Sets the value of {@link UIColorPaletteProperty#getWarning}
             * @param warning This color that applies to warning and informational messages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder warning(java.lang.String warning) {
                this.warning = warning;
                return this;
            }

            /**
             * Sets the value of {@link UIColorPaletteProperty#getWarningForeground}
             * @param warningForeground The foreground color that applies to any text or other elements that appear over the warning color.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder warningForeground(java.lang.String warningForeground) {
                this.warningForeground = warningForeground;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UIColorPaletteProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UIColorPaletteProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UIColorPaletteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UIColorPaletteProperty {
            private final java.lang.String accent;
            private final java.lang.String accentForeground;
            private final java.lang.String danger;
            private final java.lang.String dangerForeground;
            private final java.lang.String dimension;
            private final java.lang.String dimensionForeground;
            private final java.lang.String measure;
            private final java.lang.String measureForeground;
            private final java.lang.String primaryBackground;
            private final java.lang.String primaryForeground;
            private final java.lang.String secondaryBackground;
            private final java.lang.String secondaryForeground;
            private final java.lang.String success;
            private final java.lang.String successForeground;
            private final java.lang.String warning;
            private final java.lang.String warningForeground;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accent = software.amazon.jsii.Kernel.get(this, "accent", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accentForeground = software.amazon.jsii.Kernel.get(this, "accentForeground", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.danger = software.amazon.jsii.Kernel.get(this, "danger", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dangerForeground = software.amazon.jsii.Kernel.get(this, "dangerForeground", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dimension = software.amazon.jsii.Kernel.get(this, "dimension", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dimensionForeground = software.amazon.jsii.Kernel.get(this, "dimensionForeground", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.measure = software.amazon.jsii.Kernel.get(this, "measure", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.measureForeground = software.amazon.jsii.Kernel.get(this, "measureForeground", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.primaryBackground = software.amazon.jsii.Kernel.get(this, "primaryBackground", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.primaryForeground = software.amazon.jsii.Kernel.get(this, "primaryForeground", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secondaryBackground = software.amazon.jsii.Kernel.get(this, "secondaryBackground", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secondaryForeground = software.amazon.jsii.Kernel.get(this, "secondaryForeground", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.success = software.amazon.jsii.Kernel.get(this, "success", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.successForeground = software.amazon.jsii.Kernel.get(this, "successForeground", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.warning = software.amazon.jsii.Kernel.get(this, "warning", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.warningForeground = software.amazon.jsii.Kernel.get(this, "warningForeground", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accent = builder.accent;
                this.accentForeground = builder.accentForeground;
                this.danger = builder.danger;
                this.dangerForeground = builder.dangerForeground;
                this.dimension = builder.dimension;
                this.dimensionForeground = builder.dimensionForeground;
                this.measure = builder.measure;
                this.measureForeground = builder.measureForeground;
                this.primaryBackground = builder.primaryBackground;
                this.primaryForeground = builder.primaryForeground;
                this.secondaryBackground = builder.secondaryBackground;
                this.secondaryForeground = builder.secondaryForeground;
                this.success = builder.success;
                this.successForeground = builder.successForeground;
                this.warning = builder.warning;
                this.warningForeground = builder.warningForeground;
            }

            @Override
            public final java.lang.String getAccent() {
                return this.accent;
            }

            @Override
            public final java.lang.String getAccentForeground() {
                return this.accentForeground;
            }

            @Override
            public final java.lang.String getDanger() {
                return this.danger;
            }

            @Override
            public final java.lang.String getDangerForeground() {
                return this.dangerForeground;
            }

            @Override
            public final java.lang.String getDimension() {
                return this.dimension;
            }

            @Override
            public final java.lang.String getDimensionForeground() {
                return this.dimensionForeground;
            }

            @Override
            public final java.lang.String getMeasure() {
                return this.measure;
            }

            @Override
            public final java.lang.String getMeasureForeground() {
                return this.measureForeground;
            }

            @Override
            public final java.lang.String getPrimaryBackground() {
                return this.primaryBackground;
            }

            @Override
            public final java.lang.String getPrimaryForeground() {
                return this.primaryForeground;
            }

            @Override
            public final java.lang.String getSecondaryBackground() {
                return this.secondaryBackground;
            }

            @Override
            public final java.lang.String getSecondaryForeground() {
                return this.secondaryForeground;
            }

            @Override
            public final java.lang.String getSuccess() {
                return this.success;
            }

            @Override
            public final java.lang.String getSuccessForeground() {
                return this.successForeground;
            }

            @Override
            public final java.lang.String getWarning() {
                return this.warning;
            }

            @Override
            public final java.lang.String getWarningForeground() {
                return this.warningForeground;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccent() != null) {
                    data.set("accent", om.valueToTree(this.getAccent()));
                }
                if (this.getAccentForeground() != null) {
                    data.set("accentForeground", om.valueToTree(this.getAccentForeground()));
                }
                if (this.getDanger() != null) {
                    data.set("danger", om.valueToTree(this.getDanger()));
                }
                if (this.getDangerForeground() != null) {
                    data.set("dangerForeground", om.valueToTree(this.getDangerForeground()));
                }
                if (this.getDimension() != null) {
                    data.set("dimension", om.valueToTree(this.getDimension()));
                }
                if (this.getDimensionForeground() != null) {
                    data.set("dimensionForeground", om.valueToTree(this.getDimensionForeground()));
                }
                if (this.getMeasure() != null) {
                    data.set("measure", om.valueToTree(this.getMeasure()));
                }
                if (this.getMeasureForeground() != null) {
                    data.set("measureForeground", om.valueToTree(this.getMeasureForeground()));
                }
                if (this.getPrimaryBackground() != null) {
                    data.set("primaryBackground", om.valueToTree(this.getPrimaryBackground()));
                }
                if (this.getPrimaryForeground() != null) {
                    data.set("primaryForeground", om.valueToTree(this.getPrimaryForeground()));
                }
                if (this.getSecondaryBackground() != null) {
                    data.set("secondaryBackground", om.valueToTree(this.getSecondaryBackground()));
                }
                if (this.getSecondaryForeground() != null) {
                    data.set("secondaryForeground", om.valueToTree(this.getSecondaryForeground()));
                }
                if (this.getSuccess() != null) {
                    data.set("success", om.valueToTree(this.getSuccess()));
                }
                if (this.getSuccessForeground() != null) {
                    data.set("successForeground", om.valueToTree(this.getSuccessForeground()));
                }
                if (this.getWarning() != null) {
                    data.set("warning", om.valueToTree(this.getWarning()));
                }
                if (this.getWarningForeground() != null) {
                    data.set("warningForeground", om.valueToTree(this.getWarningForeground()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_quicksight.CfnTheme.UIColorPaletteProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UIColorPaletteProperty.Jsii$Proxy that = (UIColorPaletteProperty.Jsii$Proxy) o;

                if (this.accent != null ? !this.accent.equals(that.accent) : that.accent != null) return false;
                if (this.accentForeground != null ? !this.accentForeground.equals(that.accentForeground) : that.accentForeground != null) return false;
                if (this.danger != null ? !this.danger.equals(that.danger) : that.danger != null) return false;
                if (this.dangerForeground != null ? !this.dangerForeground.equals(that.dangerForeground) : that.dangerForeground != null) return false;
                if (this.dimension != null ? !this.dimension.equals(that.dimension) : that.dimension != null) return false;
                if (this.dimensionForeground != null ? !this.dimensionForeground.equals(that.dimensionForeground) : that.dimensionForeground != null) return false;
                if (this.measure != null ? !this.measure.equals(that.measure) : that.measure != null) return false;
                if (this.measureForeground != null ? !this.measureForeground.equals(that.measureForeground) : that.measureForeground != null) return false;
                if (this.primaryBackground != null ? !this.primaryBackground.equals(that.primaryBackground) : that.primaryBackground != null) return false;
                if (this.primaryForeground != null ? !this.primaryForeground.equals(that.primaryForeground) : that.primaryForeground != null) return false;
                if (this.secondaryBackground != null ? !this.secondaryBackground.equals(that.secondaryBackground) : that.secondaryBackground != null) return false;
                if (this.secondaryForeground != null ? !this.secondaryForeground.equals(that.secondaryForeground) : that.secondaryForeground != null) return false;
                if (this.success != null ? !this.success.equals(that.success) : that.success != null) return false;
                if (this.successForeground != null ? !this.successForeground.equals(that.successForeground) : that.successForeground != null) return false;
                if (this.warning != null ? !this.warning.equals(that.warning) : that.warning != null) return false;
                return this.warningForeground != null ? this.warningForeground.equals(that.warningForeground) : that.warningForeground == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accent != null ? this.accent.hashCode() : 0;
                result = 31 * result + (this.accentForeground != null ? this.accentForeground.hashCode() : 0);
                result = 31 * result + (this.danger != null ? this.danger.hashCode() : 0);
                result = 31 * result + (this.dangerForeground != null ? this.dangerForeground.hashCode() : 0);
                result = 31 * result + (this.dimension != null ? this.dimension.hashCode() : 0);
                result = 31 * result + (this.dimensionForeground != null ? this.dimensionForeground.hashCode() : 0);
                result = 31 * result + (this.measure != null ? this.measure.hashCode() : 0);
                result = 31 * result + (this.measureForeground != null ? this.measureForeground.hashCode() : 0);
                result = 31 * result + (this.primaryBackground != null ? this.primaryBackground.hashCode() : 0);
                result = 31 * result + (this.primaryForeground != null ? this.primaryForeground.hashCode() : 0);
                result = 31 * result + (this.secondaryBackground != null ? this.secondaryBackground.hashCode() : 0);
                result = 31 * result + (this.secondaryForeground != null ? this.secondaryForeground.hashCode() : 0);
                result = 31 * result + (this.success != null ? this.success.hashCode() : 0);
                result = 31 * result + (this.successForeground != null ? this.successForeground.hashCode() : 0);
                result = 31 * result + (this.warning != null ? this.warning.hashCode() : 0);
                result = 31 * result + (this.warningForeground != null ? this.warningForeground.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.quicksight.CfnTheme}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.quicksight.CfnTheme> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.quicksight.CfnThemeProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.quicksight.CfnThemeProps.Builder();
        }

        /**
         * The ID of the AWS account where you want to store the new theme.
         * <p>
         * @return {@code this}
         * @param awsAccountId The ID of the AWS account where you want to store the new theme. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(final java.lang.String awsAccountId) {
            this.props.awsAccountId(awsAccountId);
            return this;
        }

        /**
         * An ID for the theme that you want to create.
         * <p>
         * The theme ID is unique per AWS Region in each AWS account.
         * <p>
         * @return {@code this}
         * @param themeId An ID for the theme that you want to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder themeId(final java.lang.String themeId) {
            this.props.themeId(themeId);
            return this;
        }

        /**
         * The ID of the theme that a custom theme will inherit from.
         * <p>
         * All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use <code>ListThemes</code> or choose <em>Themes</em> from within an analysis.
         * <p>
         * @return {@code this}
         * @param baseThemeId The ID of the theme that a custom theme will inherit from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder baseThemeId(final java.lang.String baseThemeId) {
            this.props.baseThemeId(baseThemeId);
            return this;
        }

        /**
         * The theme configuration, which contains the theme display properties.
         * <p>
         * @return {@code this}
         * @param configuration The theme configuration, which contains the theme display properties. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.services.quicksight.CfnTheme.ThemeConfigurationProperty configuration) {
            this.props.configuration(configuration);
            return this;
        }
        /**
         * The theme configuration, which contains the theme display properties.
         * <p>
         * @return {@code this}
         * @param configuration The theme configuration, which contains the theme display properties. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.core.IResolvable configuration) {
            this.props.configuration(configuration);
            return this;
        }

        /**
         * A display name for the theme.
         * <p>
         * @return {@code this}
         * @param name A display name for the theme. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * A valid grouping of resource permissions to apply to the new theme.
         * <p>
         * @return {@code this}
         * @param permissions A valid grouping of resource permissions to apply to the new theme. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(final software.amazon.awscdk.core.IResolvable permissions) {
            this.props.permissions(permissions);
            return this;
        }
        /**
         * A valid grouping of resource permissions to apply to the new theme.
         * <p>
         * @return {@code this}
         * @param permissions A valid grouping of resource permissions to apply to the new theme. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(final java.util.List<? extends java.lang.Object> permissions) {
            this.props.permissions(permissions);
            return this;
        }

        /**
         * A map of the key-value pairs for the resource tag or tags that you want to add to the resource.
         * <p>
         * @return {@code this}
         * @param tags A map of the key-value pairs for the resource tag or tags that you want to add to the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * A description of the first version of the theme that you're creating.
         * <p>
         * Every time <code>UpdateTheme</code> is called, a new version is created. Each version of the theme has a description of the version in the <code>VersionDescription</code> field.
         * <p>
         * @return {@code this}
         * @param versionDescription A description of the first version of the theme that you're creating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionDescription(final java.lang.String versionDescription) {
            this.props.versionDescription(versionDescription);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.quicksight.CfnTheme}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.quicksight.CfnTheme build() {
            return new software.amazon.awscdk.services.quicksight.CfnTheme(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
