package software.amazon.awscdk.services.pipes;

/**
 * Properties for defining a `CfnPipe`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pipes.*;
 * CfnPipeProps cfnPipeProps = CfnPipeProps.builder()
 *         .roleArn("roleArn")
 *         .source("source")
 *         .target("target")
 *         // the properties below are optional
 *         .description("description")
 *         .desiredState("desiredState")
 *         .enrichment("enrichment")
 *         .enrichmentParameters(PipeEnrichmentParametersProperty.builder()
 *                 .httpParameters(PipeEnrichmentHttpParametersProperty.builder()
 *                         .headerParameters(Map.of(
 *                                 "headerParametersKey", "headerParameters"))
 *                         .pathParameterValues(List.of("pathParameterValues"))
 *                         .queryStringParameters(Map.of(
 *                                 "queryStringParametersKey", "queryStringParameters"))
 *                         .build())
 *                 .inputTemplate("inputTemplate")
 *                 .build())
 *         .name("name")
 *         .sourceParameters(PipeSourceParametersProperty.builder()
 *                 .activeMqBrokerParameters(PipeSourceActiveMQBrokerParametersProperty.builder()
 *                         .credentials(MQBrokerAccessCredentialsProperty.builder()
 *                                 .basicAuth("basicAuth")
 *                                 .build())
 *                         .queueName("queueName")
 *                         // the properties below are optional
 *                         .batchSize(123)
 *                         .maximumBatchingWindowInSeconds(123)
 *                         .build())
 *                 .dynamoDbStreamParameters(PipeSourceDynamoDBStreamParametersProperty.builder()
 *                         .startingPosition("startingPosition")
 *                         // the properties below are optional
 *                         .batchSize(123)
 *                         .deadLetterConfig(DeadLetterConfigProperty.builder()
 *                                 .arn("arn")
 *                                 .build())
 *                         .maximumBatchingWindowInSeconds(123)
 *                         .maximumRecordAgeInSeconds(123)
 *                         .maximumRetryAttempts(123)
 *                         .onPartialBatchItemFailure("onPartialBatchItemFailure")
 *                         .parallelizationFactor(123)
 *                         .build())
 *                 .filterCriteria(FilterCriteriaProperty.builder()
 *                         .filters(List.of(FilterProperty.builder()
 *                                 .pattern("pattern")
 *                                 .build()))
 *                         .build())
 *                 .kinesisStreamParameters(PipeSourceKinesisStreamParametersProperty.builder()
 *                         .startingPosition("startingPosition")
 *                         // the properties below are optional
 *                         .batchSize(123)
 *                         .deadLetterConfig(DeadLetterConfigProperty.builder()
 *                                 .arn("arn")
 *                                 .build())
 *                         .maximumBatchingWindowInSeconds(123)
 *                         .maximumRecordAgeInSeconds(123)
 *                         .maximumRetryAttempts(123)
 *                         .onPartialBatchItemFailure("onPartialBatchItemFailure")
 *                         .parallelizationFactor(123)
 *                         .startingPositionTimestamp("startingPositionTimestamp")
 *                         .build())
 *                 .managedStreamingKafkaParameters(PipeSourceManagedStreamingKafkaParametersProperty.builder()
 *                         .topicName("topicName")
 *                         // the properties below are optional
 *                         .batchSize(123)
 *                         .consumerGroupId("consumerGroupId")
 *                         .credentials(MSKAccessCredentialsProperty.builder()
 *                                 .clientCertificateTlsAuth("clientCertificateTlsAuth")
 *                                 .saslScram512Auth("saslScram512Auth")
 *                                 .build())
 *                         .maximumBatchingWindowInSeconds(123)
 *                         .startingPosition("startingPosition")
 *                         .build())
 *                 .rabbitMqBrokerParameters(PipeSourceRabbitMQBrokerParametersProperty.builder()
 *                         .credentials(MQBrokerAccessCredentialsProperty.builder()
 *                                 .basicAuth("basicAuth")
 *                                 .build())
 *                         .queueName("queueName")
 *                         // the properties below are optional
 *                         .batchSize(123)
 *                         .maximumBatchingWindowInSeconds(123)
 *                         .virtualHost("virtualHost")
 *                         .build())
 *                 .selfManagedKafkaParameters(PipeSourceSelfManagedKafkaParametersProperty.builder()
 *                         .topicName("topicName")
 *                         // the properties below are optional
 *                         .additionalBootstrapServers(List.of("additionalBootstrapServers"))
 *                         .batchSize(123)
 *                         .consumerGroupId("consumerGroupId")
 *                         .credentials(SelfManagedKafkaAccessConfigurationCredentialsProperty.builder()
 *                                 .basicAuth("basicAuth")
 *                                 .clientCertificateTlsAuth("clientCertificateTlsAuth")
 *                                 .saslScram256Auth("saslScram256Auth")
 *                                 .saslScram512Auth("saslScram512Auth")
 *                                 .build())
 *                         .maximumBatchingWindowInSeconds(123)
 *                         .serverRootCaCertificate("serverRootCaCertificate")
 *                         .startingPosition("startingPosition")
 *                         .vpc(SelfManagedKafkaAccessConfigurationVpcProperty.builder()
 *                                 .securityGroup(List.of("securityGroup"))
 *                                 .subnets(List.of("subnets"))
 *                                 .build())
 *                         .build())
 *                 .sqsQueueParameters(PipeSourceSqsQueueParametersProperty.builder()
 *                         .batchSize(123)
 *                         .maximumBatchingWindowInSeconds(123)
 *                         .build())
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .targetParameters(PipeTargetParametersProperty.builder()
 *                 .batchJobParameters(PipeTargetBatchJobParametersProperty.builder()
 *                         .jobDefinition("jobDefinition")
 *                         .jobName("jobName")
 *                         // the properties below are optional
 *                         .arrayProperties(BatchArrayPropertiesProperty.builder()
 *                                 .size(123)
 *                                 .build())
 *                         .containerOverrides(BatchContainerOverridesProperty.builder()
 *                                 .command(List.of("command"))
 *                                 .environment(List.of(BatchEnvironmentVariableProperty.builder()
 *                                         .name("name")
 *                                         .value("value")
 *                                         .build()))
 *                                 .instanceType("instanceType")
 *                                 .resourceRequirements(List.of(BatchResourceRequirementProperty.builder()
 *                                         .type("type")
 *                                         .value("value")
 *                                         .build()))
 *                                 .build())
 *                         .dependsOn(List.of(BatchJobDependencyProperty.builder()
 *                                 .jobId("jobId")
 *                                 .type("type")
 *                                 .build()))
 *                         .parameters(Map.of(
 *                                 "parametersKey", "parameters"))
 *                         .retryStrategy(BatchRetryStrategyProperty.builder()
 *                                 .attempts(123)
 *                                 .build())
 *                         .build())
 *                 .cloudWatchLogsParameters(PipeTargetCloudWatchLogsParametersProperty.builder()
 *                         .logStreamName("logStreamName")
 *                         .timestamp("timestamp")
 *                         .build())
 *                 .ecsTaskParameters(PipeTargetEcsTaskParametersProperty.builder()
 *                         .taskDefinitionArn("taskDefinitionArn")
 *                         // the properties below are optional
 *                         .capacityProviderStrategy(List.of(CapacityProviderStrategyItemProperty.builder()
 *                                 .capacityProvider("capacityProvider")
 *                                 // the properties below are optional
 *                                 .base(123)
 *                                 .weight(123)
 *                                 .build()))
 *                         .enableEcsManagedTags(false)
 *                         .enableExecuteCommand(false)
 *                         .group("group")
 *                         .launchType("launchType")
 *                         .networkConfiguration(NetworkConfigurationProperty.builder()
 *                                 .awsvpcConfiguration(AwsVpcConfigurationProperty.builder()
 *                                         .subnets(List.of("subnets"))
 *                                         // the properties below are optional
 *                                         .assignPublicIp("assignPublicIp")
 *                                         .securityGroups(List.of("securityGroups"))
 *                                         .build())
 *                                 .build())
 *                         .overrides(EcsTaskOverrideProperty.builder()
 *                                 .containerOverrides(List.of(EcsContainerOverrideProperty.builder()
 *                                         .command(List.of("command"))
 *                                         .cpu(123)
 *                                         .environment(List.of(EcsEnvironmentVariableProperty.builder()
 *                                                 .name("name")
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .environmentFiles(List.of(EcsEnvironmentFileProperty.builder()
 *                                                 .type("type")
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .memory(123)
 *                                         .memoryReservation(123)
 *                                         .name("name")
 *                                         .resourceRequirements(List.of(EcsResourceRequirementProperty.builder()
 *                                                 .type("type")
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .build()))
 *                                 .cpu("cpu")
 *                                 .ephemeralStorage(EcsEphemeralStorageProperty.builder()
 *                                         .sizeInGiB(123)
 *                                         .build())
 *                                 .executionRoleArn("executionRoleArn")
 *                                 .inferenceAcceleratorOverrides(List.of(EcsInferenceAcceleratorOverrideProperty.builder()
 *                                         .deviceName("deviceName")
 *                                         .deviceType("deviceType")
 *                                         .build()))
 *                                 .memory("memory")
 *                                 .taskRoleArn("taskRoleArn")
 *                                 .build())
 *                         .placementConstraints(List.of(PlacementConstraintProperty.builder()
 *                                 .expression("expression")
 *                                 .type("type")
 *                                 .build()))
 *                         .placementStrategy(List.of(PlacementStrategyProperty.builder()
 *                                 .field("field")
 *                                 .type("type")
 *                                 .build()))
 *                         .platformVersion("platformVersion")
 *                         .propagateTags("propagateTags")
 *                         .referenceId("referenceId")
 *                         .tags(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .taskCount(123)
 *                         .build())
 *                 .eventBridgeEventBusParameters(PipeTargetEventBridgeEventBusParametersProperty.builder()
 *                         .detailType("detailType")
 *                         .endpointId("endpointId")
 *                         .resources(List.of("resources"))
 *                         .source("source")
 *                         .time("time")
 *                         .build())
 *                 .httpParameters(PipeTargetHttpParametersProperty.builder()
 *                         .headerParameters(Map.of(
 *                                 "headerParametersKey", "headerParameters"))
 *                         .pathParameterValues(List.of("pathParameterValues"))
 *                         .queryStringParameters(Map.of(
 *                                 "queryStringParametersKey", "queryStringParameters"))
 *                         .build())
 *                 .inputTemplate("inputTemplate")
 *                 .kinesisStreamParameters(PipeTargetKinesisStreamParametersProperty.builder()
 *                         .partitionKey("partitionKey")
 *                         .build())
 *                 .lambdaFunctionParameters(PipeTargetLambdaFunctionParametersProperty.builder()
 *                         .invocationType("invocationType")
 *                         .build())
 *                 .redshiftDataParameters(PipeTargetRedshiftDataParametersProperty.builder()
 *                         .database("database")
 *                         .sqls(List.of("sqls"))
 *                         // the properties below are optional
 *                         .dbUser("dbUser")
 *                         .secretManagerArn("secretManagerArn")
 *                         .statementName("statementName")
 *                         .withEvent(false)
 *                         .build())
 *                 .sageMakerPipelineParameters(PipeTargetSageMakerPipelineParametersProperty.builder()
 *                         .pipelineParameterList(List.of(SageMakerPipelineParameterProperty.builder()
 *                                 .name("name")
 *                                 .value("value")
 *                                 .build()))
 *                         .build())
 *                 .sqsQueueParameters(PipeTargetSqsQueueParametersProperty.builder()
 *                         .messageDeduplicationId("messageDeduplicationId")
 *                         .messageGroupId("messageGroupId")
 *                         .build())
 *                 .stepFunctionStateMachineParameters(PipeTargetStateMachineParametersProperty.builder()
 *                         .invocationType("invocationType")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:07.749Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipeProps")
@software.amazon.jsii.Jsii.Proxy(CfnPipeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPipeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the role that allows the pipe to send data to the target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * The ARN of the source resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSource();

    /**
     * The ARN of the target resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTarget();

    /**
     * A description of the pipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The state the pipe should be in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDesiredState() {
        return null;
    }

    /**
     * The ARN of the enrichment resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnrichment() {
        return null;
    }

    /**
     * The parameters required to set up enrichment on your pipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnrichmentParameters() {
        return null;
    }

    /**
     * The name of the pipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The parameters required to set up a source for your pipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSourceParameters() {
        return null;
    }

    /**
     * The list of key-value pairs to associate with the pipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * The parameters required to set up a target for your pipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTargetParameters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPipeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPipeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPipeProps> {
        java.lang.String roleArn;
        java.lang.String source;
        java.lang.String target;
        java.lang.String description;
        java.lang.String desiredState;
        java.lang.String enrichment;
        java.lang.Object enrichmentParameters;
        java.lang.String name;
        java.lang.Object sourceParameters;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.Object targetParameters;

        /**
         * Sets the value of {@link CfnPipeProps#getRoleArn}
         * @param roleArn The ARN of the role that allows the pipe to send data to the target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipeProps#getSource}
         * @param source The ARN of the source resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(java.lang.String source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipeProps#getTarget}
         * @param target The ARN of the target resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(java.lang.String target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipeProps#getDescription}
         * @param description A description of the pipe.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipeProps#getDesiredState}
         * @param desiredState The state the pipe should be in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredState(java.lang.String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipeProps#getEnrichment}
         * @param enrichment The ARN of the enrichment resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enrichment(java.lang.String enrichment) {
            this.enrichment = enrichment;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipeProps#getEnrichmentParameters}
         * @param enrichmentParameters The parameters required to set up enrichment on your pipe.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enrichmentParameters(software.amazon.awscdk.services.pipes.CfnPipe.PipeEnrichmentParametersProperty enrichmentParameters) {
            this.enrichmentParameters = enrichmentParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipeProps#getEnrichmentParameters}
         * @param enrichmentParameters The parameters required to set up enrichment on your pipe.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enrichmentParameters(software.amazon.awscdk.core.IResolvable enrichmentParameters) {
            this.enrichmentParameters = enrichmentParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipeProps#getName}
         * @param name The name of the pipe.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipeProps#getSourceParameters}
         * @param sourceParameters The parameters required to set up a source for your pipe.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceParameters(software.amazon.awscdk.services.pipes.CfnPipe.PipeSourceParametersProperty sourceParameters) {
            this.sourceParameters = sourceParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipeProps#getSourceParameters}
         * @param sourceParameters The parameters required to set up a source for your pipe.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceParameters(software.amazon.awscdk.core.IResolvable sourceParameters) {
            this.sourceParameters = sourceParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipeProps#getTags}
         * @param tags The list of key-value pairs to associate with the pipe.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipeProps#getTargetParameters}
         * @param targetParameters The parameters required to set up a target for your pipe.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetParameters(software.amazon.awscdk.services.pipes.CfnPipe.PipeTargetParametersProperty targetParameters) {
            this.targetParameters = targetParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipeProps#getTargetParameters}
         * @param targetParameters The parameters required to set up a target for your pipe.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetParameters(software.amazon.awscdk.core.IResolvable targetParameters) {
            this.targetParameters = targetParameters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPipeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPipeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPipeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPipeProps {
        private final java.lang.String roleArn;
        private final java.lang.String source;
        private final java.lang.String target;
        private final java.lang.String description;
        private final java.lang.String desiredState;
        private final java.lang.String enrichment;
        private final java.lang.Object enrichmentParameters;
        private final java.lang.String name;
        private final java.lang.Object sourceParameters;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.Object targetParameters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.desiredState = software.amazon.jsii.Kernel.get(this, "desiredState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enrichment = software.amazon.jsii.Kernel.get(this, "enrichment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enrichmentParameters = software.amazon.jsii.Kernel.get(this, "enrichmentParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceParameters = software.amazon.jsii.Kernel.get(this, "sourceParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.targetParameters = software.amazon.jsii.Kernel.get(this, "targetParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
            this.description = builder.description;
            this.desiredState = builder.desiredState;
            this.enrichment = builder.enrichment;
            this.enrichmentParameters = builder.enrichmentParameters;
            this.name = builder.name;
            this.sourceParameters = builder.sourceParameters;
            this.tags = builder.tags;
            this.targetParameters = builder.targetParameters;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getSource() {
            return this.source;
        }

        @Override
        public final java.lang.String getTarget() {
            return this.target;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDesiredState() {
            return this.desiredState;
        }

        @Override
        public final java.lang.String getEnrichment() {
            return this.enrichment;
        }

        @Override
        public final java.lang.Object getEnrichmentParameters() {
            return this.enrichmentParameters;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getSourceParameters() {
            return this.sourceParameters;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTargetParameters() {
            return this.targetParameters;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            data.set("source", om.valueToTree(this.getSource()));
            data.set("target", om.valueToTree(this.getTarget()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDesiredState() != null) {
                data.set("desiredState", om.valueToTree(this.getDesiredState()));
            }
            if (this.getEnrichment() != null) {
                data.set("enrichment", om.valueToTree(this.getEnrichment()));
            }
            if (this.getEnrichmentParameters() != null) {
                data.set("enrichmentParameters", om.valueToTree(this.getEnrichmentParameters()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getSourceParameters() != null) {
                data.set("sourceParameters", om.valueToTree(this.getSourceParameters()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTargetParameters() != null) {
                data.set("targetParameters", om.valueToTree(this.getTargetParameters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPipeProps.Jsii$Proxy that = (CfnPipeProps.Jsii$Proxy) o;

            if (!roleArn.equals(that.roleArn)) return false;
            if (!source.equals(that.source)) return false;
            if (!target.equals(that.target)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.desiredState != null ? !this.desiredState.equals(that.desiredState) : that.desiredState != null) return false;
            if (this.enrichment != null ? !this.enrichment.equals(that.enrichment) : that.enrichment != null) return false;
            if (this.enrichmentParameters != null ? !this.enrichmentParameters.equals(that.enrichmentParameters) : that.enrichmentParameters != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.sourceParameters != null ? !this.sourceParameters.equals(that.sourceParameters) : that.sourceParameters != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.targetParameters != null ? this.targetParameters.equals(that.targetParameters) : that.targetParameters == null;
        }

        @Override
        public final int hashCode() {
            int result = this.roleArn.hashCode();
            result = 31 * result + (this.source.hashCode());
            result = 31 * result + (this.target.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.desiredState != null ? this.desiredState.hashCode() : 0);
            result = 31 * result + (this.enrichment != null ? this.enrichment.hashCode() : 0);
            result = 31 * result + (this.enrichmentParameters != null ? this.enrichmentParameters.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.sourceParameters != null ? this.sourceParameters.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.targetParameters != null ? this.targetParameters.hashCode() : 0);
            return result;
        }
    }
}
