package software.amazon.awscdk.services.pinpoint;

/**
 * A CloudFormation `AWS::Pinpoint::SMSChannel`.
 * <p>
 * A <em>channel</em> is a type of platform that you can deliver messages to. To send an SMS text message, you send the message through the SMS channel. Before you can use Amazon Pinpoint to send text messages, you have to enable the SMS channel for an Amazon Pinpoint application.
 * <p>
 * The SMSChannel resource represents the status, sender ID, and other settings for the SMS channel for an application.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pinpoint.*;
 * CfnSMSChannel cfnSMSChannel = CfnSMSChannel.Builder.create(this, "MyCfnSMSChannel")
 *         .applicationId("applicationId")
 *         // the properties below are optional
 *         .enabled(false)
 *         .senderId("senderId")
 *         .shortCode("shortCode")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:07.567Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pinpoint.CfnSMSChannel")
public class CfnSMSChannel extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnSMSChannel(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSMSChannel(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.pinpoint.CfnSMSChannel.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Pinpoint::SMSChannel`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSMSChannel(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.pinpoint.CfnSMSChannelProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The unique identifier for the Amazon Pinpoint application that the SMS channel applies to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApplicationId() {
        return software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier for the Amazon Pinpoint application that the SMS channel applies to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "applicationId", java.util.Objects.requireNonNull(value, "applicationId is required"));
    }

    /**
     * Specifies whether to enable the SMS channel for the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
        return software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether to enable the SMS channel for the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enabled", value);
    }

    /**
     * Specifies whether to enable the SMS channel for the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enabled", value);
    }

    /**
     * The identity that you want to display on recipients' devices when they receive messages from the SMS channel.
     * <p>
     * <blockquote>
     * <p>
     * SenderIDs are only supported in certain countries and regions. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-countries.html">Supported Countries and Regions</a> in the <em>Amazon Pinpoint User Guide</em> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSenderId() {
        return software.amazon.jsii.Kernel.get(this, "senderId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identity that you want to display on recipients' devices when they receive messages from the SMS channel.
     * <p>
     * <blockquote>
     * <p>
     * SenderIDs are only supported in certain countries and regions. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-countries.html">Supported Countries and Regions</a> in the <em>Amazon Pinpoint User Guide</em> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSenderId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "senderId", value);
    }

    /**
     * The registered short code that you want to use when you send messages through the SMS channel.
     * <p>
     * <blockquote>
     * <p>
     * For information about obtaining a dedicated short code for sending SMS messages, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-short-code.html">Requesting Dedicated Short Codes for SMS Messaging with Amazon Pinpoint</a> in the <em>Amazon Pinpoint User Guide</em> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getShortCode() {
        return software.amazon.jsii.Kernel.get(this, "shortCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The registered short code that you want to use when you send messages through the SMS channel.
     * <p>
     * <blockquote>
     * <p>
     * For information about obtaining a dedicated short code for sending SMS messages, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-short-code.html">Requesting Dedicated Short Codes for SMS Messaging with Amazon Pinpoint</a> in the <em>Amazon Pinpoint User Guide</em> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setShortCode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "shortCode", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.pinpoint.CfnSMSChannel}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.pinpoint.CfnSMSChannel> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.pinpoint.CfnSMSChannelProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.pinpoint.CfnSMSChannelProps.Builder();
        }

        /**
         * The unique identifier for the Amazon Pinpoint application that the SMS channel applies to.
         * <p>
         * @return {@code this}
         * @param applicationId The unique identifier for the Amazon Pinpoint application that the SMS channel applies to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(final java.lang.String applicationId) {
            this.props.applicationId(applicationId);
            return this;
        }

        /**
         * Specifies whether to enable the SMS channel for the application.
         * <p>
         * @return {@code this}
         * @param enabled Specifies whether to enable the SMS channel for the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }
        /**
         * Specifies whether to enable the SMS channel for the application.
         * <p>
         * @return {@code this}
         * @param enabled Specifies whether to enable the SMS channel for the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final software.amazon.awscdk.core.IResolvable enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * The identity that you want to display on recipients' devices when they receive messages from the SMS channel.
         * <p>
         * <blockquote>
         * <p>
         * SenderIDs are only supported in certain countries and regions. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-countries.html">Supported Countries and Regions</a> in the <em>Amazon Pinpoint User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param senderId The identity that you want to display on recipients' devices when they receive messages from the SMS channel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder senderId(final java.lang.String senderId) {
            this.props.senderId(senderId);
            return this;
        }

        /**
         * The registered short code that you want to use when you send messages through the SMS channel.
         * <p>
         * <blockquote>
         * <p>
         * For information about obtaining a dedicated short code for sending SMS messages, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-short-code.html">Requesting Dedicated Short Codes for SMS Messaging with Amazon Pinpoint</a> in the <em>Amazon Pinpoint User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param shortCode The registered short code that you want to use when you send messages through the SMS channel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shortCode(final java.lang.String shortCode) {
            this.props.shortCode(shortCode);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.pinpoint.CfnSMSChannel}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.pinpoint.CfnSMSChannel build() {
            return new software.amazon.awscdk.services.pinpoint.CfnSMSChannel(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
