package software.amazon.awscdk.services.neptune;

/**
 * (experimental) Construction properties for a DatabaseInstanceNew.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * DatabaseInstance replica1 = DatabaseInstance.Builder.create(this, "Instance")
 *         .cluster(cluster)
 *         .instanceType(InstanceType.R5_LARGE)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:06.888Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_neptune.DatabaseInstanceProps")
@software.amazon.jsii.Jsii.Proxy(DatabaseInstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DatabaseInstanceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The Neptune database cluster the instance should launch into.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.neptune.IDatabaseCluster getCluster();

    /**
     * (experimental) What type of instance to start for the replicas.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.neptune.InstanceType getInstanceType();

    /**
     * (experimental) The name of the Availability Zone where the DB instance will be located.
     * <p>
     * Default: - no preference
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return null;
    }

    /**
     * (experimental) A name for the DB instance.
     * <p>
     * If you specify a name, AWS CloudFormation
     * converts it to lowercase.
     * <p>
     * Default: - a CloudFormation generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbInstanceName() {
        return null;
    }

    /**
     * (experimental) The DB parameter group to associate with the instance.
     * <p>
     * Default: no parameter group
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.neptune.IParameterGroup getParameterGroup() {
        return null;
    }

    /**
     * (experimental) The CloudFormation policy to apply when the instance is removed from the stack or replaced during an update.
     * <p>
     * Default: RemovalPolicy.Retain
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DatabaseInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DatabaseInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<DatabaseInstanceProps> {
        software.amazon.awscdk.services.neptune.IDatabaseCluster cluster;
        software.amazon.awscdk.services.neptune.InstanceType instanceType;
        java.lang.String availabilityZone;
        java.lang.String dbInstanceName;
        software.amazon.awscdk.services.neptune.IParameterGroup parameterGroup;
        software.amazon.awscdk.core.RemovalPolicy removalPolicy;

        /**
         * Sets the value of {@link DatabaseInstanceProps#getCluster}
         * @param cluster The Neptune database cluster the instance should launch into. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cluster(software.amazon.awscdk.services.neptune.IDatabaseCluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceProps#getInstanceType}
         * @param instanceType What type of instance to start for the replicas. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(software.amazon.awscdk.services.neptune.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceProps#getAvailabilityZone}
         * @param availabilityZone The name of the Availability Zone where the DB instance will be located.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceProps#getDbInstanceName}
         * @param dbInstanceName A name for the DB instance.
         *                       If you specify a name, AWS CloudFormation
         *                       converts it to lowercase.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dbInstanceName(java.lang.String dbInstanceName) {
            this.dbInstanceName = dbInstanceName;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceProps#getParameterGroup}
         * @param parameterGroup The DB parameter group to associate with the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameterGroup(software.amazon.awscdk.services.neptune.IParameterGroup parameterGroup) {
            this.parameterGroup = parameterGroup;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceProps#getRemovalPolicy}
         * @param removalPolicy The CloudFormation policy to apply when the instance is removed from the stack or replaced during an update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DatabaseInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public DatabaseInstanceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DatabaseInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseInstanceProps {
        private final software.amazon.awscdk.services.neptune.IDatabaseCluster cluster;
        private final software.amazon.awscdk.services.neptune.InstanceType instanceType;
        private final java.lang.String availabilityZone;
        private final java.lang.String dbInstanceName;
        private final software.amazon.awscdk.services.neptune.IParameterGroup parameterGroup;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.neptune.IDatabaseCluster.class));
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.neptune.InstanceType.class));
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbInstanceName = software.amazon.jsii.Kernel.get(this, "dbInstanceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameterGroup = software.amazon.jsii.Kernel.get(this, "parameterGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.neptune.IParameterGroup.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.RemovalPolicy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cluster = java.util.Objects.requireNonNull(builder.cluster, "cluster is required");
            this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
            this.availabilityZone = builder.availabilityZone;
            this.dbInstanceName = builder.dbInstanceName;
            this.parameterGroup = builder.parameterGroup;
            this.removalPolicy = builder.removalPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.neptune.IDatabaseCluster getCluster() {
            return this.cluster;
        }

        @Override
        public final software.amazon.awscdk.services.neptune.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.lang.String getDbInstanceName() {
            return this.dbInstanceName;
        }

        @Override
        public final software.amazon.awscdk.services.neptune.IParameterGroup getParameterGroup() {
            return this.parameterGroup;
        }

        @Override
        public final software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cluster", om.valueToTree(this.getCluster()));
            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getDbInstanceName() != null) {
                data.set("dbInstanceName", om.valueToTree(this.getDbInstanceName()));
            }
            if (this.getParameterGroup() != null) {
                data.set("parameterGroup", om.valueToTree(this.getParameterGroup()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_neptune.DatabaseInstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DatabaseInstanceProps.Jsii$Proxy that = (DatabaseInstanceProps.Jsii$Proxy) o;

            if (!cluster.equals(that.cluster)) return false;
            if (!instanceType.equals(that.instanceType)) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.dbInstanceName != null ? !this.dbInstanceName.equals(that.dbInstanceName) : that.dbInstanceName != null) return false;
            if (this.parameterGroup != null ? !this.parameterGroup.equals(that.parameterGroup) : that.parameterGroup != null) return false;
            return this.removalPolicy != null ? this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cluster.hashCode();
            result = 31 * result + (this.instanceType.hashCode());
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.dbInstanceName != null ? this.dbInstanceName.hashCode() : 0);
            result = 31 * result + (this.parameterGroup != null ? this.parameterGroup.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            return result;
        }
    }
}
