/**
 * <h1>Amazon Managed Streaming for Apache Kafka Construct Library</h1>
 * <p>
 * <a href="https://aws.amazon.com/msk/">Amazon MSK</a> is a fully managed service that makes it easy for you to build and run applications that use Apache Kafka to process streaming data.
 * <p>
 * The following example creates an MSK Cluster.
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * 
 * Cluster cluster = Cluster.Builder.create(this, "Cluster")
 *         .clusterName("myCluster")
 *         .kafkaVersion(KafkaVersion.V2_8_1)
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Allowing Connections</h2>
 * <p>
 * To control who can access the Cluster, use the <code>.connections</code> attribute. For a list of ports used by MSK, refer to the <a href="https://docs.aws.amazon.com/msk/latest/developerguide/client-access.html#port-info">MSK documentation</a>.
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * 
 * Cluster cluster = Cluster.Builder.create(this, "Cluster")
 *         .clusterName("myCluster")
 *         .kafkaVersion(KafkaVersion.V2_8_1)
 *         .vpc(vpc)
 *         .build();
 * 
 * cluster.connections.allowFrom(Peer.ipv4("1.2.3.4/8"), Port.tcp(2181));
 * cluster.connections.allowFrom(Peer.ipv4("1.2.3.4/8"), Port.tcp(9094));
 * </pre></blockquote>
 * <p>
 * <h2>Cluster Endpoints</h2>
 * <p>
 * You can use the following attributes to get a list of the Kafka broker or ZooKeeper node endpoints
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * 
 * CfnOutput.Builder.create(this, "BootstrapBrokers").value(cluster.getBootstrapBrokers()).build();
 * CfnOutput.Builder.create(this, "BootstrapBrokersTls").value(cluster.getBootstrapBrokersTls()).build();
 * CfnOutput.Builder.create(this, "BootstrapBrokersSaslScram").value(cluster.getBootstrapBrokersSaslScram()).build();
 * CfnOutput.Builder.create(this, "ZookeeperConnection").value(cluster.getZookeeperConnectionString()).build();
 * CfnOutput.Builder.create(this, "ZookeeperConnectionTls").value(cluster.getZookeeperConnectionStringTls()).build();
 * </pre></blockquote>
 * <p>
 * <h2>Importing an existing Cluster</h2>
 * <p>
 * To import an existing MSK cluster into your CDK app use the <code>.fromClusterArn()</code> method.
 * <p>
 * <blockquote><pre>
 * ICluster cluster = Cluster.fromClusterArn(this, "Cluster", "arn:aws:kafka:us-west-2:1234567890:cluster/a-cluster/11111111-1111-1111-1111-111111111111-1");
 * </pre></blockquote>
 * <p>
 * <h2>Client Authentication</h2>
 * <p>
 * <a href="https://docs.aws.amazon.com/msk/latest/developerguide/kafka_apis_iam.html">MSK supports</a> the following authentication mechanisms.
 * <p>
 * <blockquote>
 * <p>
 * Only one authentication method can be enabled.
 * <p>
 * </blockquote>
 * <p>
 * <h3>TLS</h3>
 * <p>
 * To enable client authentication with TLS set the <code>certificateAuthorityArns</code> property to reference your ACM Private CA. <a href="https://docs.aws.amazon.com/msk/latest/developerguide/msk-authentication.html">More info on Private CAs.</a>
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * 
 * Vpc vpc;
 * 
 * Cluster cluster = Cluster.Builder.create(this, "Cluster")
 *         .clusterName("myCluster")
 *         .kafkaVersion(KafkaVersion.V2_8_1)
 *         .vpc(vpc)
 *         .encryptionInTransit(EncryptionInTransitConfig.builder()
 *                 .clientBroker(ClientBrokerEncryption.TLS)
 *                 .build())
 *         .clientAuthentication(ClientAuthentication.tls(TlsAuthProps.builder()
 *                 .certificateAuthorities(List.of(CertificateAuthority.fromCertificateAuthorityArn(this, "CertificateAuthority", "arn:aws:acm-pca:us-west-2:1234567890:certificate-authority/11111111-1111-1111-1111-111111111111")))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>SASL/SCRAM</h3>
 * <p>
 * Enable client authentication with <a href="https://docs.aws.amazon.com/msk/latest/developerguide/msk-password.html">SASL/SCRAM</a>:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * 
 * Cluster cluster = Cluster.Builder.create(this, "cluster")
 *         .clusterName("myCluster")
 *         .kafkaVersion(KafkaVersion.V2_8_1)
 *         .vpc(vpc)
 *         .encryptionInTransit(EncryptionInTransitConfig.builder()
 *                 .clientBroker(ClientBrokerEncryption.TLS)
 *                 .build())
 *         .clientAuthentication(ClientAuthentication.sasl(SaslAuthProps.builder()
 *                 .scram(true)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>SASL/IAM</h3>
 * <p>
 * Enable client authentication with <a href="https://docs.aws.amazon.com/msk/latest/developerguide/iam-access-control.html">IAM</a>:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * 
 * Cluster cluster = Cluster.Builder.create(this, "cluster")
 *         .clusterName("myCluster")
 *         .kafkaVersion(KafkaVersion.V2_8_1)
 *         .vpc(vpc)
 *         .encryptionInTransit(EncryptionInTransitConfig.builder()
 *                 .clientBroker(ClientBrokerEncryption.TLS)
 *                 .build())
 *         .clientAuthentication(ClientAuthentication.sasl(SaslAuthProps.builder()
 *                 .iam(true)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
package software.amazon.awscdk.services.msk;
