package software.amazon.awscdk.services.msk;

/**
 * (experimental) SASL authentication properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Cluster cluster = Cluster.Builder.create(this, "cluster")
 *         .clusterName("myCluster")
 *         .kafkaVersion(KafkaVersion.V2_8_1)
 *         .vpc(vpc)
 *         .encryptionInTransit(EncryptionInTransitConfig.builder()
 *                 .clientBroker(ClientBrokerEncryption.TLS)
 *                 .build())
 *         .clientAuthentication(ClientAuthentication.sasl(SaslAuthProps.builder()
 *                 .scram(true)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:06.811Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_msk.SaslAuthProps")
@software.amazon.jsii.Jsii.Proxy(SaslAuthProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface SaslAuthProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Enable IAM access control.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIam() {
        return null;
    }

    /**
     * (experimental) KMS Key to encrypt SASL/SCRAM secrets.
     * <p>
     * You must use a customer master key (CMK) when creating users in secrets manager.
     * You cannot use a Secret with Amazon MSK that uses the default Secrets Manager encryption key.
     * <p>
     * Default: - CMK will be created with alias msk/{clusterName}/sasl/scram
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getKey() {
        return null;
    }

    /**
     * (experimental) Enable SASL/SCRAM authentication.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getScram() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SaslAuthProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SaslAuthProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<SaslAuthProps> {
        java.lang.Boolean iam;
        software.amazon.awscdk.services.kms.IKey key;
        java.lang.Boolean scram;

        /**
         * Sets the value of {@link SaslAuthProps#getIam}
         * @param iam Enable IAM access control.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder iam(java.lang.Boolean iam) {
            this.iam = iam;
            return this;
        }

        /**
         * Sets the value of {@link SaslAuthProps#getKey}
         * @param key KMS Key to encrypt SASL/SCRAM secrets.
         *            You must use a customer master key (CMK) when creating users in secrets manager.
         *            You cannot use a Secret with Amazon MSK that uses the default Secrets Manager encryption key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder key(software.amazon.awscdk.services.kms.IKey key) {
            this.key = key;
            return this;
        }

        /**
         * Sets the value of {@link SaslAuthProps#getScram}
         * @param scram Enable SASL/SCRAM authentication.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder scram(java.lang.Boolean scram) {
            this.scram = scram;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SaslAuthProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public SaslAuthProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SaslAuthProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SaslAuthProps {
        private final java.lang.Boolean iam;
        private final software.amazon.awscdk.services.kms.IKey key;
        private final java.lang.Boolean scram;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.iam = software.amazon.jsii.Kernel.get(this, "iam", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.scram = software.amazon.jsii.Kernel.get(this, "scram", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.iam = builder.iam;
            this.key = builder.key;
            this.scram = builder.scram;
        }

        @Override
        public final java.lang.Boolean getIam() {
            return this.iam;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getKey() {
            return this.key;
        }

        @Override
        public final java.lang.Boolean getScram() {
            return this.scram;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getIam() != null) {
                data.set("iam", om.valueToTree(this.getIam()));
            }
            if (this.getKey() != null) {
                data.set("key", om.valueToTree(this.getKey()));
            }
            if (this.getScram() != null) {
                data.set("scram", om.valueToTree(this.getScram()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_msk.SaslAuthProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SaslAuthProps.Jsii$Proxy that = (SaslAuthProps.Jsii$Proxy) o;

            if (this.iam != null ? !this.iam.equals(that.iam) : that.iam != null) return false;
            if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
            return this.scram != null ? this.scram.equals(that.scram) : that.scram == null;
        }

        @Override
        public final int hashCode() {
            int result = this.iam != null ? this.iam.hashCode() : 0;
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            result = 31 * result + (this.scram != null ? this.scram.hashCode() : 0);
            return result;
        }
    }
}
