package software.amazon.awscdk.services.msk;

/**
 * (experimental) Indicates the encryption setting for data in transit between clients and brokers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Cluster cluster = Cluster.Builder.create(this, "cluster")
 *         .clusterName("myCluster")
 *         .kafkaVersion(KafkaVersion.V2_8_1)
 *         .vpc(vpc)
 *         .encryptionInTransit(EncryptionInTransitConfig.builder()
 *                 .clientBroker(ClientBrokerEncryption.TLS)
 *                 .build())
 *         .clientAuthentication(ClientAuthentication.sasl(SaslAuthProps.builder()
 *                 .scram(true)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:06.799Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_msk.ClientBrokerEncryption")
public enum ClientBrokerEncryption {
    /**
     * (experimental) TLS means that client-broker communication is enabled with TLS only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TLS,
    /**
     * (experimental) TLS_PLAINTEXT means that client-broker communication is enabled for both TLS-encrypted, as well as plaintext data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TLS_PLAINTEXT,
    /**
     * (experimental) PLAINTEXT means that client-broker communication is enabled in plaintext only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    PLAINTEXT,
}
