package software.amazon.awscdk.services.msk;

/**
 * (experimental) Configuration details related to broker logs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * import software.amazon.awscdk.services.msk.*;
 * import software.amazon.awscdk.services.s3.*;
 * Bucket bucket;
 * LogGroup logGroup;
 * BrokerLogging brokerLogging = BrokerLogging.builder()
 *         .cloudwatchLogGroup(logGroup)
 *         .firehoseDeliveryStreamName("firehoseDeliveryStreamName")
 *         .s3(S3LoggingConfiguration.builder()
 *                 .bucket(bucket)
 *                 // the properties below are optional
 *                 .prefix("prefix")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:06.721Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_msk.BrokerLogging")
@software.amazon.jsii.Jsii.Proxy(BrokerLogging.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface BrokerLogging extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The CloudWatch Logs group that is the destination for broker logs.
     * <p>
     * Default: - disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getCloudwatchLogGroup() {
        return null;
    }

    /**
     * (experimental) The Kinesis Data Firehose delivery stream that is the destination for broker logs.
     * <p>
     * Default: - disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getFirehoseDeliveryStreamName() {
        return null;
    }

    /**
     * (experimental) Details of the Amazon S3 destination for broker logs.
     * <p>
     * Default: - disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.msk.S3LoggingConfiguration getS3() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BrokerLogging}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BrokerLogging}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<BrokerLogging> {
        software.amazon.awscdk.services.logs.ILogGroup cloudwatchLogGroup;
        java.lang.String firehoseDeliveryStreamName;
        software.amazon.awscdk.services.msk.S3LoggingConfiguration s3;

        /**
         * Sets the value of {@link BrokerLogging#getCloudwatchLogGroup}
         * @param cloudwatchLogGroup The CloudWatch Logs group that is the destination for broker logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloudwatchLogGroup(software.amazon.awscdk.services.logs.ILogGroup cloudwatchLogGroup) {
            this.cloudwatchLogGroup = cloudwatchLogGroup;
            return this;
        }

        /**
         * Sets the value of {@link BrokerLogging#getFirehoseDeliveryStreamName}
         * @param firehoseDeliveryStreamName The Kinesis Data Firehose delivery stream that is the destination for broker logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder firehoseDeliveryStreamName(java.lang.String firehoseDeliveryStreamName) {
            this.firehoseDeliveryStreamName = firehoseDeliveryStreamName;
            return this;
        }

        /**
         * Sets the value of {@link BrokerLogging#getS3}
         * @param s3 Details of the Amazon S3 destination for broker logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3(software.amazon.awscdk.services.msk.S3LoggingConfiguration s3) {
            this.s3 = s3;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BrokerLogging}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public BrokerLogging build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BrokerLogging}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BrokerLogging {
        private final software.amazon.awscdk.services.logs.ILogGroup cloudwatchLogGroup;
        private final java.lang.String firehoseDeliveryStreamName;
        private final software.amazon.awscdk.services.msk.S3LoggingConfiguration s3;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cloudwatchLogGroup = software.amazon.jsii.Kernel.get(this, "cloudwatchLogGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
            this.firehoseDeliveryStreamName = software.amazon.jsii.Kernel.get(this, "firehoseDeliveryStreamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.msk.S3LoggingConfiguration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cloudwatchLogGroup = builder.cloudwatchLogGroup;
            this.firehoseDeliveryStreamName = builder.firehoseDeliveryStreamName;
            this.s3 = builder.s3;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogGroup getCloudwatchLogGroup() {
            return this.cloudwatchLogGroup;
        }

        @Override
        public final java.lang.String getFirehoseDeliveryStreamName() {
            return this.firehoseDeliveryStreamName;
        }

        @Override
        public final software.amazon.awscdk.services.msk.S3LoggingConfiguration getS3() {
            return this.s3;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCloudwatchLogGroup() != null) {
                data.set("cloudwatchLogGroup", om.valueToTree(this.getCloudwatchLogGroup()));
            }
            if (this.getFirehoseDeliveryStreamName() != null) {
                data.set("firehoseDeliveryStreamName", om.valueToTree(this.getFirehoseDeliveryStreamName()));
            }
            if (this.getS3() != null) {
                data.set("s3", om.valueToTree(this.getS3()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_msk.BrokerLogging"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BrokerLogging.Jsii$Proxy that = (BrokerLogging.Jsii$Proxy) o;

            if (this.cloudwatchLogGroup != null ? !this.cloudwatchLogGroup.equals(that.cloudwatchLogGroup) : that.cloudwatchLogGroup != null) return false;
            if (this.firehoseDeliveryStreamName != null ? !this.firehoseDeliveryStreamName.equals(that.firehoseDeliveryStreamName) : that.firehoseDeliveryStreamName != null) return false;
            return this.s3 != null ? this.s3.equals(that.s3) : that.s3 == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cloudwatchLogGroup != null ? this.cloudwatchLogGroup.hashCode() : 0;
            result = 31 * result + (this.firehoseDeliveryStreamName != null ? this.firehoseDeliveryStreamName.hashCode() : 0);
            result = 31 * result + (this.s3 != null ? this.s3.hashCode() : 0);
            return result;
        }
    }
}
