package software.amazon.awscdk.services.logs;

/**
 * (experimental) Define a Log Stream in a Log Group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.services.logs.*;
 * LogGroup logGroup;
 * LogStream logStream = LogStream.Builder.create(this, "MyLogStream")
 *         .logGroup(logGroup)
 *         // the properties below are optional
 *         .logStreamName("logStreamName")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:05.919Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_logs.LogStream")
public class LogStream extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.logs.ILogStream {

    protected LogStream(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LogStream(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public LogStream(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.LogStreamProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Import an existing LogGroup.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param logStreamName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogStream fromLogStreamName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String logStreamName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.logs.LogStream.class, "fromLogStreamName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogStream.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(logStreamName, "logStreamName is required") });
    }

    /**
     * (experimental) The name of this log stream.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getLogStreamName() {
        return software.amazon.jsii.Kernel.get(this, "logStreamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.logs.LogStream}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.LogStream> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.logs.LogStreamProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.logs.LogStreamProps.Builder();
        }

        /**
         * (experimental) The log group to create a log stream for.
         * <p>
         * @return {@code this}
         * @param logGroup The log group to create a log stream for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logGroup(final software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.props.logGroup(logGroup);
            return this;
        }

        /**
         * (experimental) The name of the log stream to create.
         * <p>
         * The name must be unique within the log group.
         * <p>
         * Default: Automatically generated
         * <p>
         * @return {@code this}
         * @param logStreamName The name of the log stream to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logStreamName(final java.lang.String logStreamName) {
            this.props.logStreamName(logStreamName);
            return this;
        }

        /**
         * (experimental) Determine what happens when the log stream resource is removed from the app.
         * <p>
         * Normally you want to retain the log stream so you can diagnose issues from
         * logs even after a deployment that no longer includes the log stream.
         * <p>
         * The date-based retention policy of your log group will age out the logs
         * after a certain time.
         * <p>
         * Default: RemovalPolicy.Retain
         * <p>
         * @return {@code this}
         * @param removalPolicy Determine what happens when the log stream resource is removed from the app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(final software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.logs.LogStream}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.logs.LogStream build() {
            return new software.amazon.awscdk.services.logs.LogStream(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
