package software.amazon.awscdk.services.lambda;

/**
 * (experimental) X-Ray Tracing Modes (https://docs.aws.amazon.com/lambda/latest/dg/API_TracingConfig.html).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function fn = Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.NODEJS_16_X)
 *         .handler("index.handler")
 *         .code(Code.fromInline("exports.handler = function(event, ctx, cb) { return cb(null, \"hi\"); }"))
 *         .tracing(Tracing.ACTIVE)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:05.250Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_lambda.Tracing")
public enum Tracing {
    /**
     * (experimental) Lambda will respect any tracing header it receives from an upstream service.
     * <p>
     * If no tracing header is received, Lambda will call X-Ray for a tracing decision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ACTIVE,
    /**
     * (experimental) Lambda will only trace the request from an upstream service if it contains a tracing header with "sampled=1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    PASS_THROUGH,
    /**
     * (experimental) Lambda will not trace any request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DISABLED,
}
