package software.amazon.awscdk.services.kinesisfirehose.destinations;

/**
 * (experimental) An S3 bucket destination for data from a Kinesis Data Firehose delivery stream.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * // Provide a Lambda function that will transform records before delivery, with custom
 * // buffering and retry configuration
 * Function lambdaFunction = Function.Builder.create(this, "Processor")
 *         .runtime(Runtime.NODEJS_14_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "process-records")))
 *         .build();
 * LambdaFunctionProcessor lambdaProcessor = LambdaFunctionProcessor.Builder.create(lambdaFunction)
 *         .bufferInterval(Duration.minutes(5))
 *         .bufferSize(Size.mebibytes(5))
 *         .retries(5)
 *         .build();
 * S3Bucket s3Destination = S3Bucket.Builder.create(bucket)
 *         .processor(lambdaProcessor)
 *         .build();
 * DeliveryStream.Builder.create(this, "Delivery Stream")
 *         .destinations(List.of(s3Destination))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:04.766Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_kinesisfirehose_destinations.S3Bucket")
public class S3Bucket extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisfirehose.IDestination {

    protected S3Bucket(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3Bucket(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param bucket This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public S3Bucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.destinations.S3BucketProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), props });
    }

    /**
     * @param bucket This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public S3Bucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required") });
    }

    /**
     * (experimental) Binds this destination to the Kinesis Data Firehose delivery stream.
     * <p>
     * Implementers should use this method to bind resources to the stack and initialize values using the provided stream.
     * <p>
     * @param scope This parameter is required.
     * @param _options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.DestinationConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.DestinationBindOptions _options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.DestinationConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(_options, "_options is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.kinesisfirehose.destinations.S3Bucket}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kinesisfirehose.destinations.S3Bucket> {
        /**
         * @return a new instance of {@link Builder}.
         * @param bucket This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.services.s3.IBucket bucket) {
            return new Builder(bucket);
        }

        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private software.amazon.awscdk.services.kinesisfirehose.destinations.S3BucketProps.Builder props;

        private Builder(final software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
        }

        /**
         * (experimental) The length of time that Firehose buffers incoming data before delivering it to the S3 bucket.
         * <p>
         * Minimum: Duration.seconds(60)
         * Maximum: Duration.seconds(900)
         * <p>
         * Default: Duration.seconds(300)
         * <p>
         * @return {@code this}
         * @param bufferingInterval The length of time that Firehose buffers incoming data before delivering it to the S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bufferingInterval(final software.amazon.awscdk.core.Duration bufferingInterval) {
            this.props().bufferingInterval(bufferingInterval);
            return this;
        }

        /**
         * (experimental) The size of the buffer that Kinesis Data Firehose uses for incoming data before delivering it to the S3 bucket.
         * <p>
         * Minimum: Size.mebibytes(1)
         * Maximum: Size.mebibytes(128)
         * <p>
         * Default: Size.mebibytes(5)
         * <p>
         * @return {@code this}
         * @param bufferingSize The size of the buffer that Kinesis Data Firehose uses for incoming data before delivering it to the S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bufferingSize(final software.amazon.awscdk.core.Size bufferingSize) {
            this.props().bufferingSize(bufferingSize);
            return this;
        }

        /**
         * (experimental) The type of compression that Kinesis Data Firehose uses to compress the data that it delivers to the Amazon S3 bucket.
         * <p>
         * The compression formats SNAPPY or ZIP cannot be specified for Amazon Redshift
         * destinations because they are not supported by the Amazon Redshift COPY operation
         * that reads from the S3 bucket.
         * <p>
         * Default: - UNCOMPRESSED
         * <p>
         * @return {@code this}
         * @param compression The type of compression that Kinesis Data Firehose uses to compress the data that it delivers to the Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder compression(final software.amazon.awscdk.services.kinesisfirehose.destinations.Compression compression) {
            this.props().compression(compression);
            return this;
        }

        /**
         * (experimental) A prefix that Kinesis Data Firehose evaluates and adds to records before writing them to S3.
         * <p>
         * This prefix appears immediately following the bucket name.
         * <p>
         * Default: "YYYY/MM/DD/HH"
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html</a>
         * @param dataOutputPrefix A prefix that Kinesis Data Firehose evaluates and adds to records before writing them to S3. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dataOutputPrefix(final java.lang.String dataOutputPrefix) {
            this.props().dataOutputPrefix(dataOutputPrefix);
            return this;
        }

        /**
         * (experimental) The AWS KMS key used to encrypt the data that it delivers to your Amazon S3 bucket.
         * <p>
         * Default: - Data is not encrypted.
         * <p>
         * @return {@code this}
         * @param encryptionKey The AWS KMS key used to encrypt the data that it delivers to your Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionKey(final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        /**
         * (experimental) A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3.
         * <p>
         * This prefix appears immediately following the bucket name.
         * <p>
         * Default: "YYYY/MM/DD/HH"
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html</a>
         * @param errorOutputPrefix A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder errorOutputPrefix(final java.lang.String errorOutputPrefix) {
            this.props().errorOutputPrefix(errorOutputPrefix);
            return this;
        }

        /**
         * (experimental) If true, log errors when data transformation or data delivery fails.
         * <p>
         * If <code>logGroup</code> is provided, this will be implicitly set to <code>true</code>.
         * <p>
         * Default: true - errors are logged.
         * <p>
         * @return {@code this}
         * @param logging If true, log errors when data transformation or data delivery fails. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logging(final java.lang.Boolean logging) {
            this.props().logging(logging);
            return this;
        }

        /**
         * (experimental) The CloudWatch log group where log streams will be created to hold error logs.
         * <p>
         * Default: - if `logging` is set to `true`, a log group will be created for you.
         * <p>
         * @return {@code this}
         * @param logGroup The CloudWatch log group where log streams will be created to hold error logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logGroup(final software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.props().logGroup(logGroup);
            return this;
        }

        /**
         * (experimental) The data transformation that should be performed on the data before writing to the destination.
         * <p>
         * Default: - no data transformation will occur.
         * <p>
         * @return {@code this}
         * @param processor The data transformation that should be performed on the data before writing to the destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder processor(final software.amazon.awscdk.services.kinesisfirehose.IDataProcessor processor) {
            this.props().processor(processor);
            return this;
        }

        /**
         * (experimental) The IAM role associated with this destination.
         * <p>
         * Assumed by Kinesis Data Firehose to invoke processors and write to destinations
         * <p>
         * Default: - a role will be created with default permissions.
         * <p>
         * @return {@code this}
         * @param role The IAM role associated with this destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props().role(role);
            return this;
        }

        /**
         * (experimental) The configuration for backing up source records to S3.
         * <p>
         * Default: - source records will not be backed up to S3.
         * <p>
         * @return {@code this}
         * @param s3Backup The configuration for backing up source records to S3. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3Backup(final software.amazon.awscdk.services.kinesisfirehose.destinations.DestinationS3BackupProps s3Backup) {
            this.props().s3Backup(s3Backup);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.kinesisfirehose.destinations.S3Bucket}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.kinesisfirehose.destinations.S3Bucket build() {
            return new software.amazon.awscdk.services.kinesisfirehose.destinations.S3Bucket(
                this.bucket,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.kinesisfirehose.destinations.S3BucketProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.kinesisfirehose.destinations.S3BucketProps.Builder();
            }
            return this.props;
        }
    }
}
