package software.amazon.awscdk.services.kinesis.analytics.flink;

/**
 * (experimental) Props for creating an Application construct.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import path.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.services.cloudwatch.*;
 * App app = new App();
 * Stack stack = new Stack(app, "FlinkAppTest");
 * Application flinkApp = Application.Builder.create(stack, "App")
 *         .code(ApplicationCode.fromAsset(join(__dirname, "code-asset")))
 *         .runtime(Runtime.FLINK_1_11)
 *         .build();
 * Alarm.Builder.create(stack, "Alarm")
 *         .metric(flinkApp.metricFullRestarts())
 *         .evaluationPeriods(1)
 *         .threshold(3)
 *         .build();
 * app.synth();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:04.457Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_kinesisanalytics_flink.ApplicationProps")
@software.amazon.jsii.Jsii.Proxy(ApplicationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ApplicationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The Flink code asset to run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCode getCode();

    /**
     * (experimental) The Flink version to use for this application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.analytics.flink.Runtime getRuntime();

    /**
     * (experimental) A name for your Application that is unique to an AWS account.
     * <p>
     * Default: - CloudFormation-generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getApplicationName() {
        return null;
    }

    /**
     * (experimental) Whether the Kinesis Data Analytics service can increase the parallelism of the application in response to resource usage.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAutoScalingEnabled() {
        return null;
    }

    /**
     * (experimental) Whether checkpointing is enabled while your application runs.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCheckpointingEnabled() {
        return null;
    }

    /**
     * (experimental) The interval between checkpoints.
     * <p>
     * Default: 1 minute
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getCheckpointInterval() {
        return null;
    }

    /**
     * (experimental) The log group to send log entries to.
     * <p>
     * Default: CDK's default LogGroup
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
        return null;
    }

    /**
     * (experimental) The level of log verbosity from the Flink application.
     * <p>
     * Default: FlinkLogLevel.INFO
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesis.analytics.flink.LogLevel getLogLevel() {
        return null;
    }

    /**
     * (experimental) Describes the granularity of the CloudWatch metrics for an application.
     * <p>
     * Use caution with Parallelism level metrics. Parallelism granularity logs
     * metrics for each parallel thread and can quickly become expensive when
     * parallelism is high (e.g. &gt; 64).
     * <p>
     * Default: MetricsLevel.APPLICATION
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesis.analytics.flink.MetricsLevel getMetricsLevel() {
        return null;
    }

    /**
     * (experimental) The minimum amount of time in to wait after a checkpoint finishes to start a new checkpoint.
     * <p>
     * Default: 5 seconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getMinPauseBetweenCheckpoints() {
        return null;
    }

    /**
     * (experimental) The initial parallelism for the application.
     * <p>
     * Kinesis Data Analytics can
     * stop the app, increase the parallelism, and start the app again if
     * autoScalingEnabled is true (the default value).
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getParallelism() {
        return null;
    }

    /**
     * (experimental) The Flink parallelism allowed per Kinesis Processing Unit (KPU).
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getParallelismPerKpu() {
        return null;
    }

    /**
     * (experimental) Configuration PropertyGroups.
     * <p>
     * You can use these property groups to pass
     * arbitrary runtime configuration values to your Flink app.
     * <p>
     * Default: No property group configuration provided to the Flink app
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesis.analytics.flink.PropertyGroups getPropertyGroups() {
        return null;
    }

    /**
     * (experimental) Provide a RemovalPolicy to override the default.
     * <p>
     * Default: RemovalPolicy.DESTROY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * (experimental) A role to use to grant permissions to your application.
     * <p>
     * Prefer omitting
     * this property and using the default role.
     * <p>
     * Default: - a new Role will be created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * (experimental) Determines if Flink snapshots are enabled.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSnapshotsEnabled() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ApplicationProps> {
        software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCode code;
        software.amazon.awscdk.services.kinesis.analytics.flink.Runtime runtime;
        java.lang.String applicationName;
        java.lang.Boolean autoScalingEnabled;
        java.lang.Boolean checkpointingEnabled;
        software.amazon.awscdk.core.Duration checkpointInterval;
        software.amazon.awscdk.services.logs.ILogGroup logGroup;
        software.amazon.awscdk.services.kinesis.analytics.flink.LogLevel logLevel;
        software.amazon.awscdk.services.kinesis.analytics.flink.MetricsLevel metricsLevel;
        software.amazon.awscdk.core.Duration minPauseBetweenCheckpoints;
        java.lang.Number parallelism;
        java.lang.Number parallelismPerKpu;
        software.amazon.awscdk.services.kinesis.analytics.flink.PropertyGroups propertyGroups;
        software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        software.amazon.awscdk.services.iam.IRole role;
        java.lang.Boolean snapshotsEnabled;

        /**
         * Sets the value of {@link ApplicationProps#getCode}
         * @param code The Flink code asset to run. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder code(software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCode code) {
            this.code = code;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationProps#getRuntime}
         * @param runtime The Flink version to use for this application. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runtime(software.amazon.awscdk.services.kinesis.analytics.flink.Runtime runtime) {
            this.runtime = runtime;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationProps#getApplicationName}
         * @param applicationName A name for your Application that is unique to an AWS account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder applicationName(java.lang.String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationProps#getAutoScalingEnabled}
         * @param autoScalingEnabled Whether the Kinesis Data Analytics service can increase the parallelism of the application in response to resource usage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoScalingEnabled(java.lang.Boolean autoScalingEnabled) {
            this.autoScalingEnabled = autoScalingEnabled;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationProps#getCheckpointingEnabled}
         * @param checkpointingEnabled Whether checkpointing is enabled while your application runs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder checkpointingEnabled(java.lang.Boolean checkpointingEnabled) {
            this.checkpointingEnabled = checkpointingEnabled;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationProps#getCheckpointInterval}
         * @param checkpointInterval The interval between checkpoints.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder checkpointInterval(software.amazon.awscdk.core.Duration checkpointInterval) {
            this.checkpointInterval = checkpointInterval;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationProps#getLogGroup}
         * @param logGroup The log group to send log entries to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logGroup(software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationProps#getLogLevel}
         * @param logLevel The level of log verbosity from the Flink application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logLevel(software.amazon.awscdk.services.kinesis.analytics.flink.LogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationProps#getMetricsLevel}
         * @param metricsLevel Describes the granularity of the CloudWatch metrics for an application.
         *                     Use caution with Parallelism level metrics. Parallelism granularity logs
         *                     metrics for each parallel thread and can quickly become expensive when
         *                     parallelism is high (e.g. &gt; 64).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metricsLevel(software.amazon.awscdk.services.kinesis.analytics.flink.MetricsLevel metricsLevel) {
            this.metricsLevel = metricsLevel;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationProps#getMinPauseBetweenCheckpoints}
         * @param minPauseBetweenCheckpoints The minimum amount of time in to wait after a checkpoint finishes to start a new checkpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minPauseBetweenCheckpoints(software.amazon.awscdk.core.Duration minPauseBetweenCheckpoints) {
            this.minPauseBetweenCheckpoints = minPauseBetweenCheckpoints;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationProps#getParallelism}
         * @param parallelism The initial parallelism for the application.
         *                    Kinesis Data Analytics can
         *                    stop the app, increase the parallelism, and start the app again if
         *                    autoScalingEnabled is true (the default value).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parallelism(java.lang.Number parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationProps#getParallelismPerKpu}
         * @param parallelismPerKpu The Flink parallelism allowed per Kinesis Processing Unit (KPU).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parallelismPerKpu(java.lang.Number parallelismPerKpu) {
            this.parallelismPerKpu = parallelismPerKpu;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationProps#getPropertyGroups}
         * @param propertyGroups Configuration PropertyGroups.
         *                       You can use these property groups to pass
         *                       arbitrary runtime configuration values to your Flink app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder propertyGroups(software.amazon.awscdk.services.kinesis.analytics.flink.PropertyGroups propertyGroups) {
            this.propertyGroups = propertyGroups;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationProps#getRemovalPolicy}
         * @param removalPolicy Provide a RemovalPolicy to override the default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationProps#getRole}
         * @param role A role to use to grant permissions to your application.
         *             Prefer omitting
         *             this property and using the default role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationProps#getSnapshotsEnabled}
         * @param snapshotsEnabled Determines if Flink snapshots are enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder snapshotsEnabled(java.lang.Boolean snapshotsEnabled) {
            this.snapshotsEnabled = snapshotsEnabled;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ApplicationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationProps {
        private final software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCode code;
        private final software.amazon.awscdk.services.kinesis.analytics.flink.Runtime runtime;
        private final java.lang.String applicationName;
        private final java.lang.Boolean autoScalingEnabled;
        private final java.lang.Boolean checkpointingEnabled;
        private final software.amazon.awscdk.core.Duration checkpointInterval;
        private final software.amazon.awscdk.services.logs.ILogGroup logGroup;
        private final software.amazon.awscdk.services.kinesis.analytics.flink.LogLevel logLevel;
        private final software.amazon.awscdk.services.kinesis.analytics.flink.MetricsLevel metricsLevel;
        private final software.amazon.awscdk.core.Duration minPauseBetweenCheckpoints;
        private final java.lang.Number parallelism;
        private final java.lang.Number parallelismPerKpu;
        private final software.amazon.awscdk.services.kinesis.analytics.flink.PropertyGroups propertyGroups;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.Boolean snapshotsEnabled;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.code = software.amazon.jsii.Kernel.get(this, "code", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCode.class));
            this.runtime = software.amazon.jsii.Kernel.get(this, "runtime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.analytics.flink.Runtime.class));
            this.applicationName = software.amazon.jsii.Kernel.get(this, "applicationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoScalingEnabled = software.amazon.jsii.Kernel.get(this, "autoScalingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.checkpointingEnabled = software.amazon.jsii.Kernel.get(this, "checkpointingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.checkpointInterval = software.amazon.jsii.Kernel.get(this, "checkpointInterval", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.logGroup = software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
            this.logLevel = software.amazon.jsii.Kernel.get(this, "logLevel", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.analytics.flink.LogLevel.class));
            this.metricsLevel = software.amazon.jsii.Kernel.get(this, "metricsLevel", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.analytics.flink.MetricsLevel.class));
            this.minPauseBetweenCheckpoints = software.amazon.jsii.Kernel.get(this, "minPauseBetweenCheckpoints", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.parallelism = software.amazon.jsii.Kernel.get(this, "parallelism", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.parallelismPerKpu = software.amazon.jsii.Kernel.get(this, "parallelismPerKpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.propertyGroups = software.amazon.jsii.Kernel.get(this, "propertyGroups", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.analytics.flink.PropertyGroups.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.RemovalPolicy.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.snapshotsEnabled = software.amazon.jsii.Kernel.get(this, "snapshotsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.code = java.util.Objects.requireNonNull(builder.code, "code is required");
            this.runtime = java.util.Objects.requireNonNull(builder.runtime, "runtime is required");
            this.applicationName = builder.applicationName;
            this.autoScalingEnabled = builder.autoScalingEnabled;
            this.checkpointingEnabled = builder.checkpointingEnabled;
            this.checkpointInterval = builder.checkpointInterval;
            this.logGroup = builder.logGroup;
            this.logLevel = builder.logLevel;
            this.metricsLevel = builder.metricsLevel;
            this.minPauseBetweenCheckpoints = builder.minPauseBetweenCheckpoints;
            this.parallelism = builder.parallelism;
            this.parallelismPerKpu = builder.parallelismPerKpu;
            this.propertyGroups = builder.propertyGroups;
            this.removalPolicy = builder.removalPolicy;
            this.role = builder.role;
            this.snapshotsEnabled = builder.snapshotsEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCode getCode() {
            return this.code;
        }

        @Override
        public final software.amazon.awscdk.services.kinesis.analytics.flink.Runtime getRuntime() {
            return this.runtime;
        }

        @Override
        public final java.lang.String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final java.lang.Boolean getAutoScalingEnabled() {
            return this.autoScalingEnabled;
        }

        @Override
        public final java.lang.Boolean getCheckpointingEnabled() {
            return this.checkpointingEnabled;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getCheckpointInterval() {
            return this.checkpointInterval;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
            return this.logGroup;
        }

        @Override
        public final software.amazon.awscdk.services.kinesis.analytics.flink.LogLevel getLogLevel() {
            return this.logLevel;
        }

        @Override
        public final software.amazon.awscdk.services.kinesis.analytics.flink.MetricsLevel getMetricsLevel() {
            return this.metricsLevel;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getMinPauseBetweenCheckpoints() {
            return this.minPauseBetweenCheckpoints;
        }

        @Override
        public final java.lang.Number getParallelism() {
            return this.parallelism;
        }

        @Override
        public final java.lang.Number getParallelismPerKpu() {
            return this.parallelismPerKpu;
        }

        @Override
        public final software.amazon.awscdk.services.kinesis.analytics.flink.PropertyGroups getPropertyGroups() {
            return this.propertyGroups;
        }

        @Override
        public final software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.lang.Boolean getSnapshotsEnabled() {
            return this.snapshotsEnabled;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("code", om.valueToTree(this.getCode()));
            data.set("runtime", om.valueToTree(this.getRuntime()));
            if (this.getApplicationName() != null) {
                data.set("applicationName", om.valueToTree(this.getApplicationName()));
            }
            if (this.getAutoScalingEnabled() != null) {
                data.set("autoScalingEnabled", om.valueToTree(this.getAutoScalingEnabled()));
            }
            if (this.getCheckpointingEnabled() != null) {
                data.set("checkpointingEnabled", om.valueToTree(this.getCheckpointingEnabled()));
            }
            if (this.getCheckpointInterval() != null) {
                data.set("checkpointInterval", om.valueToTree(this.getCheckpointInterval()));
            }
            if (this.getLogGroup() != null) {
                data.set("logGroup", om.valueToTree(this.getLogGroup()));
            }
            if (this.getLogLevel() != null) {
                data.set("logLevel", om.valueToTree(this.getLogLevel()));
            }
            if (this.getMetricsLevel() != null) {
                data.set("metricsLevel", om.valueToTree(this.getMetricsLevel()));
            }
            if (this.getMinPauseBetweenCheckpoints() != null) {
                data.set("minPauseBetweenCheckpoints", om.valueToTree(this.getMinPauseBetweenCheckpoints()));
            }
            if (this.getParallelism() != null) {
                data.set("parallelism", om.valueToTree(this.getParallelism()));
            }
            if (this.getParallelismPerKpu() != null) {
                data.set("parallelismPerKpu", om.valueToTree(this.getParallelismPerKpu()));
            }
            if (this.getPropertyGroups() != null) {
                data.set("propertyGroups", om.valueToTree(this.getPropertyGroups()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSnapshotsEnabled() != null) {
                data.set("snapshotsEnabled", om.valueToTree(this.getSnapshotsEnabled()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_kinesisanalytics_flink.ApplicationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationProps.Jsii$Proxy that = (ApplicationProps.Jsii$Proxy) o;

            if (!code.equals(that.code)) return false;
            if (!runtime.equals(that.runtime)) return false;
            if (this.applicationName != null ? !this.applicationName.equals(that.applicationName) : that.applicationName != null) return false;
            if (this.autoScalingEnabled != null ? !this.autoScalingEnabled.equals(that.autoScalingEnabled) : that.autoScalingEnabled != null) return false;
            if (this.checkpointingEnabled != null ? !this.checkpointingEnabled.equals(that.checkpointingEnabled) : that.checkpointingEnabled != null) return false;
            if (this.checkpointInterval != null ? !this.checkpointInterval.equals(that.checkpointInterval) : that.checkpointInterval != null) return false;
            if (this.logGroup != null ? !this.logGroup.equals(that.logGroup) : that.logGroup != null) return false;
            if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) return false;
            if (this.metricsLevel != null ? !this.metricsLevel.equals(that.metricsLevel) : that.metricsLevel != null) return false;
            if (this.minPauseBetweenCheckpoints != null ? !this.minPauseBetweenCheckpoints.equals(that.minPauseBetweenCheckpoints) : that.minPauseBetweenCheckpoints != null) return false;
            if (this.parallelism != null ? !this.parallelism.equals(that.parallelism) : that.parallelism != null) return false;
            if (this.parallelismPerKpu != null ? !this.parallelismPerKpu.equals(that.parallelismPerKpu) : that.parallelismPerKpu != null) return false;
            if (this.propertyGroups != null ? !this.propertyGroups.equals(that.propertyGroups) : that.propertyGroups != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            return this.snapshotsEnabled != null ? this.snapshotsEnabled.equals(that.snapshotsEnabled) : that.snapshotsEnabled == null;
        }

        @Override
        public final int hashCode() {
            int result = this.code.hashCode();
            result = 31 * result + (this.runtime.hashCode());
            result = 31 * result + (this.applicationName != null ? this.applicationName.hashCode() : 0);
            result = 31 * result + (this.autoScalingEnabled != null ? this.autoScalingEnabled.hashCode() : 0);
            result = 31 * result + (this.checkpointingEnabled != null ? this.checkpointingEnabled.hashCode() : 0);
            result = 31 * result + (this.checkpointInterval != null ? this.checkpointInterval.hashCode() : 0);
            result = 31 * result + (this.logGroup != null ? this.logGroup.hashCode() : 0);
            result = 31 * result + (this.logLevel != null ? this.logLevel.hashCode() : 0);
            result = 31 * result + (this.metricsLevel != null ? this.metricsLevel.hashCode() : 0);
            result = 31 * result + (this.minPauseBetweenCheckpoints != null ? this.minPauseBetweenCheckpoints.hashCode() : 0);
            result = 31 * result + (this.parallelism != null ? this.parallelism.hashCode() : 0);
            result = 31 * result + (this.parallelismPerKpu != null ? this.parallelismPerKpu.hashCode() : 0);
            result = 31 * result + (this.propertyGroups != null ? this.propertyGroups.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.snapshotsEnabled != null ? this.snapshotsEnabled.hashCode() : 0);
            return result;
        }
    }
}
