package software.amazon.awscdk.services.kinesis.analytics.flink;

/**
 * (experimental) The return type of {@link ApplicationCode.bind}. This represents CloudFormation configuration and an s3 bucket holding the Flink application JAR file.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kinesis.analytics.flink.*;
 * import software.amazon.awscdk.services.s3.*;
 * Bucket bucket;
 * ApplicationCodeConfig applicationCodeConfig = ApplicationCodeConfig.builder()
 *         .applicationCodeConfigurationProperty(ApplicationConfigurationProperty.builder()
 *                 .applicationCodeConfiguration(ApplicationCodeConfigurationProperty.builder()
 *                         .codeContent(CodeContentProperty.builder()
 *                                 .s3ContentLocation(S3ContentLocationProperty.builder()
 *                                         .bucketArn("bucketArn")
 *                                         .fileKey("fileKey")
 *                                         // the properties below are optional
 *                                         .objectVersion("objectVersion")
 *                                         .build())
 *                                 .textContent("textContent")
 *                                 .zipFileContent("zipFileContent")
 *                                 .build())
 *                         .codeContentType("codeContentType")
 *                         .build())
 *                 .applicationSnapshotConfiguration(ApplicationSnapshotConfigurationProperty.builder()
 *                         .snapshotsEnabled(false)
 *                         .build())
 *                 .environmentProperties(EnvironmentPropertiesProperty.builder()
 *                         .propertyGroups(List.of(PropertyGroupProperty.builder()
 *                                 .propertyGroupId("propertyGroupId")
 *                                 .propertyMap(Map.of(
 *                                         "propertyMapKey", "propertyMap"))
 *                                 .build()))
 *                         .build())
 *                 .flinkApplicationConfiguration(FlinkApplicationConfigurationProperty.builder()
 *                         .checkpointConfiguration(CheckpointConfigurationProperty.builder()
 *                                 .configurationType("configurationType")
 *                                 // the properties below are optional
 *                                 .checkpointingEnabled(false)
 *                                 .checkpointInterval(123)
 *                                 .minPauseBetweenCheckpoints(123)
 *                                 .build())
 *                         .monitoringConfiguration(MonitoringConfigurationProperty.builder()
 *                                 .configurationType("configurationType")
 *                                 // the properties below are optional
 *                                 .logLevel("logLevel")
 *                                 .metricsLevel("metricsLevel")
 *                                 .build())
 *                         .parallelismConfiguration(ParallelismConfigurationProperty.builder()
 *                                 .configurationType("configurationType")
 *                                 // the properties below are optional
 *                                 .autoScalingEnabled(false)
 *                                 .parallelism(123)
 *                                 .parallelismPerKpu(123)
 *                                 .build())
 *                         .build())
 *                 .sqlApplicationConfiguration(SqlApplicationConfigurationProperty.builder()
 *                         .inputs(List.of(InputProperty.builder()
 *                                 .inputSchema(InputSchemaProperty.builder()
 *                                         .recordColumns(List.of(RecordColumnProperty.builder()
 *                                                 .name("name")
 *                                                 .sqlType("sqlType")
 *                                                 // the properties below are optional
 *                                                 .mapping("mapping")
 *                                                 .build()))
 *                                         .recordFormat(RecordFormatProperty.builder()
 *                                                 .recordFormatType("recordFormatType")
 *                                                 // the properties below are optional
 *                                                 .mappingParameters(MappingParametersProperty.builder()
 *                                                         .csvMappingParameters(CSVMappingParametersProperty.builder()
 *                                                                 .recordColumnDelimiter("recordColumnDelimiter")
 *                                                                 .recordRowDelimiter("recordRowDelimiter")
 *                                                                 .build())
 *                                                         .jsonMappingParameters(JSONMappingParametersProperty.builder()
 *                                                                 .recordRowPath("recordRowPath")
 *                                                                 .build())
 *                                                         .build())
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .recordEncoding("recordEncoding")
 *                                         .build())
 *                                 .namePrefix("namePrefix")
 *                                 // the properties below are optional
 *                                 .inputParallelism(InputParallelismProperty.builder()
 *                                         .count(123)
 *                                         .build())
 *                                 .inputProcessingConfiguration(InputProcessingConfigurationProperty.builder()
 *                                         .inputLambdaProcessor(InputLambdaProcessorProperty.builder()
 *                                                 .resourceArn("resourceArn")
 *                                                 .build())
 *                                         .build())
 *                                 .kinesisFirehoseInput(KinesisFirehoseInputProperty.builder()
 *                                         .resourceArn("resourceArn")
 *                                         .build())
 *                                 .kinesisStreamsInput(KinesisStreamsInputProperty.builder()
 *                                         .resourceArn("resourceArn")
 *                                         .build())
 *                                 .build()))
 *                         .build())
 *                 .vpcConfigurations(List.of(VpcConfigurationProperty.builder()
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .subnetIds(List.of("subnetIds"))
 *                         .build()))
 *                 .zeppelinApplicationConfiguration(ZeppelinApplicationConfigurationProperty.builder()
 *                         .catalogConfiguration(CatalogConfigurationProperty.builder()
 *                                 .glueDataCatalogConfiguration(GlueDataCatalogConfigurationProperty.builder()
 *                                         .databaseArn("databaseArn")
 *                                         .build())
 *                                 .build())
 *                         .customArtifactsConfiguration(List.of(CustomArtifactConfigurationProperty.builder()
 *                                 .artifactType("artifactType")
 *                                 // the properties below are optional
 *                                 .mavenReference(MavenReferenceProperty.builder()
 *                                         .artifactId("artifactId")
 *                                         .groupId("groupId")
 *                                         .version("version")
 *                                         .build())
 *                                 .s3ContentLocation(S3ContentLocationProperty.builder()
 *                                         .bucketArn("bucketArn")
 *                                         .fileKey("fileKey")
 *                                         // the properties below are optional
 *                                         .objectVersion("objectVersion")
 *                                         .build())
 *                                 .build()))
 *                         .deployAsApplicationConfiguration(DeployAsApplicationConfigurationProperty.builder()
 *                                 .s3ContentLocation(S3ContentBaseLocationProperty.builder()
 *                                         .bucketArn("bucketArn")
 *                                         // the properties below are optional
 *                                         .basePath("basePath")
 *                                         .build())
 *                                 .build())
 *                         .monitoringConfiguration(ZeppelinMonitoringConfigurationProperty.builder()
 *                                 .logLevel("logLevel")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .bucket(bucket)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:04.456Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_kinesisanalytics_flink.ApplicationCodeConfig")
@software.amazon.jsii.Jsii.Proxy(ApplicationCodeConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ApplicationCodeConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Low-level Cloudformation ApplicationConfigurationProperty.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ApplicationConfigurationProperty getApplicationCodeConfigurationProperty();

    /**
     * (experimental) S3 Bucket that stores the Flink application code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getBucket();

    /**
     * @return a {@link Builder} of {@link ApplicationCodeConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationCodeConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ApplicationCodeConfig> {
        software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ApplicationConfigurationProperty applicationCodeConfigurationProperty;
        software.amazon.awscdk.services.s3.IBucket bucket;

        /**
         * Sets the value of {@link ApplicationCodeConfig#getApplicationCodeConfigurationProperty}
         * @param applicationCodeConfigurationProperty Low-level Cloudformation ApplicationConfigurationProperty. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder applicationCodeConfigurationProperty(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ApplicationConfigurationProperty applicationCodeConfigurationProperty) {
            this.applicationCodeConfigurationProperty = applicationCodeConfigurationProperty;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationCodeConfig#getBucket}
         * @param bucket S3 Bucket that stores the Flink application code. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bucket(software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationCodeConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ApplicationCodeConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApplicationCodeConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationCodeConfig {
        private final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ApplicationConfigurationProperty applicationCodeConfigurationProperty;
        private final software.amazon.awscdk.services.s3.IBucket bucket;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationCodeConfigurationProperty = software.amazon.jsii.Kernel.get(this, "applicationCodeConfigurationProperty", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ApplicationConfigurationProperty.class));
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationCodeConfigurationProperty = java.util.Objects.requireNonNull(builder.applicationCodeConfigurationProperty, "applicationCodeConfigurationProperty is required");
            this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
        }

        @Override
        public final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ApplicationConfigurationProperty getApplicationCodeConfigurationProperty() {
            return this.applicationCodeConfigurationProperty;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.bucket;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationCodeConfigurationProperty", om.valueToTree(this.getApplicationCodeConfigurationProperty()));
            data.set("bucket", om.valueToTree(this.getBucket()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_kinesisanalytics_flink.ApplicationCodeConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationCodeConfig.Jsii$Proxy that = (ApplicationCodeConfig.Jsii$Proxy) o;

            if (!applicationCodeConfigurationProperty.equals(that.applicationCodeConfigurationProperty)) return false;
            return this.bucket.equals(that.bucket);
        }

        @Override
        public final int hashCode() {
            int result = this.applicationCodeConfigurationProperty.hashCode();
            result = 31 * result + (this.bucket.hashCode());
            return result;
        }
    }
}
