package software.amazon.awscdk.services.ivs;

/**
 * (experimental) A new IVS channel.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Channel myChannel = new Channel(this, "Channel");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:04.013Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ivs.Channel")
public class Channel extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.ivs.IChannel {

    protected Channel(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Channel(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Channel(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ivs.ChannelProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Channel(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Import an existing channel.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param channelArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ivs.IChannel fromChannelArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String channelArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ivs.Channel.class, "fromChannelArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ivs.IChannel.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(channelArn, "channelArn is required") });
    }

    /**
     * (experimental) Adds a stream key for this IVS Channel.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ivs.StreamKey addStreamKey(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "addStreamKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ivs.StreamKey.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) The channel ARN.
     * <p>
     * For example: arn:aws:ivs:us-west-2:123456789012:channel/abcdABCDefgh
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getChannelArn() {
        return software.amazon.jsii.Kernel.get(this, "channelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Channel ingest endpoint, part of the definition of an ingest server, used when you set up streaming software.
     * <p>
     * For example: a1b2c3d4e5f6.global-contribute.live-video.net
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getChannelIngestEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "channelIngestEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Channel playback URL.
     * <p>
     * For example:
     * https://a1b2c3d4e5f6.us-west-2.playback.live-video.net/api/video/v1/us-west-2.123456789012.channel.abcdEFGH.m3u8
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getChannelPlaybackUrl() {
        return software.amazon.jsii.Kernel.get(this, "channelPlaybackUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.ivs.Channel}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ivs.Channel> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ivs.ChannelProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * (experimental) Whether the channel is authorized.
         * <p>
         * If you wish to make an authorized channel, you will need to ensure that
         * a PlaybackKeyPair has been uploaded to your account as this is used to
         * validate the signed JWT that is required for authorization
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param authorized Whether the channel is authorized. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authorized(final java.lang.Boolean authorized) {
            this.props().authorized(authorized);
            return this;
        }

        /**
         * (experimental) Channel latency mode.
         * <p>
         * Default: LatencyMode.LOW
         * <p>
         * @return {@code this}
         * @param latencyMode Channel latency mode. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder latencyMode(final software.amazon.awscdk.services.ivs.LatencyMode latencyMode) {
            this.props().latencyMode(latencyMode);
            return this;
        }

        /**
         * (experimental) Channel name.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param name Channel name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * (experimental) The channel type, which determines the allowable resolution and bitrate.
         * <p>
         * If you exceed the allowable resolution or bitrate, the stream will disconnect immediately
         * <p>
         * Default: ChannelType.STANDARD
         * <p>
         * @return {@code this}
         * @param type The channel type, which determines the allowable resolution and bitrate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder type(final software.amazon.awscdk.services.ivs.ChannelType type) {
            this.props().type(type);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ivs.Channel}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.ivs.Channel build() {
            return new software.amazon.awscdk.services.ivs.Channel(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ivs.ChannelProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ivs.ChannelProps.Builder();
            }
            return this.props;
        }
    }
}
