package software.amazon.awscdk.services.iotsitewise;

/**
 * Properties for defining a `CfnAsset`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotsitewise.*;
 * CfnAssetProps cfnAssetProps = CfnAssetProps.builder()
 *         .assetModelId("assetModelId")
 *         .assetName("assetName")
 *         // the properties below are optional
 *         .assetDescription("assetDescription")
 *         .assetHierarchies(List.of(AssetHierarchyProperty.builder()
 *                 .childAssetId("childAssetId")
 *                 .logicalId("logicalId")
 *                 .build()))
 *         .assetProperties(List.of(AssetPropertyProperty.builder()
 *                 .logicalId("logicalId")
 *                 // the properties below are optional
 *                 .alias("alias")
 *                 .notificationState("notificationState")
 *                 .unit("unit")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:03.809Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotsitewise.CfnAssetProps")
@software.amazon.jsii.Jsii.Proxy(CfnAssetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAssetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the asset model from which to create the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAssetModelId();

    /**
     * A unique, friendly name for the asset.
     * <p>
     * The maximum length is 256 characters with the pattern <code>[^\ u0000-\ u001F\ u007F]+</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAssetName();

    /**
     * A description for the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssetDescription() {
        return null;
    }

    /**
     * A list of asset hierarchies that each contain a `hierarchyLogicalId` .
     * <p>
     * A hierarchy specifies allowed parent/child asset relationships.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAssetHierarchies() {
        return null;
    }

    /**
     * The list of asset properties for the asset.
     * <p>
     * This object doesn't include properties that you define in composite models. You can find composite model properties in the <code>assetCompositeModels</code> object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAssetProperties() {
        return null;
    }

    /**
     * A list of key-value pairs that contain metadata for the asset.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your AWS IoT SiteWise resources</a> in the <em>AWS IoT SiteWise User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAssetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAssetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAssetProps> {
        java.lang.String assetModelId;
        java.lang.String assetName;
        java.lang.String assetDescription;
        java.lang.Object assetHierarchies;
        java.lang.Object assetProperties;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnAssetProps#getAssetModelId}
         * @param assetModelId The ID of the asset model from which to create the asset. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelId(java.lang.String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssetProps#getAssetName}
         * @param assetName A unique, friendly name for the asset. This parameter is required.
         *                  The maximum length is 256 characters with the pattern <code>[^\ u0000-\ u001F\ u007F]+</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetName(java.lang.String assetName) {
            this.assetName = assetName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssetProps#getAssetDescription}
         * @param assetDescription A description for the asset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetDescription(java.lang.String assetDescription) {
            this.assetDescription = assetDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssetProps#getAssetHierarchies}
         * @param assetHierarchies A list of asset hierarchies that each contain a `hierarchyLogicalId` .
         *                         A hierarchy specifies allowed parent/child asset relationships.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetHierarchies(software.amazon.awscdk.core.IResolvable assetHierarchies) {
            this.assetHierarchies = assetHierarchies;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssetProps#getAssetHierarchies}
         * @param assetHierarchies A list of asset hierarchies that each contain a `hierarchyLogicalId` .
         *                         A hierarchy specifies allowed parent/child asset relationships.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetHierarchies(java.util.List<? extends java.lang.Object> assetHierarchies) {
            this.assetHierarchies = assetHierarchies;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssetProps#getAssetProperties}
         * @param assetProperties The list of asset properties for the asset.
         *                        This object doesn't include properties that you define in composite models. You can find composite model properties in the <code>assetCompositeModels</code> object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetProperties(software.amazon.awscdk.core.IResolvable assetProperties) {
            this.assetProperties = assetProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssetProps#getAssetProperties}
         * @param assetProperties The list of asset properties for the asset.
         *                        This object doesn't include properties that you define in composite models. You can find composite model properties in the <code>assetCompositeModels</code> object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetProperties(java.util.List<? extends java.lang.Object> assetProperties) {
            this.assetProperties = assetProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssetProps#getTags}
         * @param tags A list of key-value pairs that contain metadata for the asset.
         *             For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your AWS IoT SiteWise resources</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAssetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAssetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAssetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAssetProps {
        private final java.lang.String assetModelId;
        private final java.lang.String assetName;
        private final java.lang.String assetDescription;
        private final java.lang.Object assetHierarchies;
        private final java.lang.Object assetProperties;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assetModelId = software.amazon.jsii.Kernel.get(this, "assetModelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetName = software.amazon.jsii.Kernel.get(this, "assetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetDescription = software.amazon.jsii.Kernel.get(this, "assetDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetHierarchies = software.amazon.jsii.Kernel.get(this, "assetHierarchies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.assetProperties = software.amazon.jsii.Kernel.get(this, "assetProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assetModelId = java.util.Objects.requireNonNull(builder.assetModelId, "assetModelId is required");
            this.assetName = java.util.Objects.requireNonNull(builder.assetName, "assetName is required");
            this.assetDescription = builder.assetDescription;
            this.assetHierarchies = builder.assetHierarchies;
            this.assetProperties = builder.assetProperties;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAssetModelId() {
            return this.assetModelId;
        }

        @Override
        public final java.lang.String getAssetName() {
            return this.assetName;
        }

        @Override
        public final java.lang.String getAssetDescription() {
            return this.assetDescription;
        }

        @Override
        public final java.lang.Object getAssetHierarchies() {
            return this.assetHierarchies;
        }

        @Override
        public final java.lang.Object getAssetProperties() {
            return this.assetProperties;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("assetModelId", om.valueToTree(this.getAssetModelId()));
            data.set("assetName", om.valueToTree(this.getAssetName()));
            if (this.getAssetDescription() != null) {
                data.set("assetDescription", om.valueToTree(this.getAssetDescription()));
            }
            if (this.getAssetHierarchies() != null) {
                data.set("assetHierarchies", om.valueToTree(this.getAssetHierarchies()));
            }
            if (this.getAssetProperties() != null) {
                data.set("assetProperties", om.valueToTree(this.getAssetProperties()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_iotsitewise.CfnAssetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAssetProps.Jsii$Proxy that = (CfnAssetProps.Jsii$Proxy) o;

            if (!assetModelId.equals(that.assetModelId)) return false;
            if (!assetName.equals(that.assetName)) return false;
            if (this.assetDescription != null ? !this.assetDescription.equals(that.assetDescription) : that.assetDescription != null) return false;
            if (this.assetHierarchies != null ? !this.assetHierarchies.equals(that.assetHierarchies) : that.assetHierarchies != null) return false;
            if (this.assetProperties != null ? !this.assetProperties.equals(that.assetProperties) : that.assetProperties != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assetModelId.hashCode();
            result = 31 * result + (this.assetName.hashCode());
            result = 31 * result + (this.assetDescription != null ? this.assetDescription.hashCode() : 0);
            result = 31 * result + (this.assetHierarchies != null ? this.assetHierarchies.hashCode() : 0);
            result = 31 * result + (this.assetProperties != null ? this.assetProperties.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
