package software.amazon.awscdk.services.iotevents;

/**
 * (experimental) Properties for defining a state of a detector.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * IInput input;
 * State state = State.Builder.create()
 *         .stateName("MyState")
 *         .onEnter(List.of(Event.builder()
 *                 .eventName("test-event")
 *                 .condition(Expression.currentInput(input))
 *                 .actions(List.of(actions, List.of(
 *                     new SetVariableAction("MyVariable", Expression.inputAttribute(input, "payload.temperature")))))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:03.682Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotevents.StateProps")
@software.amazon.jsii.Jsii.Proxy(StateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface StateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The name of the state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getStateName();

    /**
     * (experimental) Specifies the events on enter.
     * <p>
     * The conditions of the events will be evaluated when entering this state.
     * If the condition of the event evaluates to <code>true</code>, the actions of the event will be executed.
     * <p>
     * Default: - no events will trigger on entering this state
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iotevents.Event> getOnEnter() {
        return null;
    }

    /**
     * (experimental) Specifies the events on exit.
     * <p>
     * The conditions of the events are evaluated when an exiting this state.
     * If the condition evaluates to <code>true</code>, the actions of the event will be executed.
     * <p>
     * Default: - no events will trigger on exiting this state
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iotevents.Event> getOnExit() {
        return null;
    }

    /**
     * (experimental) Specifies the events on input.
     * <p>
     * The conditions of the events will be evaluated when any input is received.
     * If the condition of the event evaluates to <code>true</code>, the actions of the event will be executed.
     * <p>
     * Default: - no events will trigger on input in this state
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iotevents.Event> getOnInput() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<StateProps> {
        java.lang.String stateName;
        java.util.List<software.amazon.awscdk.services.iotevents.Event> onEnter;
        java.util.List<software.amazon.awscdk.services.iotevents.Event> onExit;
        java.util.List<software.amazon.awscdk.services.iotevents.Event> onInput;

        /**
         * Sets the value of {@link StateProps#getStateName}
         * @param stateName The name of the state. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stateName(java.lang.String stateName) {
            this.stateName = stateName;
            return this;
        }

        /**
         * Sets the value of {@link StateProps#getOnEnter}
         * @param onEnter Specifies the events on enter.
         *                The conditions of the events will be evaluated when entering this state.
         *                If the condition of the event evaluates to <code>true</code>, the actions of the event will be executed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder onEnter(java.util.List<? extends software.amazon.awscdk.services.iotevents.Event> onEnter) {
            this.onEnter = (java.util.List<software.amazon.awscdk.services.iotevents.Event>)onEnter;
            return this;
        }

        /**
         * Sets the value of {@link StateProps#getOnExit}
         * @param onExit Specifies the events on exit.
         *               The conditions of the events are evaluated when an exiting this state.
         *               If the condition evaluates to <code>true</code>, the actions of the event will be executed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder onExit(java.util.List<? extends software.amazon.awscdk.services.iotevents.Event> onExit) {
            this.onExit = (java.util.List<software.amazon.awscdk.services.iotevents.Event>)onExit;
            return this;
        }

        /**
         * Sets the value of {@link StateProps#getOnInput}
         * @param onInput Specifies the events on input.
         *                The conditions of the events will be evaluated when any input is received.
         *                If the condition of the event evaluates to <code>true</code>, the actions of the event will be executed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder onInput(java.util.List<? extends software.amazon.awscdk.services.iotevents.Event> onInput) {
            this.onInput = (java.util.List<software.amazon.awscdk.services.iotevents.Event>)onInput;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public StateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StateProps {
        private final java.lang.String stateName;
        private final java.util.List<software.amazon.awscdk.services.iotevents.Event> onEnter;
        private final java.util.List<software.amazon.awscdk.services.iotevents.Event> onExit;
        private final java.util.List<software.amazon.awscdk.services.iotevents.Event> onInput;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stateName = software.amazon.jsii.Kernel.get(this, "stateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.onEnter = software.amazon.jsii.Kernel.get(this, "onEnter", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.Event.class)));
            this.onExit = software.amazon.jsii.Kernel.get(this, "onExit", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.Event.class)));
            this.onInput = software.amazon.jsii.Kernel.get(this, "onInput", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.Event.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stateName = java.util.Objects.requireNonNull(builder.stateName, "stateName is required");
            this.onEnter = (java.util.List<software.amazon.awscdk.services.iotevents.Event>)builder.onEnter;
            this.onExit = (java.util.List<software.amazon.awscdk.services.iotevents.Event>)builder.onExit;
            this.onInput = (java.util.List<software.amazon.awscdk.services.iotevents.Event>)builder.onInput;
        }

        @Override
        public final java.lang.String getStateName() {
            return this.stateName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iotevents.Event> getOnEnter() {
            return this.onEnter;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iotevents.Event> getOnExit() {
            return this.onExit;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iotevents.Event> getOnInput() {
            return this.onInput;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("stateName", om.valueToTree(this.getStateName()));
            if (this.getOnEnter() != null) {
                data.set("onEnter", om.valueToTree(this.getOnEnter()));
            }
            if (this.getOnExit() != null) {
                data.set("onExit", om.valueToTree(this.getOnExit()));
            }
            if (this.getOnInput() != null) {
                data.set("onInput", om.valueToTree(this.getOnInput()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_iotevents.StateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StateProps.Jsii$Proxy that = (StateProps.Jsii$Proxy) o;

            if (!stateName.equals(that.stateName)) return false;
            if (this.onEnter != null ? !this.onEnter.equals(that.onEnter) : that.onEnter != null) return false;
            if (this.onExit != null ? !this.onExit.equals(that.onExit) : that.onExit != null) return false;
            return this.onInput != null ? this.onInput.equals(that.onInput) : that.onInput == null;
        }

        @Override
        public final int hashCode() {
            int result = this.stateName.hashCode();
            result = 31 * result + (this.onEnter != null ? this.onEnter.hashCode() : 0);
            result = 31 * result + (this.onExit != null ? this.onExit.hashCode() : 0);
            result = 31 * result + (this.onInput != null ? this.onInput.hashCode() : 0);
            return result;
        }
    }
}
