package software.amazon.awscdk.services.iotevents;

/**
 * (experimental) Information about the order in which events are evaluated and how actions are executed.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * IFunction func;
 * Input input = Input.Builder.create(this, "MyInput")
 *         .inputName("my_input") // optional
 *         .attributeJsonPaths(List.of("payload.deviceId", "payload.temperature"))
 *         .build();
 * State warmState = State.Builder.create()
 *         .stateName("warm")
 *         .onEnter(List.of(Event.builder()
 *                 .eventName("test-enter-event")
 *                 .condition(Expression.currentInput(input))
 *                 .actions(List.of(new LambdaInvokeAction(func)))
 *                 .build()))
 *         .onInput(List.of(Event.builder() // optional
 *                 .eventName("test-input-event")
 *                 .actions(List.of(new LambdaInvokeAction(func))).build()))
 *         .onExit(List.of(Event.builder() // optional
 *                 .eventName("test-exit-event")
 *                 .actions(List.of(new LambdaInvokeAction(func))).build()))
 *         .build();
 * State coldState = State.Builder.create()
 *         .stateName("cold")
 *         .build();
 * // transit to coldState when temperature is less than 15
 * warmState.transitionTo(coldState, TransitionOptions.builder()
 *         .eventName("to_coldState") // optional property, default by combining the names of the States
 *         .when(Expression.lt(Expression.inputAttribute(input, "payload.temperature"), Expression.fromString("15")))
 *         .executing(List.of(new LambdaInvokeAction(func)))
 *         .build());
 * // transit to warmState when temperature is greater than or equal to 15
 * coldState.transitionTo(warmState, TransitionOptions.builder()
 *         .when(Expression.gte(Expression.inputAttribute(input, "payload.temperature"), Expression.fromString("15")))
 *         .build());
 * DetectorModel.Builder.create(this, "MyDetectorModel")
 *         .detectorModelName("test-detector-model") // optional
 *         .description("test-detector-model-description") // optional property, default is none
 *         .evaluationMethod(EventEvaluation.SERIAL) // optional property, default is iotevents.EventEvaluation.BATCH
 *         .detectorKey("payload.deviceId") // optional property, default is none and single detector instance will be created and all inputs will be routed to it
 *         .initialState(warmState)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:03.653Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotevents.EventEvaluation")
public enum EventEvaluation {
    /**
     * (experimental) When setting to BATCH, variables within a state are updated and events within a state are performed only after all event conditions are evaluated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    BATCH,
    /**
     * (experimental) When setting to SERIAL, variables are updated and event conditions are evaluated in the order that the events are defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SERIAL,
}
