package software.amazon.awscdk.services.iotevents;

/**
 * (experimental) Defines an AWS IoT Events detector model in this stack.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * IFunction func;
 * Input input = Input.Builder.create(this, "MyInput")
 *         .inputName("my_input") // optional
 *         .attributeJsonPaths(List.of("payload.deviceId", "payload.temperature"))
 *         .build();
 * State warmState = State.Builder.create()
 *         .stateName("warm")
 *         .onEnter(List.of(Event.builder()
 *                 .eventName("test-enter-event")
 *                 .condition(Expression.currentInput(input))
 *                 .actions(List.of(new LambdaInvokeAction(func)))
 *                 .build()))
 *         .onInput(List.of(Event.builder() // optional
 *                 .eventName("test-input-event")
 *                 .actions(List.of(new LambdaInvokeAction(func))).build()))
 *         .onExit(List.of(Event.builder() // optional
 *                 .eventName("test-exit-event")
 *                 .actions(List.of(new LambdaInvokeAction(func))).build()))
 *         .build();
 * State coldState = State.Builder.create()
 *         .stateName("cold")
 *         .build();
 * // transit to coldState when temperature is less than 15
 * warmState.transitionTo(coldState, TransitionOptions.builder()
 *         .eventName("to_coldState") // optional property, default by combining the names of the States
 *         .when(Expression.lt(Expression.inputAttribute(input, "payload.temperature"), Expression.fromString("15")))
 *         .executing(List.of(new LambdaInvokeAction(func)))
 *         .build());
 * // transit to warmState when temperature is greater than or equal to 15
 * coldState.transitionTo(warmState, TransitionOptions.builder()
 *         .when(Expression.gte(Expression.inputAttribute(input, "payload.temperature"), Expression.fromString("15")))
 *         .build());
 * DetectorModel.Builder.create(this, "MyDetectorModel")
 *         .detectorModelName("test-detector-model") // optional
 *         .description("test-detector-model-description") // optional property, default is none
 *         .evaluationMethod(EventEvaluation.SERIAL) // optional property, default is iotevents.EventEvaluation.BATCH
 *         .detectorKey("payload.deviceId") // optional property, default is none and single detector instance will be created and all inputs will be routed to it
 *         .initialState(warmState)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:03.647Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotevents.DetectorModel")
public class DetectorModel extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.iotevents.IDetectorModel {

    protected DetectorModel(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DetectorModel(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public DetectorModel(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.DetectorModelProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Import an existing detector model.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param detectorModelName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.IDetectorModel fromDetectorModelName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String detectorModelName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotevents.DetectorModel.class, "fromDetectorModelName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.IDetectorModel.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(detectorModelName, "detectorModelName is required") });
    }

    /**
     * (experimental) The name of the detector model.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getDetectorModelName() {
        return software.amazon.jsii.Kernel.get(this, "detectorModelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.iotevents.DetectorModel}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotevents.DetectorModel> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotevents.DetectorModelProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotevents.DetectorModelProps.Builder();
        }

        /**
         * (experimental) The state that is entered at the creation of each detector.
         * <p>
         * @return {@code this}
         * @param initialState The state that is entered at the creation of each detector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder initialState(final software.amazon.awscdk.services.iotevents.State initialState) {
            this.props.initialState(initialState);
            return this;
        }

        /**
         * (experimental) A brief description of the detector model.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param description A brief description of the detector model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * (experimental) The value used to identify a detector instance.
         * <p>
         * When a device or system sends input, a new
         * detector instance with a unique key value is created. AWS IoT Events can continue to route
         * input to its corresponding detector instance based on this identifying information.
         * <p>
         * This parameter uses a JSON-path expression to select the attribute-value pair in the message
         * payload that is used for identification. To route the message to the correct detector instance,
         * the device must send a message payload that contains the same attribute-value.
         * <p>
         * Default: - none (single detector instance will be created and all inputs will be routed to it)
         * <p>
         * @return {@code this}
         * @param detectorKey The value used to identify a detector instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder detectorKey(final java.lang.String detectorKey) {
            this.props.detectorKey(detectorKey);
            return this;
        }

        /**
         * (experimental) The name of the detector model.
         * <p>
         * Default: - CloudFormation will generate a unique name of the detector model
         * <p>
         * @return {@code this}
         * @param detectorModelName The name of the detector model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder detectorModelName(final java.lang.String detectorModelName) {
            this.props.detectorModelName(detectorModelName);
            return this;
        }

        /**
         * (experimental) Information about the order in which events are evaluated and how actions are executed.
         * <p>
         * When setting to SERIAL, variables are updated and event conditions are evaluated in the order
         * that the events are defined.
         * When setting to BATCH, variables within a state are updated and events within a state are
         * performed only after all event conditions are evaluated.
         * <p>
         * Default: EventEvaluation.BATCH
         * <p>
         * @return {@code this}
         * @param evaluationMethod Information about the order in which events are evaluated and how actions are executed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder evaluationMethod(final software.amazon.awscdk.services.iotevents.EventEvaluation evaluationMethod) {
            this.props.evaluationMethod(evaluationMethod);
            return this;
        }

        /**
         * (experimental) The role that grants permission to AWS IoT Events to perform its operations.
         * <p>
         * Default: - a role will be created with default permissions
         * <p>
         * @return {@code this}
         * @param role The role that grants permission to AWS IoT Events to perform its operations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iotevents.DetectorModel}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.iotevents.DetectorModel build() {
            return new software.amazon.awscdk.services.iotevents.DetectorModel(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
