package software.amazon.awscdk.services.iot.actions;

/**
 * (experimental) Configuration properties of an action for s3.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket = new Bucket(this, "MyBucket");
 * TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT topic(2) as device_id, year, month, day FROM 'device/+/data'"))
 *         .actions(List.of(
 *             S3PutObjectAction.Builder.create(bucket)
 *                     .key("${year}/${month}/${day}/${topic(2)}")
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:03.346Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot_actions.S3PutObjectActionProps")
@software.amazon.jsii.Jsii.Proxy(S3PutObjectActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface S3PutObjectActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.iot.actions.CommonActionProps {

    /**
     * (experimental) The Amazon S3 canned ACL that controls access to the object identified by the object key.
     * <p>
     * Default: None
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl">https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketAccessControl getAccessControl() {
        return null;
    }

    /**
     * (experimental) The path to the file where the data is written.
     * <p>
     * Supports substitution templates.
     * <p>
     * Default: '${topic()}/${timestamp()}'
     * <p>
     * @see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link S3PutObjectActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link S3PutObjectActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<S3PutObjectActionProps> {
        software.amazon.awscdk.services.s3.BucketAccessControl accessControl;
        java.lang.String key;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link S3PutObjectActionProps#getAccessControl}
         * @param accessControl The Amazon S3 canned ACL that controls access to the object identified by the object key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder accessControl(software.amazon.awscdk.services.s3.BucketAccessControl accessControl) {
            this.accessControl = accessControl;
            return this;
        }

        /**
         * Sets the value of {@link S3PutObjectActionProps#getKey}
         * @param key The path to the file where the data is written.
         *            Supports substitution templates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder key(java.lang.String key) {
            this.key = key;
            return this;
        }

        /**
         * Sets the value of {@link S3PutObjectActionProps#getRole}
         * @param role The IAM role that allows access to AWS service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link S3PutObjectActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public S3PutObjectActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link S3PutObjectActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3PutObjectActionProps {
        private final software.amazon.awscdk.services.s3.BucketAccessControl accessControl;
        private final java.lang.String key;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessControl = software.amazon.jsii.Kernel.get(this, "accessControl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.BucketAccessControl.class));
            this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessControl = builder.accessControl;
            this.key = builder.key;
            this.role = builder.role;
        }

        @Override
        public final software.amazon.awscdk.services.s3.BucketAccessControl getAccessControl() {
            return this.accessControl;
        }

        @Override
        public final java.lang.String getKey() {
            return this.key;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccessControl() != null) {
                data.set("accessControl", om.valueToTree(this.getAccessControl()));
            }
            if (this.getKey() != null) {
                data.set("key", om.valueToTree(this.getKey()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_iot_actions.S3PutObjectActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            S3PutObjectActionProps.Jsii$Proxy that = (S3PutObjectActionProps.Jsii$Proxy) o;

            if (this.accessControl != null ? !this.accessControl.equals(that.accessControl) : that.accessControl != null) return false;
            if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessControl != null ? this.accessControl.hashCode() : 0;
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
