package software.amazon.awscdk.services.iot.actions;

/**
 * (experimental) The action to put the record from an MQTT message to the Kinesis Data stream.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * Stream stream = new Stream(this, "MyStream");
 * TopicRule topicRule = TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT * FROM 'device/+/data'"))
 *         .actions(List.of(
 *             KinesisPutRecordAction.Builder.create(stream)
 *                     .partitionKey("${newuuid()}")
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:03.340Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot_actions.KinesisPutRecordAction")
public class KinesisPutRecordAction extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iot.IAction {

    protected KinesisPutRecordAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KinesisPutRecordAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param stream The Kinesis Data stream to which to put records. This parameter is required.
     * @param props Optional properties to not use default. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public KinesisPutRecordAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.IStream stream, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.actions.KinesisPutRecordActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(stream, "stream is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Returns the topic rule action specification.
     * <p>
     * @param rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.ActionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.ITopicRule rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iot.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.iot.actions.KinesisPutRecordAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iot.actions.KinesisPutRecordAction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param stream The Kinesis Data stream to which to put records. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.services.kinesis.IStream stream) {
            return new Builder(stream);
        }

        private final software.amazon.awscdk.services.kinesis.IStream stream;
        private final software.amazon.awscdk.services.iot.actions.KinesisPutRecordActionProps.Builder props;

        private Builder(final software.amazon.awscdk.services.kinesis.IStream stream) {
            this.stream = stream;
            this.props = new software.amazon.awscdk.services.iot.actions.KinesisPutRecordActionProps.Builder();
        }

        /**
         * (experimental) The IAM role that allows access to AWS service.
         * <p>
         * Default: a new role will be created
         * <p>
         * @return {@code this}
         * @param role The IAM role that allows access to AWS service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * (experimental) The partition key used to determine to which shard the data is written.
         * <p>
         * The partition key is usually composed of an expression (for example, ${topic()} or ${timestamp()}).
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/kinesis/latest/APIReference/API_PutRecord.html#API_PutRecord_RequestParameters">https://docs.aws.amazon.com/kinesis/latest/APIReference/API_PutRecord.html#API_PutRecord_RequestParameters</a>
         * @param partitionKey The partition key used to determine to which shard the data is written. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder partitionKey(final java.lang.String partitionKey) {
            this.props.partitionKey(partitionKey);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iot.actions.KinesisPutRecordAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.iot.actions.KinesisPutRecordAction build() {
            return new software.amazon.awscdk.services.iot.actions.KinesisPutRecordAction(
                this.stream,
                this.props.build()
            );
        }
    }
}
