package software.amazon.awscdk.services.iot.actions;

/**
 * (experimental) Record Separator to be used to separate records.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * Bucket bucket = new Bucket(this, "MyBucket");
 * DeliveryStream stream = DeliveryStream.Builder.create(this, "MyStream")
 *         .destinations(List.of(new S3Bucket(bucket)))
 *         .build();
 * TopicRule topicRule = TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT * FROM 'device/+/data'"))
 *         .actions(List.of(
 *             FirehosePutRecordAction.Builder.create(stream)
 *                     .batchMode(true)
 *                     .recordSeparator(FirehoseRecordSeparator.NEWLINE)
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:03.336Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot_actions.FirehoseRecordSeparator")
public enum FirehoseRecordSeparator {
    /**
     * (experimental) Separate by a new line.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    NEWLINE,
    /**
     * (experimental) Separate by a tab.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TAB,
    /**
     * (experimental) Separate by a windows new line.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    WINDOWS_NEWLINE,
    /**
     * (experimental) Separate by a commma.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    COMMA,
}
