package software.amazon.awscdk.services.iot.actions;

/**
 * (experimental) Configuration properties of an action for the Kinesis Data Firehose stream.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * Bucket bucket = new Bucket(this, "MyBucket");
 * DeliveryStream stream = DeliveryStream.Builder.create(this, "MyStream")
 *         .destinations(List.of(new S3Bucket(bucket)))
 *         .build();
 * TopicRule topicRule = TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT * FROM 'device/+/data'"))
 *         .actions(List.of(
 *             FirehosePutRecordAction.Builder.create(stream)
 *                     .batchMode(true)
 *                     .recordSeparator(FirehoseRecordSeparator.NEWLINE)
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:03.334Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot_actions.FirehosePutRecordActionProps")
@software.amazon.jsii.Jsii.Proxy(FirehosePutRecordActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface FirehosePutRecordActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.iot.actions.CommonActionProps {

    /**
     * (experimental) Whether to deliver the Kinesis Data Firehose stream as a batch by using `PutRecordBatch`.
     * <p>
     * When batchMode is true and the rule's SQL statement evaluates to an Array, each Array
     * element forms one record in the PutRecordBatch request. The resulting array can't have
     * more than 500 records.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getBatchMode() {
        return null;
    }

    /**
     * (experimental) A character separator that will be used to separate records written to the Kinesis Data Firehose stream.
     * <p>
     * Default: - none -- the stream does not use a separator
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.actions.FirehoseRecordSeparator getRecordSeparator() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FirehosePutRecordActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FirehosePutRecordActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<FirehosePutRecordActionProps> {
        java.lang.Boolean batchMode;
        software.amazon.awscdk.services.iot.actions.FirehoseRecordSeparator recordSeparator;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link FirehosePutRecordActionProps#getBatchMode}
         * @param batchMode Whether to deliver the Kinesis Data Firehose stream as a batch by using `PutRecordBatch`.
         *                  When batchMode is true and the rule's SQL statement evaluates to an Array, each Array
         *                  element forms one record in the PutRecordBatch request. The resulting array can't have
         *                  more than 500 records.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder batchMode(java.lang.Boolean batchMode) {
            this.batchMode = batchMode;
            return this;
        }

        /**
         * Sets the value of {@link FirehosePutRecordActionProps#getRecordSeparator}
         * @param recordSeparator A character separator that will be used to separate records written to the Kinesis Data Firehose stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder recordSeparator(software.amazon.awscdk.services.iot.actions.FirehoseRecordSeparator recordSeparator) {
            this.recordSeparator = recordSeparator;
            return this;
        }

        /**
         * Sets the value of {@link FirehosePutRecordActionProps#getRole}
         * @param role The IAM role that allows access to AWS service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FirehosePutRecordActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public FirehosePutRecordActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FirehosePutRecordActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FirehosePutRecordActionProps {
        private final java.lang.Boolean batchMode;
        private final software.amazon.awscdk.services.iot.actions.FirehoseRecordSeparator recordSeparator;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.batchMode = software.amazon.jsii.Kernel.get(this, "batchMode", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.recordSeparator = software.amazon.jsii.Kernel.get(this, "recordSeparator", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iot.actions.FirehoseRecordSeparator.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.batchMode = builder.batchMode;
            this.recordSeparator = builder.recordSeparator;
            this.role = builder.role;
        }

        @Override
        public final java.lang.Boolean getBatchMode() {
            return this.batchMode;
        }

        @Override
        public final software.amazon.awscdk.services.iot.actions.FirehoseRecordSeparator getRecordSeparator() {
            return this.recordSeparator;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBatchMode() != null) {
                data.set("batchMode", om.valueToTree(this.getBatchMode()));
            }
            if (this.getRecordSeparator() != null) {
                data.set("recordSeparator", om.valueToTree(this.getRecordSeparator()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_iot_actions.FirehosePutRecordActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FirehosePutRecordActionProps.Jsii$Proxy that = (FirehosePutRecordActionProps.Jsii$Proxy) o;

            if (this.batchMode != null ? !this.batchMode.equals(that.batchMode) : that.batchMode != null) return false;
            if (this.recordSeparator != null ? !this.recordSeparator.equals(that.recordSeparator) : that.recordSeparator != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.batchMode != null ? this.batchMode.hashCode() : 0;
            result = 31 * result + (this.recordSeparator != null ? this.recordSeparator.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
