package software.amazon.awscdk.services.iot.actions;

/**
 * (experimental) The action to capture an Amazon CloudWatch metric.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * TopicRule topicRule = TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT topic(2) as device_id, namespace, unit, value, timestamp FROM 'device/+/data'"))
 *         .actions(List.of(
 *             CloudWatchPutMetricAction.Builder.create()
 *                     .metricName("${topic(2)}")
 *                     .metricNamespace("${namespace}")
 *                     .metricUnit("${unit}")
 *                     .metricValue("${value}")
 *                     .metricTimestamp("${timestamp}")
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:03.326Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot_actions.CloudWatchPutMetricAction")
public class CloudWatchPutMetricAction extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iot.IAction {

    protected CloudWatchPutMetricAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudWatchPutMetricAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public CloudWatchPutMetricAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.actions.CloudWatchPutMetricActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Returns the topic rule action specification.
     * <p>
     * @param rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.ActionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.ITopicRule rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iot.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.iot.actions.CloudWatchPutMetricAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iot.actions.CloudWatchPutMetricAction> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.iot.actions.CloudWatchPutMetricActionProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.iot.actions.CloudWatchPutMetricActionProps.Builder();
        }

        /**
         * (experimental) The IAM role that allows access to AWS service.
         * <p>
         * Default: a new role will be created
         * <p>
         * @return {@code this}
         * @param role The IAM role that allows access to AWS service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * (experimental) The CloudWatch metric name.
         * <p>
         * Supports substitution templates.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html</a>
         * @param metricName The CloudWatch metric name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metricName(final java.lang.String metricName) {
            this.props.metricName(metricName);
            return this;
        }

        /**
         * (experimental) The CloudWatch metric namespace name.
         * <p>
         * Supports substitution templates.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html</a>
         * @param metricNamespace The CloudWatch metric namespace name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metricNamespace(final java.lang.String metricNamespace) {
            this.props.metricNamespace(metricNamespace);
            return this;
        }

        /**
         * (experimental) The metric unit supported by CloudWatch.
         * <p>
         * Supports substitution templates.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html</a>
         * @param metricUnit The metric unit supported by CloudWatch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metricUnit(final java.lang.String metricUnit) {
            this.props.metricUnit(metricUnit);
            return this;
        }

        /**
         * (experimental) A string that contains the CloudWatch metric value.
         * <p>
         * Supports substitution templates.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html</a>
         * @param metricValue A string that contains the CloudWatch metric value. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metricValue(final java.lang.String metricValue) {
            this.props.metricValue(metricValue);
            return this;
        }

        /**
         * (experimental) A string that contains the timestamp, expressed in seconds in Unix epoch time.
         * <p>
         * Supports substitution templates.
         * <p>
         * Default: - none -- Defaults to the current Unix epoch time.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html</a>
         * @param metricTimestamp A string that contains the timestamp, expressed in seconds in Unix epoch time. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metricTimestamp(final java.lang.String metricTimestamp) {
            this.props.metricTimestamp(metricTimestamp);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iot.actions.CloudWatchPutMetricAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.iot.actions.CloudWatchPutMetricAction build() {
            return new software.amazon.awscdk.services.iot.actions.CloudWatchPutMetricAction(
                this.props.build()
            );
        }
    }
}
