package software.amazon.awscdk.services.iot.actions;

/**
 * (experimental) The action to send data to Amazon CloudWatch Logs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * LogGroup logGroup = new LogGroup(this, "MyLogGroup");
 * TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT topic(2) as device_id, timestamp() as timestamp FROM 'device/+/data'"))
 *         .errorAction(new CloudWatchLogsAction(logGroup))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:03.303Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot_actions.CloudWatchLogsAction")
public class CloudWatchLogsAction extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iot.IAction {

    protected CloudWatchLogsAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudWatchLogsAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param logGroup The CloudWatch log group to which the action sends data. This parameter is required.
     * @param props Optional properties to not use default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public CloudWatchLogsAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogGroup logGroup, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.actions.CloudWatchLogsActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(logGroup, "logGroup is required"), props });
    }

    /**
     * @param logGroup The CloudWatch log group to which the action sends data. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public CloudWatchLogsAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogGroup logGroup) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(logGroup, "logGroup is required") });
    }

    /**
     * (experimental) Returns the topic rule action specification.
     * <p>
     * @param rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.ActionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.ITopicRule rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iot.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.iot.actions.CloudWatchLogsAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iot.actions.CloudWatchLogsAction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param logGroup The CloudWatch log group to which the action sends data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            return new Builder(logGroup);
        }

        private final software.amazon.awscdk.services.logs.ILogGroup logGroup;
        private software.amazon.awscdk.services.iot.actions.CloudWatchLogsActionProps.Builder props;

        private Builder(final software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.logGroup = logGroup;
        }

        /**
         * (experimental) The IAM role that allows access to AWS service.
         * <p>
         * Default: a new role will be created
         * <p>
         * @return {@code this}
         * @param role The IAM role that allows access to AWS service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props().role(role);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iot.actions.CloudWatchLogsAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.iot.actions.CloudWatchLogsAction build() {
            return new software.amazon.awscdk.services.iot.actions.CloudWatchLogsAction(
                this.logGroup,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iot.actions.CloudWatchLogsActionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iot.actions.CloudWatchLogsActionProps.Builder();
            }
            return this.props;
        }
    }
}
