package software.amazon.awscdk.services.iot;

/**
 * (experimental) The type returned from the `bind()` method in {@link IotSql}.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * IotSqlConfig iotSqlConfig = IotSqlConfig.builder()
 *         .awsIotSqlVersion("awsIotSqlVersion")
 *         .sql("sql")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:03.274Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot.IotSqlConfig")
@software.amazon.jsii.Jsii.Proxy(IotSqlConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface IotSqlConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The version of the SQL rules engine to use when evaluating the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getAwsIotSqlVersion();

    /**
     * (experimental) The SQL statement used to query the topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getSql();

    /**
     * @return a {@link Builder} of {@link IotSqlConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IotSqlConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<IotSqlConfig> {
        java.lang.String awsIotSqlVersion;
        java.lang.String sql;

        /**
         * Sets the value of {@link IotSqlConfig#getAwsIotSqlVersion}
         * @param awsIotSqlVersion The version of the SQL rules engine to use when evaluating the rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder awsIotSqlVersion(java.lang.String awsIotSqlVersion) {
            this.awsIotSqlVersion = awsIotSqlVersion;
            return this;
        }

        /**
         * Sets the value of {@link IotSqlConfig#getSql}
         * @param sql The SQL statement used to query the topic. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sql(java.lang.String sql) {
            this.sql = sql;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IotSqlConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public IotSqlConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IotSqlConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IotSqlConfig {
        private final java.lang.String awsIotSqlVersion;
        private final java.lang.String sql;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.awsIotSqlVersion = software.amazon.jsii.Kernel.get(this, "awsIotSqlVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sql = software.amazon.jsii.Kernel.get(this, "sql", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.awsIotSqlVersion = java.util.Objects.requireNonNull(builder.awsIotSqlVersion, "awsIotSqlVersion is required");
            this.sql = java.util.Objects.requireNonNull(builder.sql, "sql is required");
        }

        @Override
        public final java.lang.String getAwsIotSqlVersion() {
            return this.awsIotSqlVersion;
        }

        @Override
        public final java.lang.String getSql() {
            return this.sql;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("awsIotSqlVersion", om.valueToTree(this.getAwsIotSqlVersion()));
            data.set("sql", om.valueToTree(this.getSql()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_iot.IotSqlConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IotSqlConfig.Jsii$Proxy that = (IotSqlConfig.Jsii$Proxy) o;

            if (!awsIotSqlVersion.equals(that.awsIotSqlVersion)) return false;
            return this.sql.equals(that.sql);
        }

        @Override
        public final int hashCode() {
            int result = this.awsIotSqlVersion.hashCode();
            result = 31 * result + (this.sql.hashCode());
            return result;
        }
    }
}
