package software.amazon.awscdk.services.iot;

/**
 * A CloudFormation `AWS::IoT::CACertificate`.
 * <p>
 * Specifies a CA certificate.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnCACertificate cfnCACertificate = CfnCACertificate.Builder.create(this, "MyCfnCACertificate")
 *         .caCertificatePem("caCertificatePem")
 *         .status("status")
 *         // the properties below are optional
 *         .autoRegistrationStatus("autoRegistrationStatus")
 *         .certificateMode("certificateMode")
 *         .registrationConfig(RegistrationConfigProperty.builder()
 *                 .roleArn("roleArn")
 *                 .templateBody("templateBody")
 *                 .templateName("templateName")
 *                 .build())
 *         .removeAutoRegistration(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .verificationCertificatePem("verificationCertificatePem")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:03.056Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot.CfnCACertificate")
public class CfnCACertificate extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnCACertificate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCACertificate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iot.CfnCACertificate.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::IoT::CACertificate`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCACertificate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.CfnCACertificateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the Amazon Resource Name (ARN) for the instance profile. For example:.
     * <p>
     * <code>{ "Fn::GetAtt": ["MyCACertificate", "Arn"] }</code>
     * <p>
     * A value similar to the following is returned:
     * <p>
     * <code>arn:aws:iot:us-east-1:123456789012:cacert/a6be6b84559801927e35a8f901fae08b5971d78d1562e29504ff9663b276a5f5</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The CA certificate ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The certificate data in PEM format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCaCertificatePem() {
        return software.amazon.jsii.Kernel.get(this, "caCertificatePem", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The certificate data in PEM format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCaCertificatePem(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "caCertificatePem", java.util.Objects.requireNonNull(value, "caCertificatePem is required"));
    }

    /**
     * The status of the CA certificate.
     * <p>
     * Valid values are "ACTIVE" and "INACTIVE".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStatus() {
        return software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the CA certificate.
     * <p>
     * Valid values are "ACTIVE" and "INACTIVE".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStatus(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "status", java.util.Objects.requireNonNull(value, "status is required"));
    }

    /**
     * Whether the CA certificate is configured for auto registration of device certificates.
     * <p>
     * Valid values are "ENABLE" and "DISABLE".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAutoRegistrationStatus() {
        return software.amazon.jsii.Kernel.get(this, "autoRegistrationStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Whether the CA certificate is configured for auto registration of device certificates.
     * <p>
     * Valid values are "ENABLE" and "DISABLE".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoRegistrationStatus(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "autoRegistrationStatus", value);
    }

    /**
     * The mode of the CA.
     * <p>
     * All the device certificates that are registered using this CA will be registered in the same mode as the CA. For more information about certificate mode for device certificates, see <a href="https://docs.aws.amazon.com//iot/latest/apireference/API_CertificateDescription.html#iot-Type-CertificateDescription-certificateMode">certificate mode</a> .
     * <p>
     * Valid values are "DEFAULT" and "SNI_ONLY".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCertificateMode() {
        return software.amazon.jsii.Kernel.get(this, "certificateMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The mode of the CA.
     * <p>
     * All the device certificates that are registered using this CA will be registered in the same mode as the CA. For more information about certificate mode for device certificates, see <a href="https://docs.aws.amazon.com//iot/latest/apireference/API_CertificateDescription.html#iot-Type-CertificateDescription-certificateMode">certificate mode</a> .
     * <p>
     * Valid values are "DEFAULT" and "SNI_ONLY".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificateMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "certificateMode", value);
    }

    /**
     * Information about the registration configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRegistrationConfig() {
        return software.amazon.jsii.Kernel.get(this, "registrationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about the registration configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRegistrationConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.CfnCACertificate.RegistrationConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "registrationConfig", value);
    }

    /**
     * Information about the registration configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRegistrationConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "registrationConfig", value);
    }

    /**
     * If true, removes auto registration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRemoveAutoRegistration() {
        return software.amazon.jsii.Kernel.get(this, "removeAutoRegistration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * If true, removes auto registration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRemoveAutoRegistration(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "removeAutoRegistration", value);
    }

    /**
     * If true, removes auto registration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRemoveAutoRegistration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "removeAutoRegistration", value);
    }

    /**
     * The private key verification certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVerificationCertificatePem() {
        return software.amazon.jsii.Kernel.get(this, "verificationCertificatePem", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The private key verification certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVerificationCertificatePem(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "verificationCertificatePem", value);
    }
    /**
     * The registration configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * RegistrationConfigProperty registrationConfigProperty = RegistrationConfigProperty.builder()
     *         .roleArn("roleArn")
     *         .templateBody("templateBody")
     *         .templateName("templateName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot.CfnCACertificate.RegistrationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(RegistrationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RegistrationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the role.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * The template body.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTemplateBody() {
            return null;
        }

        /**
         * The name of the provisioning template.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTemplateName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RegistrationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RegistrationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RegistrationConfigProperty> {
            java.lang.String roleArn;
            java.lang.String templateBody;
            java.lang.String templateName;

            /**
             * Sets the value of {@link RegistrationConfigProperty#getRoleArn}
             * @param roleArn The ARN of the role.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link RegistrationConfigProperty#getTemplateBody}
             * @param templateBody The template body.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateBody(java.lang.String templateBody) {
                this.templateBody = templateBody;
                return this;
            }

            /**
             * Sets the value of {@link RegistrationConfigProperty#getTemplateName}
             * @param templateName The name of the provisioning template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateName(java.lang.String templateName) {
                this.templateName = templateName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RegistrationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RegistrationConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RegistrationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RegistrationConfigProperty {
            private final java.lang.String roleArn;
            private final java.lang.String templateBody;
            private final java.lang.String templateName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.templateBody = software.amazon.jsii.Kernel.get(this, "templateBody", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.templateName = software.amazon.jsii.Kernel.get(this, "templateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = builder.roleArn;
                this.templateBody = builder.templateBody;
                this.templateName = builder.templateName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getTemplateBody() {
                return this.templateBody;
            }

            @Override
            public final java.lang.String getTemplateName() {
                return this.templateName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }
                if (this.getTemplateBody() != null) {
                    data.set("templateBody", om.valueToTree(this.getTemplateBody()));
                }
                if (this.getTemplateName() != null) {
                    data.set("templateName", om.valueToTree(this.getTemplateName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_iot.CfnCACertificate.RegistrationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RegistrationConfigProperty.Jsii$Proxy that = (RegistrationConfigProperty.Jsii$Proxy) o;

                if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
                if (this.templateBody != null ? !this.templateBody.equals(that.templateBody) : that.templateBody != null) return false;
                return this.templateName != null ? this.templateName.equals(that.templateName) : that.templateName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn != null ? this.roleArn.hashCode() : 0;
                result = 31 * result + (this.templateBody != null ? this.templateBody.hashCode() : 0);
                result = 31 * result + (this.templateName != null ? this.templateName.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iot.CfnCACertificate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iot.CfnCACertificate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iot.CfnCACertificateProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iot.CfnCACertificateProps.Builder();
        }

        /**
         * The certificate data in PEM format.
         * <p>
         * @return {@code this}
         * @param caCertificatePem The certificate data in PEM format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caCertificatePem(final java.lang.String caCertificatePem) {
            this.props.caCertificatePem(caCertificatePem);
            return this;
        }

        /**
         * The status of the CA certificate.
         * <p>
         * Valid values are "ACTIVE" and "INACTIVE".
         * <p>
         * @return {@code this}
         * @param status The status of the CA certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(final java.lang.String status) {
            this.props.status(status);
            return this;
        }

        /**
         * Whether the CA certificate is configured for auto registration of device certificates.
         * <p>
         * Valid values are "ENABLE" and "DISABLE".
         * <p>
         * @return {@code this}
         * @param autoRegistrationStatus Whether the CA certificate is configured for auto registration of device certificates. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoRegistrationStatus(final java.lang.String autoRegistrationStatus) {
            this.props.autoRegistrationStatus(autoRegistrationStatus);
            return this;
        }

        /**
         * The mode of the CA.
         * <p>
         * All the device certificates that are registered using this CA will be registered in the same mode as the CA. For more information about certificate mode for device certificates, see <a href="https://docs.aws.amazon.com//iot/latest/apireference/API_CertificateDescription.html#iot-Type-CertificateDescription-certificateMode">certificate mode</a> .
         * <p>
         * Valid values are "DEFAULT" and "SNI_ONLY".
         * <p>
         * @return {@code this}
         * @param certificateMode The mode of the CA. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateMode(final java.lang.String certificateMode) {
            this.props.certificateMode(certificateMode);
            return this;
        }

        /**
         * Information about the registration configuration.
         * <p>
         * @return {@code this}
         * @param registrationConfig Information about the registration configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder registrationConfig(final software.amazon.awscdk.services.iot.CfnCACertificate.RegistrationConfigProperty registrationConfig) {
            this.props.registrationConfig(registrationConfig);
            return this;
        }
        /**
         * Information about the registration configuration.
         * <p>
         * @return {@code this}
         * @param registrationConfig Information about the registration configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder registrationConfig(final software.amazon.awscdk.core.IResolvable registrationConfig) {
            this.props.registrationConfig(registrationConfig);
            return this;
        }

        /**
         * If true, removes auto registration.
         * <p>
         * @return {@code this}
         * @param removeAutoRegistration If true, removes auto registration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removeAutoRegistration(final java.lang.Boolean removeAutoRegistration) {
            this.props.removeAutoRegistration(removeAutoRegistration);
            return this;
        }
        /**
         * If true, removes auto registration.
         * <p>
         * @return {@code this}
         * @param removeAutoRegistration If true, removes auto registration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removeAutoRegistration(final software.amazon.awscdk.core.IResolvable removeAutoRegistration) {
            this.props.removeAutoRegistration(removeAutoRegistration);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The private key verification certificate.
         * <p>
         * @return {@code this}
         * @param verificationCertificatePem The private key verification certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder verificationCertificatePem(final java.lang.String verificationCertificatePem) {
            this.props.verificationCertificatePem(verificationCertificatePem);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iot.CfnCACertificate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iot.CfnCACertificate build() {
            return new software.amazon.awscdk.services.iot.CfnCACertificate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
