package software.amazon.awscdk.services.imagebuilder;

/**
 * A CloudFormation `AWS::ImageBuilder::DistributionConfiguration`.
 * <p>
 * A distribution configuration allows you to specify the name and description of your output AMI, authorize other AWS account s to launch the AMI, and replicate the AMI to other AWS Regions . It also allows you to export the AMI to Amazon S3 .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.imagebuilder.*;
 * Object amiDistributionConfiguration;
 * Object containerDistributionConfiguration;
 * CfnDistributionConfiguration cfnDistributionConfiguration = CfnDistributionConfiguration.Builder.create(this, "MyCfnDistributionConfiguration")
 *         .distributions(List.of(DistributionProperty.builder()
 *                 .region("region")
 *                 // the properties below are optional
 *                 .amiDistributionConfiguration(amiDistributionConfiguration)
 *                 .containerDistributionConfiguration(containerDistributionConfiguration)
 *                 .fastLaunchConfigurations(List.of(FastLaunchConfigurationProperty.builder()
 *                         .accountId("accountId")
 *                         .enabled(false)
 *                         .launchTemplate(FastLaunchLaunchTemplateSpecificationProperty.builder()
 *                                 .launchTemplateId("launchTemplateId")
 *                                 .launchTemplateName("launchTemplateName")
 *                                 .launchTemplateVersion("launchTemplateVersion")
 *                                 .build())
 *                         .maxParallelLaunches(123)
 *                         .snapshotConfiguration(FastLaunchSnapshotConfigurationProperty.builder()
 *                                 .targetResourceCount(123)
 *                                 .build())
 *                         .build()))
 *                 .launchTemplateConfigurations(List.of(LaunchTemplateConfigurationProperty.builder()
 *                         .accountId("accountId")
 *                         .launchTemplateId("launchTemplateId")
 *                         .setDefaultVersion(false)
 *                         .build()))
 *                 .licenseConfigurationArns(List.of("licenseConfigurationArns"))
 *                 .build()))
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:02.914Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_imagebuilder.CfnDistributionConfiguration")
public class CfnDistributionConfiguration extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnDistributionConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDistributionConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.imagebuilder.CfnDistributionConfiguration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ImageBuilder::DistributionConfiguration`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDistributionConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.imagebuilder.CfnDistributionConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the Amazon Resource Name (ARN) of this distribution configuration.
     * <p>
     * The following pattern is applied: <code>^arn:aws[^:]*:imagebuilder:[^:]+:(?:\d{12}|aws):(?:image-recipe|infrastructure-configuration|distribution-configuration|component|image|image-pipeline)/[a-z0-9-_]+(?:/(?:(?:x|\d+)\.(?:x|\d+)\.(?:x|\d+))(?:/\d+)?)?$</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the name of the distribution configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags of this distribution configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The distributions of this distribution configuration formatted as an array of Distribution objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDistributions() {
        return software.amazon.jsii.Kernel.get(this, "distributions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The distributions of this distribution configuration formatted as an array of Distribution objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDistributions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "distributions", java.util.Objects.requireNonNull(value, "distributions is required"));
    }

    /**
     * The distributions of this distribution configuration formatted as an array of Distribution objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDistributions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.imagebuilder.CfnDistributionConfiguration.DistributionProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.imagebuilder.CfnDistributionConfiguration.DistributionProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "distributions", java.util.Objects.requireNonNull(value, "distributions is required"));
    }

    /**
     * The name of this distribution configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of this distribution configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The description of this distribution configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of this distribution configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }
    /**
     * Define and configure the output AMIs of the pipeline.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * AmiDistributionConfigurationProperty amiDistributionConfigurationProperty = AmiDistributionConfigurationProperty.builder()
     *         .amiTags(Map.of(
     *                 "amiTagsKey", "amiTags"))
     *         .description("description")
     *         .kmsKeyId("kmsKeyId")
     *         .launchPermissionConfiguration(LaunchPermissionConfigurationProperty.builder()
     *                 .organizationalUnitArns(List.of("organizationalUnitArns"))
     *                 .organizationArns(List.of("organizationArns"))
     *                 .userGroups(List.of("userGroups"))
     *                 .userIds(List.of("userIds"))
     *                 .build())
     *         .name("name")
     *         .targetAccountIds(List.of("targetAccountIds"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_imagebuilder.CfnDistributionConfiguration.AmiDistributionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AmiDistributionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AmiDistributionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The tags to apply to AMIs distributed to this Region.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAmiTags() {
            return null;
        }

        /**
         * The description of the AMI distribution configuration.
         * <p>
         * Minimum and maximum length are in characters.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The KMS key identifier used to encrypt the distributed image.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * Launch permissions can be used to configure which AWS account s can use the AMI to launch instances.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLaunchPermissionConfiguration() {
            return null;
        }

        /**
         * The name of the output AMI.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The ID of an account to which you want to distribute an image.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTargetAccountIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AmiDistributionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AmiDistributionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AmiDistributionConfigurationProperty> {
            java.lang.Object amiTags;
            java.lang.String description;
            java.lang.String kmsKeyId;
            java.lang.Object launchPermissionConfiguration;
            java.lang.String name;
            java.util.List<java.lang.String> targetAccountIds;

            /**
             * Sets the value of {@link AmiDistributionConfigurationProperty#getAmiTags}
             * @param amiTags The tags to apply to AMIs distributed to this Region.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amiTags(software.amazon.awscdk.core.IResolvable amiTags) {
                this.amiTags = amiTags;
                return this;
            }

            /**
             * Sets the value of {@link AmiDistributionConfigurationProperty#getAmiTags}
             * @param amiTags The tags to apply to AMIs distributed to this Region.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amiTags(java.util.Map<java.lang.String, java.lang.String> amiTags) {
                this.amiTags = amiTags;
                return this;
            }

            /**
             * Sets the value of {@link AmiDistributionConfigurationProperty#getDescription}
             * @param description The description of the AMI distribution configuration.
             *                    Minimum and maximum length are in characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link AmiDistributionConfigurationProperty#getKmsKeyId}
             * @param kmsKeyId The KMS key identifier used to encrypt the distributed image.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link AmiDistributionConfigurationProperty#getLaunchPermissionConfiguration}
             * @param launchPermissionConfiguration Launch permissions can be used to configure which AWS account s can use the AMI to launch instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchPermissionConfiguration(software.amazon.awscdk.services.imagebuilder.CfnDistributionConfiguration.LaunchPermissionConfigurationProperty launchPermissionConfiguration) {
                this.launchPermissionConfiguration = launchPermissionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AmiDistributionConfigurationProperty#getLaunchPermissionConfiguration}
             * @param launchPermissionConfiguration Launch permissions can be used to configure which AWS account s can use the AMI to launch instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchPermissionConfiguration(software.amazon.awscdk.core.IResolvable launchPermissionConfiguration) {
                this.launchPermissionConfiguration = launchPermissionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AmiDistributionConfigurationProperty#getName}
             * @param name The name of the output AMI.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link AmiDistributionConfigurationProperty#getTargetAccountIds}
             * @param targetAccountIds The ID of an account to which you want to distribute an image.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetAccountIds(java.util.List<java.lang.String> targetAccountIds) {
                this.targetAccountIds = targetAccountIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AmiDistributionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AmiDistributionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AmiDistributionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AmiDistributionConfigurationProperty {
            private final java.lang.Object amiTags;
            private final java.lang.String description;
            private final java.lang.String kmsKeyId;
            private final java.lang.Object launchPermissionConfiguration;
            private final java.lang.String name;
            private final java.util.List<java.lang.String> targetAccountIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.amiTags = software.amazon.jsii.Kernel.get(this, "amiTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.launchPermissionConfiguration = software.amazon.jsii.Kernel.get(this, "launchPermissionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetAccountIds = software.amazon.jsii.Kernel.get(this, "targetAccountIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.amiTags = builder.amiTags;
                this.description = builder.description;
                this.kmsKeyId = builder.kmsKeyId;
                this.launchPermissionConfiguration = builder.launchPermissionConfiguration;
                this.name = builder.name;
                this.targetAccountIds = builder.targetAccountIds;
            }

            @Override
            public final java.lang.Object getAmiTags() {
                return this.amiTags;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public final java.lang.Object getLaunchPermissionConfiguration() {
                return this.launchPermissionConfiguration;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.util.List<java.lang.String> getTargetAccountIds() {
                return this.targetAccountIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAmiTags() != null) {
                    data.set("amiTags", om.valueToTree(this.getAmiTags()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }
                if (this.getLaunchPermissionConfiguration() != null) {
                    data.set("launchPermissionConfiguration", om.valueToTree(this.getLaunchPermissionConfiguration()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getTargetAccountIds() != null) {
                    data.set("targetAccountIds", om.valueToTree(this.getTargetAccountIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_imagebuilder.CfnDistributionConfiguration.AmiDistributionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AmiDistributionConfigurationProperty.Jsii$Proxy that = (AmiDistributionConfigurationProperty.Jsii$Proxy) o;

                if (this.amiTags != null ? !this.amiTags.equals(that.amiTags) : that.amiTags != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
                if (this.launchPermissionConfiguration != null ? !this.launchPermissionConfiguration.equals(that.launchPermissionConfiguration) : that.launchPermissionConfiguration != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.targetAccountIds != null ? this.targetAccountIds.equals(that.targetAccountIds) : that.targetAccountIds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.amiTags != null ? this.amiTags.hashCode() : 0;
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                result = 31 * result + (this.launchPermissionConfiguration != null ? this.launchPermissionConfiguration.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.targetAccountIds != null ? this.targetAccountIds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Container distribution settings for encryption, licensing, and sharing in a specific Region.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * ContainerDistributionConfigurationProperty containerDistributionConfigurationProperty = ContainerDistributionConfigurationProperty.builder()
     *         .containerTags(List.of("containerTags"))
     *         .description("description")
     *         .targetRepository(TargetContainerRepositoryProperty.builder()
     *                 .repositoryName("repositoryName")
     *                 .service("service")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_imagebuilder.CfnDistributionConfiguration.ContainerDistributionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ContainerDistributionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContainerDistributionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Tags that are attached to the container distribution configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getContainerTags() {
            return null;
        }

        /**
         * The description of the container distribution configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The destination repository for the container distribution configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetRepository() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ContainerDistributionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContainerDistributionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContainerDistributionConfigurationProperty> {
            java.util.List<java.lang.String> containerTags;
            java.lang.String description;
            java.lang.Object targetRepository;

            /**
             * Sets the value of {@link ContainerDistributionConfigurationProperty#getContainerTags}
             * @param containerTags Tags that are attached to the container distribution configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerTags(java.util.List<java.lang.String> containerTags) {
                this.containerTags = containerTags;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDistributionConfigurationProperty#getDescription}
             * @param description The description of the container distribution configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDistributionConfigurationProperty#getTargetRepository}
             * @param targetRepository The destination repository for the container distribution configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetRepository(software.amazon.awscdk.services.imagebuilder.CfnDistributionConfiguration.TargetContainerRepositoryProperty targetRepository) {
                this.targetRepository = targetRepository;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDistributionConfigurationProperty#getTargetRepository}
             * @param targetRepository The destination repository for the container distribution configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetRepository(software.amazon.awscdk.core.IResolvable targetRepository) {
                this.targetRepository = targetRepository;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContainerDistributionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContainerDistributionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContainerDistributionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerDistributionConfigurationProperty {
            private final java.util.List<java.lang.String> containerTags;
            private final java.lang.String description;
            private final java.lang.Object targetRepository;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerTags = software.amazon.jsii.Kernel.get(this, "containerTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetRepository = software.amazon.jsii.Kernel.get(this, "targetRepository", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerTags = builder.containerTags;
                this.description = builder.description;
                this.targetRepository = builder.targetRepository;
            }

            @Override
            public final java.util.List<java.lang.String> getContainerTags() {
                return this.containerTags;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getTargetRepository() {
                return this.targetRepository;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainerTags() != null) {
                    data.set("containerTags", om.valueToTree(this.getContainerTags()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getTargetRepository() != null) {
                    data.set("targetRepository", om.valueToTree(this.getTargetRepository()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_imagebuilder.CfnDistributionConfiguration.ContainerDistributionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContainerDistributionConfigurationProperty.Jsii$Proxy that = (ContainerDistributionConfigurationProperty.Jsii$Proxy) o;

                if (this.containerTags != null ? !this.containerTags.equals(that.containerTags) : that.containerTags != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                return this.targetRepository != null ? this.targetRepository.equals(that.targetRepository) : that.targetRepository == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerTags != null ? this.containerTags.hashCode() : 0;
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.targetRepository != null ? this.targetRepository.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The distribution configuration distribution defines the settings for a specific Region in the Distribution Configuration.
     * <p>
     * You must specify whether the distribution is for an AMI or a container image. To do so, include exactly one of the following data types for your distribution:
     * <p>
     * <ul>
     * <li>amiDistributionConfiguration</li>
     * <li>containerDistributionConfiguration</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * Object amiDistributionConfiguration;
     * Object containerDistributionConfiguration;
     * DistributionProperty distributionProperty = DistributionProperty.builder()
     *         .region("region")
     *         // the properties below are optional
     *         .amiDistributionConfiguration(amiDistributionConfiguration)
     *         .containerDistributionConfiguration(containerDistributionConfiguration)
     *         .fastLaunchConfigurations(List.of(FastLaunchConfigurationProperty.builder()
     *                 .accountId("accountId")
     *                 .enabled(false)
     *                 .launchTemplate(FastLaunchLaunchTemplateSpecificationProperty.builder()
     *                         .launchTemplateId("launchTemplateId")
     *                         .launchTemplateName("launchTemplateName")
     *                         .launchTemplateVersion("launchTemplateVersion")
     *                         .build())
     *                 .maxParallelLaunches(123)
     *                 .snapshotConfiguration(FastLaunchSnapshotConfigurationProperty.builder()
     *                         .targetResourceCount(123)
     *                         .build())
     *                 .build()))
     *         .launchTemplateConfigurations(List.of(LaunchTemplateConfigurationProperty.builder()
     *                 .accountId("accountId")
     *                 .launchTemplateId("launchTemplateId")
     *                 .setDefaultVersion(false)
     *                 .build()))
     *         .licenseConfigurationArns(List.of("licenseConfigurationArns"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_imagebuilder.CfnDistributionConfiguration.DistributionProperty")
    @software.amazon.jsii.Jsii.Proxy(DistributionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DistributionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The target Region for the Distribution Configuration.
         * <p>
         * For example, <code>eu-west-1</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRegion();

        /**
         * The specific AMI settings, such as launch permissions and AMI tags.
         * <p>
         * For details, see example schema below.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAmiDistributionConfiguration() {
            return null;
        }

        /**
         * Container distribution settings for encryption, licensing, and sharing in a specific Region.
         * <p>
         * For details, see example schema below.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainerDistributionConfiguration() {
            return null;
        }

        /**
         * The Windows faster-launching configurations to use for AMI distribution.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFastLaunchConfigurations() {
            return null;
        }

        /**
         * A group of launchTemplateConfiguration settings that apply to image distribution for specified accounts.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLaunchTemplateConfigurations() {
            return null;
        }

        /**
         * The License Manager Configuration to associate with the AMI in the specified Region.
         * <p>
         * For more information, see the <a href="https://docs.aws.amazon.com/license-manager/latest/APIReference/API_LicenseConfiguration.html">LicenseConfiguration API</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLicenseConfigurationArns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DistributionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DistributionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DistributionProperty> {
            java.lang.String region;
            java.lang.Object amiDistributionConfiguration;
            java.lang.Object containerDistributionConfiguration;
            java.lang.Object fastLaunchConfigurations;
            java.lang.Object launchTemplateConfigurations;
            java.util.List<java.lang.String> licenseConfigurationArns;

            /**
             * Sets the value of {@link DistributionProperty#getRegion}
             * @param region The target Region for the Distribution Configuration. This parameter is required.
             *               For example, <code>eu-west-1</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Sets the value of {@link DistributionProperty#getAmiDistributionConfiguration}
             * @param amiDistributionConfiguration The specific AMI settings, such as launch permissions and AMI tags.
             *                                     For details, see example schema below.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amiDistributionConfiguration(java.lang.Object amiDistributionConfiguration) {
                this.amiDistributionConfiguration = amiDistributionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DistributionProperty#getContainerDistributionConfiguration}
             * @param containerDistributionConfiguration Container distribution settings for encryption, licensing, and sharing in a specific Region.
             *                                           For details, see example schema below.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerDistributionConfiguration(java.lang.Object containerDistributionConfiguration) {
                this.containerDistributionConfiguration = containerDistributionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DistributionProperty#getFastLaunchConfigurations}
             * @param fastLaunchConfigurations The Windows faster-launching configurations to use for AMI distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fastLaunchConfigurations(software.amazon.awscdk.core.IResolvable fastLaunchConfigurations) {
                this.fastLaunchConfigurations = fastLaunchConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link DistributionProperty#getFastLaunchConfigurations}
             * @param fastLaunchConfigurations The Windows faster-launching configurations to use for AMI distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fastLaunchConfigurations(java.util.List<? extends java.lang.Object> fastLaunchConfigurations) {
                this.fastLaunchConfigurations = fastLaunchConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link DistributionProperty#getLaunchTemplateConfigurations}
             * @param launchTemplateConfigurations A group of launchTemplateConfiguration settings that apply to image distribution for specified accounts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateConfigurations(software.amazon.awscdk.core.IResolvable launchTemplateConfigurations) {
                this.launchTemplateConfigurations = launchTemplateConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link DistributionProperty#getLaunchTemplateConfigurations}
             * @param launchTemplateConfigurations A group of launchTemplateConfiguration settings that apply to image distribution for specified accounts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateConfigurations(java.util.List<? extends java.lang.Object> launchTemplateConfigurations) {
                this.launchTemplateConfigurations = launchTemplateConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link DistributionProperty#getLicenseConfigurationArns}
             * @param licenseConfigurationArns The License Manager Configuration to associate with the AMI in the specified Region.
             *                                 For more information, see the <a href="https://docs.aws.amazon.com/license-manager/latest/APIReference/API_LicenseConfiguration.html">LicenseConfiguration API</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder licenseConfigurationArns(java.util.List<java.lang.String> licenseConfigurationArns) {
                this.licenseConfigurationArns = licenseConfigurationArns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DistributionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DistributionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DistributionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DistributionProperty {
            private final java.lang.String region;
            private final java.lang.Object amiDistributionConfiguration;
            private final java.lang.Object containerDistributionConfiguration;
            private final java.lang.Object fastLaunchConfigurations;
            private final java.lang.Object launchTemplateConfigurations;
            private final java.util.List<java.lang.String> licenseConfigurationArns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.amiDistributionConfiguration = software.amazon.jsii.Kernel.get(this, "amiDistributionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.containerDistributionConfiguration = software.amazon.jsii.Kernel.get(this, "containerDistributionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fastLaunchConfigurations = software.amazon.jsii.Kernel.get(this, "fastLaunchConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.launchTemplateConfigurations = software.amazon.jsii.Kernel.get(this, "launchTemplateConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.licenseConfigurationArns = software.amazon.jsii.Kernel.get(this, "licenseConfigurationArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.region = java.util.Objects.requireNonNull(builder.region, "region is required");
                this.amiDistributionConfiguration = builder.amiDistributionConfiguration;
                this.containerDistributionConfiguration = builder.containerDistributionConfiguration;
                this.fastLaunchConfigurations = builder.fastLaunchConfigurations;
                this.launchTemplateConfigurations = builder.launchTemplateConfigurations;
                this.licenseConfigurationArns = builder.licenseConfigurationArns;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            public final java.lang.Object getAmiDistributionConfiguration() {
                return this.amiDistributionConfiguration;
            }

            @Override
            public final java.lang.Object getContainerDistributionConfiguration() {
                return this.containerDistributionConfiguration;
            }

            @Override
            public final java.lang.Object getFastLaunchConfigurations() {
                return this.fastLaunchConfigurations;
            }

            @Override
            public final java.lang.Object getLaunchTemplateConfigurations() {
                return this.launchTemplateConfigurations;
            }

            @Override
            public final java.util.List<java.lang.String> getLicenseConfigurationArns() {
                return this.licenseConfigurationArns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("region", om.valueToTree(this.getRegion()));
                if (this.getAmiDistributionConfiguration() != null) {
                    data.set("amiDistributionConfiguration", om.valueToTree(this.getAmiDistributionConfiguration()));
                }
                if (this.getContainerDistributionConfiguration() != null) {
                    data.set("containerDistributionConfiguration", om.valueToTree(this.getContainerDistributionConfiguration()));
                }
                if (this.getFastLaunchConfigurations() != null) {
                    data.set("fastLaunchConfigurations", om.valueToTree(this.getFastLaunchConfigurations()));
                }
                if (this.getLaunchTemplateConfigurations() != null) {
                    data.set("launchTemplateConfigurations", om.valueToTree(this.getLaunchTemplateConfigurations()));
                }
                if (this.getLicenseConfigurationArns() != null) {
                    data.set("licenseConfigurationArns", om.valueToTree(this.getLicenseConfigurationArns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_imagebuilder.CfnDistributionConfiguration.DistributionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DistributionProperty.Jsii$Proxy that = (DistributionProperty.Jsii$Proxy) o;

                if (!region.equals(that.region)) return false;
                if (this.amiDistributionConfiguration != null ? !this.amiDistributionConfiguration.equals(that.amiDistributionConfiguration) : that.amiDistributionConfiguration != null) return false;
                if (this.containerDistributionConfiguration != null ? !this.containerDistributionConfiguration.equals(that.containerDistributionConfiguration) : that.containerDistributionConfiguration != null) return false;
                if (this.fastLaunchConfigurations != null ? !this.fastLaunchConfigurations.equals(that.fastLaunchConfigurations) : that.fastLaunchConfigurations != null) return false;
                if (this.launchTemplateConfigurations != null ? !this.launchTemplateConfigurations.equals(that.launchTemplateConfigurations) : that.launchTemplateConfigurations != null) return false;
                return this.licenseConfigurationArns != null ? this.licenseConfigurationArns.equals(that.licenseConfigurationArns) : that.licenseConfigurationArns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.region.hashCode();
                result = 31 * result + (this.amiDistributionConfiguration != null ? this.amiDistributionConfiguration.hashCode() : 0);
                result = 31 * result + (this.containerDistributionConfiguration != null ? this.containerDistributionConfiguration.hashCode() : 0);
                result = 31 * result + (this.fastLaunchConfigurations != null ? this.fastLaunchConfigurations.hashCode() : 0);
                result = 31 * result + (this.launchTemplateConfigurations != null ? this.launchTemplateConfigurations.hashCode() : 0);
                result = 31 * result + (this.licenseConfigurationArns != null ? this.licenseConfigurationArns.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Define and configure faster launching for output Windows AMIs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * FastLaunchConfigurationProperty fastLaunchConfigurationProperty = FastLaunchConfigurationProperty.builder()
     *         .accountId("accountId")
     *         .enabled(false)
     *         .launchTemplate(FastLaunchLaunchTemplateSpecificationProperty.builder()
     *                 .launchTemplateId("launchTemplateId")
     *                 .launchTemplateName("launchTemplateName")
     *                 .launchTemplateVersion("launchTemplateVersion")
     *                 .build())
     *         .maxParallelLaunches(123)
     *         .snapshotConfiguration(FastLaunchSnapshotConfigurationProperty.builder()
     *                 .targetResourceCount(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_imagebuilder.CfnDistributionConfiguration.FastLaunchConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FastLaunchConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FastLaunchConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The owner account ID for the fast-launch enabled Windows AMI.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccountId() {
            return null;
        }

        /**
         * A Boolean that represents the current state of faster launching for the Windows AMI.
         * <p>
         * Set to <code>true</code> to start using Windows faster launching, or <code>false</code> to stop using it.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The launch template that the fast-launch enabled Windows AMI uses when it launches Windows instances to create pre-provisioned snapshots.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLaunchTemplate() {
            return null;
        }

        /**
         * The maximum number of parallel instances that are launched for creating resources.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxParallelLaunches() {
            return null;
        }

        /**
         * Configuration settings for managing the number of snapshots that are created from pre-provisioned instances for the Windows AMI when faster launching is enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSnapshotConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FastLaunchConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FastLaunchConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FastLaunchConfigurationProperty> {
            java.lang.String accountId;
            java.lang.Object enabled;
            java.lang.Object launchTemplate;
            java.lang.Number maxParallelLaunches;
            java.lang.Object snapshotConfiguration;

            /**
             * Sets the value of {@link FastLaunchConfigurationProperty#getAccountId}
             * @param accountId The owner account ID for the fast-launch enabled Windows AMI.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accountId(java.lang.String accountId) {
                this.accountId = accountId;
                return this;
            }

            /**
             * Sets the value of {@link FastLaunchConfigurationProperty#getEnabled}
             * @param enabled A Boolean that represents the current state of faster launching for the Windows AMI.
             *                Set to <code>true</code> to start using Windows faster launching, or <code>false</code> to stop using it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link FastLaunchConfigurationProperty#getEnabled}
             * @param enabled A Boolean that represents the current state of faster launching for the Windows AMI.
             *                Set to <code>true</code> to start using Windows faster launching, or <code>false</code> to stop using it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link FastLaunchConfigurationProperty#getLaunchTemplate}
             * @param launchTemplate The launch template that the fast-launch enabled Windows AMI uses when it launches Windows instances to create pre-provisioned snapshots.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplate(software.amazon.awscdk.services.imagebuilder.CfnDistributionConfiguration.FastLaunchLaunchTemplateSpecificationProperty launchTemplate) {
                this.launchTemplate = launchTemplate;
                return this;
            }

            /**
             * Sets the value of {@link FastLaunchConfigurationProperty#getLaunchTemplate}
             * @param launchTemplate The launch template that the fast-launch enabled Windows AMI uses when it launches Windows instances to create pre-provisioned snapshots.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplate(software.amazon.awscdk.core.IResolvable launchTemplate) {
                this.launchTemplate = launchTemplate;
                return this;
            }

            /**
             * Sets the value of {@link FastLaunchConfigurationProperty#getMaxParallelLaunches}
             * @param maxParallelLaunches The maximum number of parallel instances that are launched for creating resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxParallelLaunches(java.lang.Number maxParallelLaunches) {
                this.maxParallelLaunches = maxParallelLaunches;
                return this;
            }

            /**
             * Sets the value of {@link FastLaunchConfigurationProperty#getSnapshotConfiguration}
             * @param snapshotConfiguration Configuration settings for managing the number of snapshots that are created from pre-provisioned instances for the Windows AMI when faster launching is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotConfiguration(software.amazon.awscdk.services.imagebuilder.CfnDistributionConfiguration.FastLaunchSnapshotConfigurationProperty snapshotConfiguration) {
                this.snapshotConfiguration = snapshotConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link FastLaunchConfigurationProperty#getSnapshotConfiguration}
             * @param snapshotConfiguration Configuration settings for managing the number of snapshots that are created from pre-provisioned instances for the Windows AMI when faster launching is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotConfiguration(software.amazon.awscdk.core.IResolvable snapshotConfiguration) {
                this.snapshotConfiguration = snapshotConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FastLaunchConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FastLaunchConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FastLaunchConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FastLaunchConfigurationProperty {
            private final java.lang.String accountId;
            private final java.lang.Object enabled;
            private final java.lang.Object launchTemplate;
            private final java.lang.Number maxParallelLaunches;
            private final java.lang.Object snapshotConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accountId = software.amazon.jsii.Kernel.get(this, "accountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.launchTemplate = software.amazon.jsii.Kernel.get(this, "launchTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxParallelLaunches = software.amazon.jsii.Kernel.get(this, "maxParallelLaunches", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.snapshotConfiguration = software.amazon.jsii.Kernel.get(this, "snapshotConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accountId = builder.accountId;
                this.enabled = builder.enabled;
                this.launchTemplate = builder.launchTemplate;
                this.maxParallelLaunches = builder.maxParallelLaunches;
                this.snapshotConfiguration = builder.snapshotConfiguration;
            }

            @Override
            public final java.lang.String getAccountId() {
                return this.accountId;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getLaunchTemplate() {
                return this.launchTemplate;
            }

            @Override
            public final java.lang.Number getMaxParallelLaunches() {
                return this.maxParallelLaunches;
            }

            @Override
            public final java.lang.Object getSnapshotConfiguration() {
                return this.snapshotConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccountId() != null) {
                    data.set("accountId", om.valueToTree(this.getAccountId()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getLaunchTemplate() != null) {
                    data.set("launchTemplate", om.valueToTree(this.getLaunchTemplate()));
                }
                if (this.getMaxParallelLaunches() != null) {
                    data.set("maxParallelLaunches", om.valueToTree(this.getMaxParallelLaunches()));
                }
                if (this.getSnapshotConfiguration() != null) {
                    data.set("snapshotConfiguration", om.valueToTree(this.getSnapshotConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_imagebuilder.CfnDistributionConfiguration.FastLaunchConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FastLaunchConfigurationProperty.Jsii$Proxy that = (FastLaunchConfigurationProperty.Jsii$Proxy) o;

                if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) return false;
                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.launchTemplate != null ? !this.launchTemplate.equals(that.launchTemplate) : that.launchTemplate != null) return false;
                if (this.maxParallelLaunches != null ? !this.maxParallelLaunches.equals(that.maxParallelLaunches) : that.maxParallelLaunches != null) return false;
                return this.snapshotConfiguration != null ? this.snapshotConfiguration.equals(that.snapshotConfiguration) : that.snapshotConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accountId != null ? this.accountId.hashCode() : 0;
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                result = 31 * result + (this.launchTemplate != null ? this.launchTemplate.hashCode() : 0);
                result = 31 * result + (this.maxParallelLaunches != null ? this.maxParallelLaunches.hashCode() : 0);
                result = 31 * result + (this.snapshotConfiguration != null ? this.snapshotConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Identifies the launch template that the associated Windows AMI uses for launching an instance when faster launching is enabled.
     * <p>
     * <blockquote>
     * <p>
     * You can specify either the <code>launchTemplateName</code> or the <code>launchTemplateId</code> , but not both.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * FastLaunchLaunchTemplateSpecificationProperty fastLaunchLaunchTemplateSpecificationProperty = FastLaunchLaunchTemplateSpecificationProperty.builder()
     *         .launchTemplateId("launchTemplateId")
     *         .launchTemplateName("launchTemplateName")
     *         .launchTemplateVersion("launchTemplateVersion")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_imagebuilder.CfnDistributionConfiguration.FastLaunchLaunchTemplateSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(FastLaunchLaunchTemplateSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FastLaunchLaunchTemplateSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the launch template to use for faster launching for a Windows AMI.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateId() {
            return null;
        }

        /**
         * The name of the launch template to use for faster launching for a Windows AMI.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateName() {
            return null;
        }

        /**
         * The version of the launch template to use for faster launching for a Windows AMI.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FastLaunchLaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FastLaunchLaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FastLaunchLaunchTemplateSpecificationProperty> {
            java.lang.String launchTemplateId;
            java.lang.String launchTemplateName;
            java.lang.String launchTemplateVersion;

            /**
             * Sets the value of {@link FastLaunchLaunchTemplateSpecificationProperty#getLaunchTemplateId}
             * @param launchTemplateId The ID of the launch template to use for faster launching for a Windows AMI.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateId(java.lang.String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            /**
             * Sets the value of {@link FastLaunchLaunchTemplateSpecificationProperty#getLaunchTemplateName}
             * @param launchTemplateName The name of the launch template to use for faster launching for a Windows AMI.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateName(java.lang.String launchTemplateName) {
                this.launchTemplateName = launchTemplateName;
                return this;
            }

            /**
             * Sets the value of {@link FastLaunchLaunchTemplateSpecificationProperty#getLaunchTemplateVersion}
             * @param launchTemplateVersion The version of the launch template to use for faster launching for a Windows AMI.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateVersion(java.lang.String launchTemplateVersion) {
                this.launchTemplateVersion = launchTemplateVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FastLaunchLaunchTemplateSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FastLaunchLaunchTemplateSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FastLaunchLaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FastLaunchLaunchTemplateSpecificationProperty {
            private final java.lang.String launchTemplateId;
            private final java.lang.String launchTemplateName;
            private final java.lang.String launchTemplateVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.launchTemplateId = software.amazon.jsii.Kernel.get(this, "launchTemplateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.launchTemplateName = software.amazon.jsii.Kernel.get(this, "launchTemplateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.launchTemplateVersion = software.amazon.jsii.Kernel.get(this, "launchTemplateVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.launchTemplateId = builder.launchTemplateId;
                this.launchTemplateName = builder.launchTemplateName;
                this.launchTemplateVersion = builder.launchTemplateVersion;
            }

            @Override
            public final java.lang.String getLaunchTemplateId() {
                return this.launchTemplateId;
            }

            @Override
            public final java.lang.String getLaunchTemplateName() {
                return this.launchTemplateName;
            }

            @Override
            public final java.lang.String getLaunchTemplateVersion() {
                return this.launchTemplateVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLaunchTemplateId() != null) {
                    data.set("launchTemplateId", om.valueToTree(this.getLaunchTemplateId()));
                }
                if (this.getLaunchTemplateName() != null) {
                    data.set("launchTemplateName", om.valueToTree(this.getLaunchTemplateName()));
                }
                if (this.getLaunchTemplateVersion() != null) {
                    data.set("launchTemplateVersion", om.valueToTree(this.getLaunchTemplateVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_imagebuilder.CfnDistributionConfiguration.FastLaunchLaunchTemplateSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FastLaunchLaunchTemplateSpecificationProperty.Jsii$Proxy that = (FastLaunchLaunchTemplateSpecificationProperty.Jsii$Proxy) o;

                if (this.launchTemplateId != null ? !this.launchTemplateId.equals(that.launchTemplateId) : that.launchTemplateId != null) return false;
                if (this.launchTemplateName != null ? !this.launchTemplateName.equals(that.launchTemplateName) : that.launchTemplateName != null) return false;
                return this.launchTemplateVersion != null ? this.launchTemplateVersion.equals(that.launchTemplateVersion) : that.launchTemplateVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.launchTemplateId != null ? this.launchTemplateId.hashCode() : 0;
                result = 31 * result + (this.launchTemplateName != null ? this.launchTemplateName.hashCode() : 0);
                result = 31 * result + (this.launchTemplateVersion != null ? this.launchTemplateVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration settings for creating and managing pre-provisioned snapshots for a fast-launch enabled Windows AMI.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * FastLaunchSnapshotConfigurationProperty fastLaunchSnapshotConfigurationProperty = FastLaunchSnapshotConfigurationProperty.builder()
     *         .targetResourceCount(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_imagebuilder.CfnDistributionConfiguration.FastLaunchSnapshotConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FastLaunchSnapshotConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FastLaunchSnapshotConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of pre-provisioned snapshots to keep on hand for a fast-launch enabled Windows AMI.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTargetResourceCount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FastLaunchSnapshotConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FastLaunchSnapshotConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FastLaunchSnapshotConfigurationProperty> {
            java.lang.Number targetResourceCount;

            /**
             * Sets the value of {@link FastLaunchSnapshotConfigurationProperty#getTargetResourceCount}
             * @param targetResourceCount The number of pre-provisioned snapshots to keep on hand for a fast-launch enabled Windows AMI.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetResourceCount(java.lang.Number targetResourceCount) {
                this.targetResourceCount = targetResourceCount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FastLaunchSnapshotConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FastLaunchSnapshotConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FastLaunchSnapshotConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FastLaunchSnapshotConfigurationProperty {
            private final java.lang.Number targetResourceCount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetResourceCount = software.amazon.jsii.Kernel.get(this, "targetResourceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetResourceCount = builder.targetResourceCount;
            }

            @Override
            public final java.lang.Number getTargetResourceCount() {
                return this.targetResourceCount;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTargetResourceCount() != null) {
                    data.set("targetResourceCount", om.valueToTree(this.getTargetResourceCount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_imagebuilder.CfnDistributionConfiguration.FastLaunchSnapshotConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FastLaunchSnapshotConfigurationProperty.Jsii$Proxy that = (FastLaunchSnapshotConfigurationProperty.Jsii$Proxy) o;

                return this.targetResourceCount != null ? this.targetResourceCount.equals(that.targetResourceCount) : that.targetResourceCount == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetResourceCount != null ? this.targetResourceCount.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes the configuration for a launch permission.
     * <p>
     * The launch permission modification request is sent to the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyImageAttribute.html">Amazon EC2 ModifyImageAttribute</a> API on behalf of the user for each Region they have selected to distribute the AMI. To make an AMI public, set the launch permission authorized accounts to <code>all</code> . See the examples for making an AMI public at <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyImageAttribute.html">Amazon EC2 ModifyImageAttribute</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * LaunchPermissionConfigurationProperty launchPermissionConfigurationProperty = LaunchPermissionConfigurationProperty.builder()
     *         .organizationalUnitArns(List.of("organizationalUnitArns"))
     *         .organizationArns(List.of("organizationArns"))
     *         .userGroups(List.of("userGroups"))
     *         .userIds(List.of("userIds"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_imagebuilder.CfnDistributionConfiguration.LaunchPermissionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LaunchPermissionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LaunchPermissionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN for an AWS Organizations organizational unit (OU) that you want to share your AMI with.
         * <p>
         * For more information about key concepts for AWS Organizations , see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html">AWS Organizations terminology and concepts</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOrganizationalUnitArns() {
            return null;
        }

        /**
         * The ARN for an AWS Organization that you want to share your AMI with.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What is AWS Organizations ?</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOrganizationArns() {
            return null;
        }

        /**
         * The name of the group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getUserGroups() {
            return null;
        }

        /**
         * The AWS account ID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getUserIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LaunchPermissionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LaunchPermissionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LaunchPermissionConfigurationProperty> {
            java.util.List<java.lang.String> organizationalUnitArns;
            java.util.List<java.lang.String> organizationArns;
            java.util.List<java.lang.String> userGroups;
            java.util.List<java.lang.String> userIds;

            /**
             * Sets the value of {@link LaunchPermissionConfigurationProperty#getOrganizationalUnitArns}
             * @param organizationalUnitArns The ARN for an AWS Organizations organizational unit (OU) that you want to share your AMI with.
             *                               For more information about key concepts for AWS Organizations , see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html">AWS Organizations terminology and concepts</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder organizationalUnitArns(java.util.List<java.lang.String> organizationalUnitArns) {
                this.organizationalUnitArns = organizationalUnitArns;
                return this;
            }

            /**
             * Sets the value of {@link LaunchPermissionConfigurationProperty#getOrganizationArns}
             * @param organizationArns The ARN for an AWS Organization that you want to share your AMI with.
             *                         For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What is AWS Organizations ?</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder organizationArns(java.util.List<java.lang.String> organizationArns) {
                this.organizationArns = organizationArns;
                return this;
            }

            /**
             * Sets the value of {@link LaunchPermissionConfigurationProperty#getUserGroups}
             * @param userGroups The name of the group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userGroups(java.util.List<java.lang.String> userGroups) {
                this.userGroups = userGroups;
                return this;
            }

            /**
             * Sets the value of {@link LaunchPermissionConfigurationProperty#getUserIds}
             * @param userIds The AWS account ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userIds(java.util.List<java.lang.String> userIds) {
                this.userIds = userIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchPermissionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LaunchPermissionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LaunchPermissionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchPermissionConfigurationProperty {
            private final java.util.List<java.lang.String> organizationalUnitArns;
            private final java.util.List<java.lang.String> organizationArns;
            private final java.util.List<java.lang.String> userGroups;
            private final java.util.List<java.lang.String> userIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.organizationalUnitArns = software.amazon.jsii.Kernel.get(this, "organizationalUnitArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.organizationArns = software.amazon.jsii.Kernel.get(this, "organizationArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.userGroups = software.amazon.jsii.Kernel.get(this, "userGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.userIds = software.amazon.jsii.Kernel.get(this, "userIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.organizationalUnitArns = builder.organizationalUnitArns;
                this.organizationArns = builder.organizationArns;
                this.userGroups = builder.userGroups;
                this.userIds = builder.userIds;
            }

            @Override
            public final java.util.List<java.lang.String> getOrganizationalUnitArns() {
                return this.organizationalUnitArns;
            }

            @Override
            public final java.util.List<java.lang.String> getOrganizationArns() {
                return this.organizationArns;
            }

            @Override
            public final java.util.List<java.lang.String> getUserGroups() {
                return this.userGroups;
            }

            @Override
            public final java.util.List<java.lang.String> getUserIds() {
                return this.userIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOrganizationalUnitArns() != null) {
                    data.set("organizationalUnitArns", om.valueToTree(this.getOrganizationalUnitArns()));
                }
                if (this.getOrganizationArns() != null) {
                    data.set("organizationArns", om.valueToTree(this.getOrganizationArns()));
                }
                if (this.getUserGroups() != null) {
                    data.set("userGroups", om.valueToTree(this.getUserGroups()));
                }
                if (this.getUserIds() != null) {
                    data.set("userIds", om.valueToTree(this.getUserIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_imagebuilder.CfnDistributionConfiguration.LaunchPermissionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LaunchPermissionConfigurationProperty.Jsii$Proxy that = (LaunchPermissionConfigurationProperty.Jsii$Proxy) o;

                if (this.organizationalUnitArns != null ? !this.organizationalUnitArns.equals(that.organizationalUnitArns) : that.organizationalUnitArns != null) return false;
                if (this.organizationArns != null ? !this.organizationArns.equals(that.organizationArns) : that.organizationArns != null) return false;
                if (this.userGroups != null ? !this.userGroups.equals(that.userGroups) : that.userGroups != null) return false;
                return this.userIds != null ? this.userIds.equals(that.userIds) : that.userIds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.organizationalUnitArns != null ? this.organizationalUnitArns.hashCode() : 0;
                result = 31 * result + (this.organizationArns != null ? this.organizationArns.hashCode() : 0);
                result = 31 * result + (this.userGroups != null ? this.userGroups.hashCode() : 0);
                result = 31 * result + (this.userIds != null ? this.userIds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Identifies an Amazon EC2 launch template to use for a specific account.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * LaunchTemplateConfigurationProperty launchTemplateConfigurationProperty = LaunchTemplateConfigurationProperty.builder()
     *         .accountId("accountId")
     *         .launchTemplateId("launchTemplateId")
     *         .setDefaultVersion(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_imagebuilder.CfnDistributionConfiguration.LaunchTemplateConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LaunchTemplateConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LaunchTemplateConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The account ID that this configuration applies to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccountId() {
            return null;
        }

        /**
         * Identifies the Amazon EC2 launch template to use.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateId() {
            return null;
        }

        /**
         * Set the specified Amazon EC2 launch template as the default launch template for the specified account.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSetDefaultVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LaunchTemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LaunchTemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LaunchTemplateConfigurationProperty> {
            java.lang.String accountId;
            java.lang.String launchTemplateId;
            java.lang.Object setDefaultVersion;

            /**
             * Sets the value of {@link LaunchTemplateConfigurationProperty#getAccountId}
             * @param accountId The account ID that this configuration applies to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accountId(java.lang.String accountId) {
                this.accountId = accountId;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateConfigurationProperty#getLaunchTemplateId}
             * @param launchTemplateId Identifies the Amazon EC2 launch template to use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateId(java.lang.String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateConfigurationProperty#getSetDefaultVersion}
             * @param setDefaultVersion Set the specified Amazon EC2 launch template as the default launch template for the specified account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder setDefaultVersion(java.lang.Boolean setDefaultVersion) {
                this.setDefaultVersion = setDefaultVersion;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateConfigurationProperty#getSetDefaultVersion}
             * @param setDefaultVersion Set the specified Amazon EC2 launch template as the default launch template for the specified account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder setDefaultVersion(software.amazon.awscdk.core.IResolvable setDefaultVersion) {
                this.setDefaultVersion = setDefaultVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LaunchTemplateConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LaunchTemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchTemplateConfigurationProperty {
            private final java.lang.String accountId;
            private final java.lang.String launchTemplateId;
            private final java.lang.Object setDefaultVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accountId = software.amazon.jsii.Kernel.get(this, "accountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.launchTemplateId = software.amazon.jsii.Kernel.get(this, "launchTemplateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.setDefaultVersion = software.amazon.jsii.Kernel.get(this, "setDefaultVersion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accountId = builder.accountId;
                this.launchTemplateId = builder.launchTemplateId;
                this.setDefaultVersion = builder.setDefaultVersion;
            }

            @Override
            public final java.lang.String getAccountId() {
                return this.accountId;
            }

            @Override
            public final java.lang.String getLaunchTemplateId() {
                return this.launchTemplateId;
            }

            @Override
            public final java.lang.Object getSetDefaultVersion() {
                return this.setDefaultVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccountId() != null) {
                    data.set("accountId", om.valueToTree(this.getAccountId()));
                }
                if (this.getLaunchTemplateId() != null) {
                    data.set("launchTemplateId", om.valueToTree(this.getLaunchTemplateId()));
                }
                if (this.getSetDefaultVersion() != null) {
                    data.set("setDefaultVersion", om.valueToTree(this.getSetDefaultVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_imagebuilder.CfnDistributionConfiguration.LaunchTemplateConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LaunchTemplateConfigurationProperty.Jsii$Proxy that = (LaunchTemplateConfigurationProperty.Jsii$Proxy) o;

                if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) return false;
                if (this.launchTemplateId != null ? !this.launchTemplateId.equals(that.launchTemplateId) : that.launchTemplateId != null) return false;
                return this.setDefaultVersion != null ? this.setDefaultVersion.equals(that.setDefaultVersion) : that.setDefaultVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accountId != null ? this.accountId.hashCode() : 0;
                result = 31 * result + (this.launchTemplateId != null ? this.launchTemplateId.hashCode() : 0);
                result = 31 * result + (this.setDefaultVersion != null ? this.setDefaultVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The container repository where the output container image is stored.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * TargetContainerRepositoryProperty targetContainerRepositoryProperty = TargetContainerRepositoryProperty.builder()
     *         .repositoryName("repositoryName")
     *         .service("service")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_imagebuilder.CfnDistributionConfiguration.TargetContainerRepositoryProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetContainerRepositoryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetContainerRepositoryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the container repository where the output container image is stored.
         * <p>
         * This name is prefixed by the repository location.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRepositoryName() {
            return null;
        }

        /**
         * Specifies the service in which this image was registered.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getService() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetContainerRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetContainerRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetContainerRepositoryProperty> {
            java.lang.String repositoryName;
            java.lang.String service;

            /**
             * Sets the value of {@link TargetContainerRepositoryProperty#getRepositoryName}
             * @param repositoryName The name of the container repository where the output container image is stored.
             *                       This name is prefixed by the repository location.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repositoryName(java.lang.String repositoryName) {
                this.repositoryName = repositoryName;
                return this;
            }

            /**
             * Sets the value of {@link TargetContainerRepositoryProperty#getService}
             * @param service Specifies the service in which this image was registered.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder service(java.lang.String service) {
                this.service = service;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetContainerRepositoryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetContainerRepositoryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetContainerRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetContainerRepositoryProperty {
            private final java.lang.String repositoryName;
            private final java.lang.String service;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.repositoryName = software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.service = software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.repositoryName = builder.repositoryName;
                this.service = builder.service;
            }

            @Override
            public final java.lang.String getRepositoryName() {
                return this.repositoryName;
            }

            @Override
            public final java.lang.String getService() {
                return this.service;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRepositoryName() != null) {
                    data.set("repositoryName", om.valueToTree(this.getRepositoryName()));
                }
                if (this.getService() != null) {
                    data.set("service", om.valueToTree(this.getService()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_imagebuilder.CfnDistributionConfiguration.TargetContainerRepositoryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetContainerRepositoryProperty.Jsii$Proxy that = (TargetContainerRepositoryProperty.Jsii$Proxy) o;

                if (this.repositoryName != null ? !this.repositoryName.equals(that.repositoryName) : that.repositoryName != null) return false;
                return this.service != null ? this.service.equals(that.service) : that.service == null;
            }

            @Override
            public final int hashCode() {
                int result = this.repositoryName != null ? this.repositoryName.hashCode() : 0;
                result = 31 * result + (this.service != null ? this.service.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.imagebuilder.CfnDistributionConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.imagebuilder.CfnDistributionConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.imagebuilder.CfnDistributionConfigurationProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.imagebuilder.CfnDistributionConfigurationProps.Builder();
        }

        /**
         * The distributions of this distribution configuration formatted as an array of Distribution objects.
         * <p>
         * @return {@code this}
         * @param distributions The distributions of this distribution configuration formatted as an array of Distribution objects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributions(final software.amazon.awscdk.core.IResolvable distributions) {
            this.props.distributions(distributions);
            return this;
        }
        /**
         * The distributions of this distribution configuration formatted as an array of Distribution objects.
         * <p>
         * @return {@code this}
         * @param distributions The distributions of this distribution configuration formatted as an array of Distribution objects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributions(final java.util.List<? extends java.lang.Object> distributions) {
            this.props.distributions(distributions);
            return this;
        }

        /**
         * The name of this distribution configuration.
         * <p>
         * @return {@code this}
         * @param name The name of this distribution configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The description of this distribution configuration.
         * <p>
         * @return {@code this}
         * @param description The description of this distribution configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The tags of this distribution configuration.
         * <p>
         * @return {@code this}
         * @param tags The tags of this distribution configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.imagebuilder.CfnDistributionConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.imagebuilder.CfnDistributionConfiguration build() {
            return new software.amazon.awscdk.services.imagebuilder.CfnDistributionConfiguration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
