package software.amazon.awscdk.services.identitystore;

/**
 * Properties for defining a `CfnGroupMembership`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.identitystore.*;
 * CfnGroupMembershipProps cfnGroupMembershipProps = CfnGroupMembershipProps.builder()
 *         .groupId("groupId")
 *         .identityStoreId("identityStoreId")
 *         .memberId(MemberIdProperty.builder()
 *                 .userId("userId")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:02.893Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_identitystore.CfnGroupMembershipProps")
@software.amazon.jsii.Jsii.Proxy(CfnGroupMembershipProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGroupMembershipProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::IdentityStore::GroupMembership.GroupId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGroupId();

    /**
     * `AWS::IdentityStore::GroupMembership.IdentityStoreId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdentityStoreId();

    /**
     * An object containing the identifier of a group member.
     * <p>
     * Setting <code>MemberId</code> 's <code>UserId</code> field to a specific User's ID indicates we should consider that User as a group member.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getMemberId();

    /**
     * @return a {@link Builder} of {@link CfnGroupMembershipProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGroupMembershipProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGroupMembershipProps> {
        java.lang.String groupId;
        java.lang.String identityStoreId;
        java.lang.Object memberId;

        /**
         * Sets the value of {@link CfnGroupMembershipProps#getGroupId}
         * @param groupId `AWS::IdentityStore::GroupMembership.GroupId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupId(java.lang.String groupId) {
            this.groupId = groupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnGroupMembershipProps#getIdentityStoreId}
         * @param identityStoreId `AWS::IdentityStore::GroupMembership.IdentityStoreId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityStoreId(java.lang.String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        /**
         * Sets the value of {@link CfnGroupMembershipProps#getMemberId}
         * @param memberId An object containing the identifier of a group member. This parameter is required.
         *                 Setting <code>MemberId</code> 's <code>UserId</code> field to a specific User's ID indicates we should consider that User as a group member.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memberId(software.amazon.awscdk.services.identitystore.CfnGroupMembership.MemberIdProperty memberId) {
            this.memberId = memberId;
            return this;
        }

        /**
         * Sets the value of {@link CfnGroupMembershipProps#getMemberId}
         * @param memberId An object containing the identifier of a group member. This parameter is required.
         *                 Setting <code>MemberId</code> 's <code>UserId</code> field to a specific User's ID indicates we should consider that User as a group member.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memberId(software.amazon.awscdk.core.IResolvable memberId) {
            this.memberId = memberId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGroupMembershipProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGroupMembershipProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGroupMembershipProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGroupMembershipProps {
        private final java.lang.String groupId;
        private final java.lang.String identityStoreId;
        private final java.lang.Object memberId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.groupId = software.amazon.jsii.Kernel.get(this, "groupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.identityStoreId = software.amazon.jsii.Kernel.get(this, "identityStoreId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.memberId = software.amazon.jsii.Kernel.get(this, "memberId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.groupId = java.util.Objects.requireNonNull(builder.groupId, "groupId is required");
            this.identityStoreId = java.util.Objects.requireNonNull(builder.identityStoreId, "identityStoreId is required");
            this.memberId = java.util.Objects.requireNonNull(builder.memberId, "memberId is required");
        }

        @Override
        public final java.lang.String getGroupId() {
            return this.groupId;
        }

        @Override
        public final java.lang.String getIdentityStoreId() {
            return this.identityStoreId;
        }

        @Override
        public final java.lang.Object getMemberId() {
            return this.memberId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("groupId", om.valueToTree(this.getGroupId()));
            data.set("identityStoreId", om.valueToTree(this.getIdentityStoreId()));
            data.set("memberId", om.valueToTree(this.getMemberId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_identitystore.CfnGroupMembershipProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGroupMembershipProps.Jsii$Proxy that = (CfnGroupMembershipProps.Jsii$Proxy) o;

            if (!groupId.equals(that.groupId)) return false;
            if (!identityStoreId.equals(that.identityStoreId)) return false;
            return this.memberId.equals(that.memberId);
        }

        @Override
        public final int hashCode() {
            int result = this.groupId.hashCode();
            result = 31 * result + (this.identityStoreId.hashCode());
            result = 31 * result + (this.memberId.hashCode());
            return result;
        }
    }
}
