package software.amazon.awscdk.services.iam;

/**
 * (experimental) IAM Role.
 * <p>
 * Defines an IAM role. The role is created with an assume policy document associated with
 * the specified AWS service principal defined in <code>serviceAssumeRole</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Role lambdaRole = Role.Builder.create(this, "Role")
 *         .assumedBy(new ServicePrincipal("lambda.amazonaws.com"))
 *         .description("Example role...")
 *         .build();
 * Stream stream = Stream.Builder.create(this, "MyEncryptedStream")
 *         .encryption(StreamEncryption.KMS)
 *         .build();
 * // give lambda permissions to read stream
 * stream.grantRead(lambdaRole);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:02.863Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iam.Role")
public class Role extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.iam.IRole {

    protected Role(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Role(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Role(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.RoleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Import an external role by ARN.
     * <p>
     * If the imported Role ARN is a Token (such as a
     * <code>CfnParameter.valueAsString</code> or a <code>Fn.importValue()</code>) <em>and</em> the referenced
     * role has a <code>path</code> (like <code>arn:...:role/AdminRoles/Alice</code>), the
     * <code>roleName</code> property will not resolve to the correct value. Instead it
     * will resolve to the first path component. We unfortunately cannot express
     * the correct calculation of the full path name as a CloudFormation
     * expression. In this scenario the Role ARN should be supplied without the
     * <code>path</code> in order to resolve the correct role resource.
     * <p>
     * @param scope construct scope. This parameter is required.
     * @param id construct id. This parameter is required.
     * @param roleArn the ARN of the role to import. This parameter is required.
     * @param options allow customizing the behavior of the returned role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole fromRoleArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String roleArn, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.FromRoleArnOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Role.class, "fromRoleArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(roleArn, "roleArn is required"), options });
    }

    /**
     * (experimental) Import an external role by ARN.
     * <p>
     * If the imported Role ARN is a Token (such as a
     * <code>CfnParameter.valueAsString</code> or a <code>Fn.importValue()</code>) <em>and</em> the referenced
     * role has a <code>path</code> (like <code>arn:...:role/AdminRoles/Alice</code>), the
     * <code>roleName</code> property will not resolve to the correct value. Instead it
     * will resolve to the first path component. We unfortunately cannot express
     * the correct calculation of the full path name as a CloudFormation
     * expression. In this scenario the Role ARN should be supplied without the
     * <code>path</code> in order to resolve the correct role resource.
     * <p>
     * @param scope construct scope. This parameter is required.
     * @param id construct id. This parameter is required.
     * @param roleArn the ARN of the role to import. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole fromRoleArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String roleArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Role.class, "fromRoleArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(roleArn, "roleArn is required") });
    }

    /**
     * (experimental) Import an external role by name.
     * <p>
     * The imported role is assumed to exist in the same account as the account
     * the scope's containing Stack is being deployed to.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param roleName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole fromRoleName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String roleName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Role.class, "fromRoleName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(roleName, "roleName is required") });
    }

    /**
     * (experimental) Attaches a managed policy to this role.
     * <p>
     * @param policy The the managed policy to attach. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addManagedPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IManagedPolicy policy) {
        software.amazon.jsii.Kernel.call(this, "addManagedPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
    }

    /**
     * (experimental) Add to the policy of this principal.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Boolean addToPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return software.amazon.jsii.Kernel.call(this, "addToPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * (experimental) Adds a permission to the role's default policy document.
     * <p>
     * If there is no default policy attached to this role, it will be created.
     * <p>
     * @param statement The permission statement to add to the policy document. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult addToPrincipalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return software.amazon.jsii.Kernel.call(this, "addToPrincipalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * (experimental) Attaches a policy to this role.
     * <p>
     * @param policy The policy to attach. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void attachInlinePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Policy policy) {
        software.amazon.jsii.Kernel.call(this, "attachInlinePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
    }

    /**
     * (experimental) Grant the actions defined in actions to the identity Principal on this resource.
     * <p>
     * @param grantee This parameter is required.
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * (experimental) Grant permissions to the given principal to assume this role.
     * <p>
     * @param identity This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantAssumeRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal identity) {
        return software.amazon.jsii.Kernel.call(this, "grantAssumeRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * (experimental) Grant permissions to the given principal to pass this role.
     * <p>
     * @param identity This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPassRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal identity) {
        return software.amazon.jsii.Kernel.call(this, "grantPassRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * (experimental) Validate the current construct.
     * <p>
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) Return a copy of this Role object whose Policies will not be updated.
     * <p>
     * Use the object returned by this method if you want this Role to be used by
     * a construct without it automatically updating the Role's Policies.
     * <p>
     * If you do, you are responsible for adding the correct statements to the
     * Role's policies yourself.
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole withoutPolicyUpdates(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.WithoutPolicyUpdatesOptions options) {
        return software.amazon.jsii.Kernel.call(this, "withoutPolicyUpdates", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class), new Object[] { options });
    }

    /**
     * (experimental) Return a copy of this Role object whose Policies will not be updated.
     * <p>
     * Use the object returned by this method if you want this Role to be used by
     * a construct without it automatically updating the Role's Policies.
     * <p>
     * If you do, you are responsible for adding the correct statements to the
     * Role's policies yourself.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole withoutPolicyUpdates() {
        return software.amazon.jsii.Kernel.call(this, "withoutPolicyUpdates", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * (experimental) When this Principal is used in an AssumeRole policy, the action to use.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssumeRoleAction() {
        return software.amazon.jsii.Kernel.get(this, "assumeRoleAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * (experimental) Returns the role.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
        return software.amazon.jsii.Kernel.get(this, "policyFragment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class));
    }

    /**
     * (experimental) Returns the ARN of this role.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Returns the stable and unique string identifying the role.
     * <p>
     * For example,
     * AIDAJQABLZS4A3QDU576Q.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleId() {
        return software.amazon.jsii.Kernel.get(this, "roleId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Returns the name of the role.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleName() {
        return software.amazon.jsii.Kernel.get(this, "roleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The assume role policy document associated with this role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyDocument getAssumeRolePolicy() {
        return software.amazon.jsii.Kernel.get(this, "assumeRolePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
    }

    /**
     * (experimental) Returns the permissions boundary attached to this role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IManagedPolicy getPermissionsBoundary() {
        return software.amazon.jsii.Kernel.get(this, "permissionsBoundary", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IManagedPolicy.class));
    }

    /**
     * (experimental) The AWS account ID of this principal.
     * <p>
     * Can be undefined when the account is not known
     * (for example, for service principals).
     * Can be a Token - in that case,
     * it's assumed to be AWS::AccountId.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getPrincipalAccount() {
        return software.amazon.jsii.Kernel.get(this, "principalAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.iam.Role}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iam.Role> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iam.RoleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iam.RoleProps.Builder();
        }

        /**
         * (experimental) The IAM principal (i.e. `new ServicePrincipal('sns.amazonaws.com')`) which can assume this role.
         * <p>
         * You can later modify the assume role policy document by accessing it via
         * the <code>assumeRolePolicy</code> property.
         * <p>
         * @return {@code this}
         * @param assumedBy The IAM principal (i.e. `new ServicePrincipal('sns.amazonaws.com')`) which can assume this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assumedBy(final software.amazon.awscdk.services.iam.IPrincipal assumedBy) {
            this.props.assumedBy(assumedBy);
            return this;
        }

        /**
         * (experimental) A description of the role.
         * <p>
         * It can be up to 1000 characters long.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description A description of the role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * (deprecated) ID that the role assumer needs to provide when assuming this role.
         * <p>
         * If the configured and provided external IDs do not match, the
         * AssumeRole operation will fail.
         * <p>
         * Default: No external ID required
         * <p>
         * @return {@code this}
         * @deprecated see {@link externalIds}
         * @param externalId ID that the role assumer needs to provide when assuming this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder externalId(final java.lang.String externalId) {
            this.props.externalId(externalId);
            return this;
        }

        /**
         * (experimental) List of IDs that the role assumer needs to provide one of when assuming this role.
         * <p>
         * If the configured and provided external IDs do not match, the
         * AssumeRole operation will fail.
         * <p>
         * Default: No external ID required
         * <p>
         * @return {@code this}
         * @param externalIds List of IDs that the role assumer needs to provide one of when assuming this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder externalIds(final java.util.List<java.lang.String> externalIds) {
            this.props.externalIds(externalIds);
            return this;
        }

        /**
         * (experimental) A list of named policies to inline into this role.
         * <p>
         * These policies will be
         * created with the role, whereas those added by <code>addToPolicy</code> are added
         * using a separate CloudFormation resource (allowing a way around circular
         * dependencies that could otherwise be introduced).
         * <p>
         * Default: - No policy is inlined in the Role resource.
         * <p>
         * @return {@code this}
         * @param inlinePolicies A list of named policies to inline into this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder inlinePolicies(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.iam.PolicyDocument> inlinePolicies) {
            this.props.inlinePolicies(inlinePolicies);
            return this;
        }

        /**
         * (experimental) A list of managed policies associated with this role.
         * <p>
         * You can add managed policies later using
         * <code>addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName(policyName))</code>.
         * <p>
         * Default: - No managed policies.
         * <p>
         * @return {@code this}
         * @param managedPolicies A list of managed policies associated with this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder managedPolicies(final java.util.List<? extends software.amazon.awscdk.services.iam.IManagedPolicy> managedPolicies) {
            this.props.managedPolicies(managedPolicies);
            return this;
        }

        /**
         * (experimental) The maximum session duration that you want to set for the specified role.
         * <p>
         * This setting can have a value from 1 hour (3600sec) to 12 (43200sec) hours.
         * <p>
         * Anyone who assumes the role from the AWS CLI or API can use the
         * DurationSeconds API parameter or the duration-seconds CLI parameter to
         * request a longer session. The MaxSessionDuration setting determines the
         * maximum duration that can be requested using the DurationSeconds
         * parameter.
         * <p>
         * If users don't specify a value for the DurationSeconds parameter, their
         * security credentials are valid for one hour by default. This applies when
         * you use the AssumeRole* API operations or the assume-role* CLI operations
         * but does not apply when you use those operations to create a console URL.
         * <p>
         * Default: Duration.hours(1)
         * <p>
         * @return {@code this}
         * @param maxSessionDuration The maximum session duration that you want to set for the specified role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxSessionDuration(final software.amazon.awscdk.core.Duration maxSessionDuration) {
            this.props.maxSessionDuration(maxSessionDuration);
            return this;
        }

        /**
         * (experimental) The path associated with this role.
         * <p>
         * For information about IAM paths, see
         * Friendly Names and Paths in IAM User Guide.
         * <p>
         * Default: /
         * <p>
         * @return {@code this}
         * @param path The path associated with this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder path(final java.lang.String path) {
            this.props.path(path);
            return this;
        }

        /**
         * (experimental) AWS supports permissions boundaries for IAM entities (users or roles).
         * <p>
         * A permissions boundary is an advanced feature for using a managed policy
         * to set the maximum permissions that an identity-based policy can grant to
         * an IAM entity. An entity's permissions boundary allows it to perform only
         * the actions that are allowed by both its identity-based policies and its
         * permissions boundaries.
         * <p>
         * Default: - No permissions boundary.
         * <p>
         * @return {@code this}
         * @param permissionsBoundary AWS supports permissions boundaries for IAM entities (users or roles). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder permissionsBoundary(final software.amazon.awscdk.services.iam.IManagedPolicy permissionsBoundary) {
            this.props.permissionsBoundary(permissionsBoundary);
            return this;
        }

        /**
         * (experimental) A name for the IAM role.
         * <p>
         * For valid values, see the RoleName parameter for
         * the CreateRole action in the IAM API Reference.
         * <p>
         * IMPORTANT: If you specify a name, you cannot perform updates that require
         * replacement of this resource. You can perform updates that require no or
         * some interruption. If you must replace the resource, specify a new name.
         * <p>
         * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
         * acknowledge your template's capabilities. For more information, see
         * Acknowledging IAM Resources in AWS CloudFormation Templates.
         * <p>
         * Default: - AWS CloudFormation generates a unique physical ID and uses that ID
         * for the role name.
         * <p>
         * @return {@code this}
         * @param roleName A name for the IAM role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder roleName(final java.lang.String roleName) {
            this.props.roleName(roleName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iam.Role}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.iam.Role build() {
            return new software.amazon.awscdk.services.iam.Role(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
